/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api.commands;

import com.sun.jna.NativeLong;
import edsdk.api.CanonCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.bindings.EdsPictureStyleDesc;
import edsdk.bindings.EdsPoint;
import edsdk.bindings.EdsRect;
import edsdk.bindings.EdsSize;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;

public abstract class SetPropertyCommand<T>
extends CanonCommand<Boolean> {
    private final CanonConstants.EdsPropertyID property;
    private final long param;
    private final T value;
    private final Class<T> klass;
    private final boolean isLiveViewCommand;
    private final int liveViewRetryCount = 2;
    private final int busyRetryCount = 500;

    public SetPropertyCommand(CanonConstants.EdsPropertyID property, T value) {
        this(property, 0L, value, false);
    }

    public SetPropertyCommand(CanonConstants.EdsPropertyID property, long param, T value) {
        this(property, param, value, false);
    }

    public SetPropertyCommand(CanonConstants.EdsPropertyID property, T value, boolean isLiveViewCommand) {
        this(property, 0L, value, isLiveViewCommand);
    }

    public SetPropertyCommand(CanonConstants.EdsPropertyID property, long param, T value, boolean isLiveViewCommand) {
        this.property = property;
        this.param = param;
        this.value = value;
        this.klass = value != null ? value.getClass() : null;
        this.isLiveViewCommand = isLiveViewCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Exception t;
        block34: {
            EdSdkLibrary.EdsBaseRef.ByReference[] references;
            block33: {
                block32: {
                    if (this.value == null) {
                        throw new IllegalStateException("Cannot set a null value!");
                    }
                    t = null;
                    references = null;
                    try {
                        int retries;
                        EdSdkLibrary.EdsBaseRef baseRef;
                        block36: {
                            block35: {
                                if (!this.isLiveViewCommand) break block35;
                                if (!CanonUtils.isLiveViewEnabled(this.camera.getEdsCamera(), false)) {
                                    System.err.println("Live view is not enabled!");
                                    this.setResult(null);
                                    return;
                                }
                                for (int i = 0; i < 2 && references == null; ++i) {
                                    if (i > 0) {
                                        Thread.sleep(100L);
                                    }
                                    references = CanonUtils.getLiveViewImageReference(this.camera.getEdsCamera());
                                }
                                if (references != null) {
                                    baseRef = references[0].getValue();
                                    break block36;
                                } else {
                                    System.err.println("Could not retrieve live view image reference!");
                                    this.setResult(null);
                                    if (references == null) return;
                                    break block32;
                                }
                            }
                            baseRef = this.camera.getEdsCamera();
                        }
                        CanonConstants.EdsDataType type = CanonUtils.getPropertyType(baseRef, this.property, this.param);
                        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_DEVICE_BUSY;
                        for (retries = 0; retries < 500 && err == CanonConstants.EdsError.EDS_ERR_DEVICE_BUSY; ++retries) {
                            err = CanonConstants.EdsError.EDS_ERR_NOT_SUPPORTED;
                            switch (type) {
                                case kEdsDataType_Int32: 
                                case kEdsDataType_UInt32: {
                                    long longValue = Boolean.class.isAssignableFrom(this.klass) ? ((Boolean)this.value != false ? 1L : 0L) : (CanonConstants.DescriptiveEnum.class.isAssignableFrom(this.klass) ? ((Number)((CanonConstants.DescriptiveEnum)this.value).value()).longValue() : ((Long)this.value).longValue());
                                    err = CanonUtils.setPropertyData(baseRef, this.property, this.param, longValue);
                                    break;
                                }
                                case kEdsDataType_String: 
                                case kEdsDataType_Point: 
                                case kEdsDataType_Rect: 
                                case kEdsDataType_Time: 
                                case kEdsDataType_FocusInfo: 
                                case kEdsDataType_PictureStyleDesc: {
                                    err = CanonUtils.setPropertyDataAdvanced(baseRef, this.property, this.param, this.value);
                                    break;
                                }
                                case kEdsDataType_ByteBlock: 
                                case kEdsDataType_Int32_Array: 
                                case kEdsDataType_UInt32_Array: {
                                    int[] array;
                                    if (CanonConstants.DescriptiveEnum[].class.isAssignableFrom(this.klass)) {
                                        CanonConstants.DescriptiveEnum[] valueArray = (CanonConstants.DescriptiveEnum[])this.value;
                                        array = new int[valueArray.length];
                                        for (int i = 0; i < valueArray.length; ++i) {
                                            array[i] = ((Number)valueArray[i].value()).intValue();
                                        }
                                    } else if (CanonConstants.DescriptiveEnum.class.isAssignableFrom(this.klass)) {
                                        array = new int[]{((Number)((CanonConstants.DescriptiveEnum)this.value).value()).intValue()};
                                    } else if (EdsRect.class.isAssignableFrom(this.klass)) {
                                        EdsRect edsRect = (EdsRect)((Object)this.value);
                                        array = new int[]{edsRect.point.x.intValue(), edsRect.point.y.intValue(), edsRect.size.width.intValue(), edsRect.size.height.intValue()};
                                    } else if (EdsSize.class.isAssignableFrom(this.klass)) {
                                        EdsSize edsSize = (EdsSize)((Object)this.value);
                                        array = new int[]{edsSize.width.intValue(), edsSize.height.intValue()};
                                    } else {
                                        array = (int[])this.value;
                                    }
                                    err = CanonUtils.setPropertyDataAdvanced(baseRef, this.property, this.param, array);
                                    break;
                                }
                                default: {
                                    System.err.println(type.description() + " (" + type.name() + ") is not currently supported by SetPropertyCommand. Likely this camera does not support property " + this.property.name() + " in the current mode or at all.");
                                }
                            }
                            Thread.sleep(10L);
                        }
                        if (retries > 1) {
                            System.out.println("Set property: " + this.property.name() + " - " + this.property.description() + (this.param > 0L ? Long.valueOf(this.param) : "") + " = " + this.value + ", result " + err.value() + ": " + err.name() + " - " + err.description() + " after " + retries + " tries");
                        }
                        this.setResult(err == CanonConstants.EdsError.EDS_ERR_OK);
                        if (references == null) return;
                        break block33;
                    }
                    catch (IllegalArgumentException e) {
                        t = e;
                        break block34;
                    }
                    catch (InterruptedException e) {
                        t = e;
                        break block34;
                    }
                }
                CanonUtils.release(references);
                return;
            }
            CanonUtils.release(references);
            return;
            finally {
                if (references != null) {
                    CanonUtils.release(references);
                }
            }
        }
        System.err.println(t.getMessage());
        this.setResult(null);
    }

    public static class LiveViewZoomPosition
    extends SetPropertyCommand<EdsPoint> {
        public LiveViewZoomPosition(EdsPoint value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ZoomPosition, value);
        }

        public LiveViewZoomPosition(long x, long y) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ZoomPosition, new EdsPoint(new NativeLong(x), new NativeLong(y)));
        }
    }

    public static class LiveViewZoomRatio
    extends SetPropertyCommand<CanonConstants.EdsEvfZoom> {
        public LiveViewZoomRatio(CanonConstants.EdsEvfZoom value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_Zoom, value);
        }
    }

    public static class LiveViewAutoFocusMode
    extends SetPropertyCommand<CanonConstants.EdsEvfAFMode> {
        public LiveViewAutoFocusMode(CanonConstants.EdsEvfAFMode value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_AFMode, value);
        }
    }

    public static class LiveViewWhiteBalance
    extends SetPropertyCommand<CanonConstants.EdsWhiteBalance> {
        public LiveViewWhiteBalance(CanonConstants.EdsWhiteBalance value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_WhiteBalance, value);
        }
    }

    public static class PictureStyle
    extends SetPropertyCommand<CanonConstants.EdsPictureStyle> {
        public PictureStyle(CanonConstants.EdsPictureStyle value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_PictureStyle, value);
        }
    }

    public static class ColorSpace
    extends SetPropertyCommand<CanonConstants.EdsColorSpace> {
        public ColorSpace(CanonConstants.EdsColorSpace value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ColorSpace, value);
        }
    }

    public static class WhiteBalance
    extends SetPropertyCommand<CanonConstants.EdsWhiteBalance> {
        public WhiteBalance(CanonConstants.EdsWhiteBalance value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_WhiteBalance, value);
        }
    }

    public static class ImageQuality
    extends SetPropertyCommand<CanonConstants.EdsImageQuality> {
        public ImageQuality(CanonConstants.EdsImageQuality value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ImageQuality, value);
        }
    }

    public static class ShootingMode
    extends SetPropertyCommand<CanonConstants.EdsAEMode> {
        public ShootingMode(CanonConstants.EdsAEMode value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_AEModeSelect, value);
        }
    }

    public static class ExposureCompensation
    extends SetPropertyCommand<CanonConstants.EdsExposureCompensation> {
        public ExposureCompensation(CanonConstants.EdsExposureCompensation value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ExposureCompensation, value);
        }
    }

    public static class ShutterSpeed
    extends SetPropertyCommand<CanonConstants.EdsTv> {
        public ShutterSpeed(CanonConstants.EdsTv value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Tv, value);
        }
    }

    public static class ApertureValue
    extends SetPropertyCommand<CanonConstants.EdsAv> {
        public ApertureValue(CanonConstants.EdsAv value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Av, value);
        }
    }

    public static class AutoFocusMode
    extends SetPropertyCommand<CanonConstants.EdsAFMode> {
        public AutoFocusMode(CanonConstants.EdsAFMode value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_AFMode, value);
        }
    }

    public static class MeteringMode
    extends SetPropertyCommand<CanonConstants.EdsMeteringMode> {
        public MeteringMode(CanonConstants.EdsMeteringMode value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_MeteringMode, value);
        }
    }

    public static class ISOSpeed
    extends SetPropertyCommand<CanonConstants.EdsISOSpeed> {
        public ISOSpeed(CanonConstants.EdsISOSpeed value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ISOSpeed, value);
        }
    }

    public static class DriveMode
    extends SetPropertyCommand<CanonConstants.EdsDriveMode> {
        public DriveMode(CanonConstants.EdsDriveMode value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_DriveMode, value);
        }
    }

    public static class LiveViewDepthOfFieldInPreview
    extends SetPropertyCommand<Boolean> {
        public LiveViewDepthOfFieldInPreview(boolean value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_DepthOfFieldPreview, value);
        }
    }

    public static class LiveViewColorTemperature
    extends SetPropertyCommand<Long> {
        public LiveViewColorTemperature(long value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ColorTemperature, value);
        }
    }

    public static class LiveViewMode
    extends SetPropertyCommand<Boolean> {
        public LiveViewMode(boolean value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_Mode, value);
        }
    }

    public static class LiveViewOutputDevice
    extends SetPropertyCommand<CanonConstants.EdsEvfOutputDevice> {
        public LiveViewOutputDevice(CanonConstants.EdsEvfOutputDevice value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_OutputDevice, value);
        }
    }

    public static class MovieShootingStatus
    extends SetPropertyCommand<Long> {
        public MovieShootingStatus(long value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Record, value);
        }
    }

    public static class PictureStyleDescription
    extends SetPropertyCommand<EdsPictureStyleDesc> {
        public PictureStyleDescription(EdsPictureStyleDesc value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_PictureStyleDesc, value);
        }

        public PictureStyleDescription(long contrast, long sharpness, long saturation, long colorTone, CanonConstants.EdsFilterEffect filterEffect, CanonConstants.EdsTonigEffect toningEffect) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_PictureStyleDesc, new EdsPictureStyleDesc(new NativeLong(contrast), new NativeLong(sharpness), new NativeLong(saturation), new NativeLong(colorTone), new NativeLong((long)filterEffect.value().intValue()), new NativeLong((long)toningEffect.value().intValue())));
        }
    }

    public static class ParameterSet
    extends SetPropertyCommand<Long> {
        public ParameterSet(long value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ParameterSet, value);
        }
    }

    public static class WhiteBalanceShift
    extends SetPropertyCommand<int[]> {
        public WhiteBalanceShift(int[] value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_WhiteBalanceShift, value);
        }
    }

    public static class ColorTemperature
    extends SetPropertyCommand<Long> {
        public ColorTemperature(long value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ColorTemperature, value);
        }
    }

    public static class JPEGQuality
    extends SetPropertyCommand<Long> {
        public JPEGQuality(long value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_JpegQuality, value);
        }
    }

    public static class HardDriveDirectoryStructure
    extends SetPropertyCommand<String> {
        public HardDriveDirectoryStructure(String value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_HDDirectoryStructure, value);
        }
    }

    public static class SaveTo
    extends SetPropertyCommand<CanonConstants.EdsSaveTo> {
        public SaveTo(CanonConstants.EdsSaveTo value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_SaveTo, value);
        }
    }

    public static class OwnerName
    extends SetPropertyCommand<String> {
        public OwnerName(String value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_OwnerName, value);
        }
    }

    public static class Copyright
    extends SetPropertyCommand<String> {
        public Copyright(String value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Copyright, value);
        }
    }

    public static class Artist
    extends SetPropertyCommand<String> {
        public Artist(String value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Artist, value);
        }
    }

    public static class CustomFunction
    extends SetPropertyCommand<Long> {
        public CustomFunction(CanonConstants.EdsCustomFunction customFunction, long value) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_CFn, customFunction.value().intValue(), value);
        }
    }

    public static class EnumData
    extends SetPropertyCommand<CanonConstants.DescriptiveEnum<? extends Number>> {
        public EnumData(CanonConstants.EdsPropertyID property, CanonConstants.DescriptiveEnum<? extends Number> value, boolean isLiveViewCommand) {
            super(property, value, true);
        }

        public EnumData(CanonConstants.EdsPropertyID property, CanonConstants.DescriptiveEnum<? extends Number> value) {
            super(property, value);
        }
    }

    public static class Data
    extends SetPropertyCommand<Long> {
        public Data(CanonConstants.EdsPropertyID property, long value, boolean isLiveViewCommand) {
            super(property, Long.valueOf(value), true);
        }

        public Data(CanonConstants.EdsPropertyID property, long value) {
            super(property, value);
        }
    }
}

