/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api.commands;

import edsdk.api.CanonCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.bindings.EdsPropertyDesc;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;
import java.util.Arrays;

public class GetPropertyDescCommand
extends CanonCommand<EdsPropertyDesc> {
    private final CanonConstants.EdsPropertyID property;

    public GetPropertyDescCommand(CanonConstants.EdsPropertyID property) {
        this.property = property;
    }

    @Override
    public void run() {
        IllegalArgumentException t = null;
        try {
            EdsPropertyDesc properties = CanonUtils.getPropertyDesc((EdSdkLibrary.EdsBaseRef)this.camera.getEdsCamera(), this.property);
            this.setResult(properties);
            return;
        }
        catch (IllegalArgumentException e) {
            t = e;
            System.err.println(t.getMessage());
            this.setResult(null);
            return;
        }
    }

    public static class LiveViewAutoFocusMode
    extends GetEnumPropertyDescCommand<CanonConstants.EdsEvfAFMode> {
        public LiveViewAutoFocusMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_AFMode, CanonConstants.EdsEvfAFMode[].class);
        }
    }

    public static class LiveViewWhiteBalance
    extends GetEnumPropertyDescCommand<CanonConstants.EdsWhiteBalance> {
        public LiveViewWhiteBalance() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_WhiteBalance, CanonConstants.EdsWhiteBalance[].class);
        }
    }

    public static class PictureStyle
    extends GetEnumPropertyDescCommand<CanonConstants.EdsPictureStyle> {
        public PictureStyle() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_PictureStyle, CanonConstants.EdsPictureStyle[].class);
        }
    }

    public static class ColorSpace
    extends GetEnumPropertyDescCommand<CanonConstants.EdsColorSpace> {
        public ColorSpace() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ColorSpace, CanonConstants.EdsColorSpace[].class);
        }
    }

    public static class WhiteBalance
    extends GetEnumPropertyDescCommand<CanonConstants.EdsWhiteBalance> {
        public WhiteBalance() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_WhiteBalance, CanonConstants.EdsWhiteBalance[].class);
        }
    }

    public static class ImageQuality
    extends GetEnumPropertyDescCommand<CanonConstants.EdsImageQuality> {
        public ImageQuality() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ImageQuality, CanonConstants.EdsImageQuality[].class);
        }
    }

    public static class ShootingMode
    extends GetEnumPropertyDescCommand<CanonConstants.EdsAEMode> {
        public ShootingMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_AEMode, CanonConstants.EdsAEMode[].class);
        }
    }

    public static class ExposureCompensation
    extends GetEnumPropertyDescCommand<CanonConstants.EdsExposureCompensation> {
        public ExposureCompensation() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ExposureCompensation, CanonConstants.EdsExposureCompensation[].class);
        }
    }

    public static class ShutterSpeed
    extends GetEnumPropertyDescCommand<CanonConstants.EdsTv> {
        public ShutterSpeed() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Tv, CanonConstants.EdsTv[].class);
        }
    }

    public static class ApertureValue
    extends GetEnumPropertyDescCommand<CanonConstants.EdsAv> {
        public ApertureValue() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Av, CanonConstants.EdsAv[].class);
        }
    }

    public static class AutoFocusMode
    extends GetEnumPropertyDescCommand<CanonConstants.EdsAFMode> {
        public AutoFocusMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_AFMode, CanonConstants.EdsAFMode[].class);
        }
    }

    public static class MeteringMode
    extends GetEnumPropertyDescCommand<CanonConstants.EdsMeteringMode> {
        public MeteringMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_MeteringMode, CanonConstants.EdsMeteringMode[].class);
        }
    }

    public static class ISOSpeed
    extends GetEnumPropertyDescCommand<CanonConstants.EdsISOSpeed> {
        public ISOSpeed() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ISOSpeed, CanonConstants.EdsISOSpeed[].class);
        }
    }

    public static class DriveMode
    extends GetEnumPropertyDescCommand<CanonConstants.EdsDriveMode> {
        public DriveMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_DriveMode, CanonConstants.EdsDriveMode[].class);
        }
    }

    private static class GetEnumPropertyDescCommand<T extends CanonConstants.DescriptiveEnum<?>>
    extends CanonCommand<T[]> {
        private final CanonConstants.EdsPropertyID property;
        private final Class<T[]> klass;

        public GetEnumPropertyDescCommand(CanonConstants.EdsPropertyID property, Class<T[]> klass) {
            this.property = property;
            this.klass = klass;
        }

        @Override
        public void run() {
            RuntimeException t = null;
            try {
                CanonConstants.DescriptiveEnum<?>[] properties = CanonUtils.getPropertyDesc(this.camera.getEdsCamera(), this.property);
                if (properties != null) {
                    this.setResult(Arrays.copyOf(properties, properties.length, this.klass));
                } else {
                    this.setResult(null);
                }
                return;
            }
            catch (IllegalStateException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            System.err.println(t.getMessage());
            this.setResult(null);
        }
    }
}

