/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api.commands;

import com.sun.jna.NativeLong;
import edsdk.api.CanonCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.bindings.EdsFocusInfo;
import edsdk.bindings.EdsPictureStyleDesc;
import edsdk.bindings.EdsPoint;
import edsdk.bindings.EdsRect;
import edsdk.bindings.EdsSize;
import edsdk.bindings.EdsTime;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;
import java.lang.reflect.Array;

public abstract class GetPropertyCommand<T>
extends CanonCommand<T> {
    private final CanonConstants.EdsPropertyID property;
    private final long param;
    private final Class<T> klass;
    private final boolean isLiveViewCommand;
    private final int liveViewRetryCount = 2;

    public GetPropertyCommand(CanonConstants.EdsPropertyID property) {
        this(property, 0L, null, false);
    }

    public GetPropertyCommand(CanonConstants.EdsPropertyID property, long param) {
        this(property, param, null, false);
    }

    public GetPropertyCommand(CanonConstants.EdsPropertyID property, boolean isLiveViewCommand) {
        this(property, 0L, null, isLiveViewCommand);
    }

    public GetPropertyCommand(CanonConstants.EdsPropertyID property, long param, boolean isLiveViewCommand) {
        this(property, param, null, isLiveViewCommand);
    }

    public GetPropertyCommand(CanonConstants.EdsPropertyID property, Class<T> klass) {
        this(property, 0L, klass, false);
    }

    public GetPropertyCommand(CanonConstants.EdsPropertyID property, long param, Class<T> klass) {
        this(property, param, klass, false);
    }

    public GetPropertyCommand(CanonConstants.EdsPropertyID property, Class<T> klass, boolean isLiveViewCommand) {
        this(property, 0L, klass, isLiveViewCommand);
    }

    public GetPropertyCommand(CanonConstants.EdsPropertyID property, long param, Class<T> klass, boolean isLiveViewCommand) {
        this.property = property;
        this.param = param;
        this.klass = klass;
        this.isLiveViewCommand = isLiveViewCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Exception t;
        block39: {
            EdSdkLibrary.EdsBaseRef.ByReference[] references;
            block38: {
                block37: {
                    t = null;
                    references = null;
                    try {
                        EdSdkLibrary.EdsBaseRef baseRef;
                        block41: {
                            block40: {
                                if (!this.isLiveViewCommand) break block40;
                                if (!CanonUtils.isLiveViewEnabled(this.camera.getEdsCamera(), false)) {
                                    System.err.println("Live view is not enabled!");
                                    this.setResult(null);
                                    return;
                                }
                                for (int i = 0; i < 2 && references == null; ++i) {
                                    if (i > 0) {
                                        Thread.sleep(100L);
                                    }
                                    references = CanonUtils.getLiveViewImageReference(this.camera.getEdsCamera());
                                }
                                if (references != null) {
                                    baseRef = references[0].getValue();
                                    break block41;
                                } else {
                                    System.err.println("Could not retrieve live view image reference!");
                                    this.setResult(null);
                                    if (references == null) return;
                                    break block37;
                                }
                            }
                            baseRef = this.camera.getEdsCamera();
                        }
                        CanonConstants.EdsDataType type = CanonUtils.getPropertyType(baseRef, this.property, this.param);
                        Object result = null;
                        if (type == null) {
                            System.err.println(this.property + " is not currently supported by GetPropertyCommand. Likely this camera does not support property " + this.property.name() + " in the current mode or at all.");
                        } else {
                            switch (type) {
                                case kEdsDataType_Int32: 
                                case kEdsDataType_UInt32: {
                                    Long data = CanonUtils.getPropertyData(baseRef, this.property, this.param);
                                    if (data == null) break;
                                    if (this.klass != null && Boolean.class.isAssignableFrom(this.klass)) {
                                        result = data == 1L;
                                        break;
                                    }
                                    if (this.klass != null && CanonConstants.DescriptiveEnum.class.isAssignableFrom(this.klass)) {
                                        result = CanonConstants.enumOfValue(this.klass, data.intValue());
                                        break;
                                    }
                                    result = (long)data;
                                    break;
                                }
                                case kEdsDataType_String: {
                                    String data = (String)CanonUtils.getPropertyDataAdvanced(baseRef, this.property, this.param);
                                    result = data;
                                    break;
                                }
                                case kEdsDataType_Point: {
                                    EdsPoint data = (EdsPoint)((Object)CanonUtils.getPropertyDataAdvanced(baseRef, this.property, this.param));
                                    result = data;
                                    break;
                                }
                                case kEdsDataType_Rect: {
                                    EdsRect data = (EdsRect)((Object)CanonUtils.getPropertyDataAdvanced(baseRef, this.property, this.param));
                                    result = data;
                                    break;
                                }
                                case kEdsDataType_Time: {
                                    EdsTime data = (EdsTime)((Object)CanonUtils.getPropertyDataAdvanced(baseRef, this.property, this.param));
                                    result = data;
                                    break;
                                }
                                case kEdsDataType_FocusInfo: {
                                    EdsFocusInfo data = (EdsFocusInfo)((Object)CanonUtils.getPropertyDataAdvanced(baseRef, this.property, this.param));
                                    result = data;
                                    break;
                                }
                                case kEdsDataType_PictureStyleDesc: {
                                    EdsPictureStyleDesc data = (EdsPictureStyleDesc)((Object)CanonUtils.getPropertyDataAdvanced(baseRef, this.property, this.param));
                                    result = data;
                                    break;
                                }
                                case kEdsDataType_ByteBlock: 
                                case kEdsDataType_Int32_Array: 
                                case kEdsDataType_UInt32_Array: {
                                    int[] data = (int[])CanonUtils.getPropertyDataAdvanced(baseRef, this.property, this.param);
                                    if (data == null) break;
                                    if (this.klass != null && CanonConstants.DescriptiveEnum[].class.isAssignableFrom(this.klass)) {
                                        CanonConstants.DescriptiveEnum[] array = (CanonConstants.DescriptiveEnum[])Array.newInstance(this.klass.getComponentType(), data.length);
                                        for (int i = 0; i < data.length; ++i) {
                                            array[i] = CanonConstants.enumOfValue(this.klass.getComponentType(), data[i]);
                                        }
                                        result = array;
                                        break;
                                    }
                                    if (this.klass != null && CanonConstants.DescriptiveEnum.class.isAssignableFrom(this.klass)) {
                                        if (data.length > 1) {
                                            throw new IllegalStateException("Only single result expected but multiple results returned!");
                                        }
                                        result = CanonConstants.enumOfValue(this.klass, data[0]);
                                        break;
                                    }
                                    if (this.klass != null && EdsRect.class.isAssignableFrom(this.klass)) {
                                        if (data.length != 4) {
                                            throw new IllegalStateException("Four values expected for an EdsRect!");
                                        }
                                        result = new EdsRect(new EdsPoint(new NativeLong((long)data[0]), new NativeLong((long)data[1])), new EdsSize(new NativeLong((long)data[2]), new NativeLong((long)data[3])));
                                        break;
                                    }
                                    if (this.klass != null && EdsSize.class.isAssignableFrom(this.klass)) {
                                        if (data.length != 2) {
                                            throw new IllegalStateException("Two values expected for an EdsSize!");
                                        }
                                        result = new EdsSize(new NativeLong((long)data[0]), new NativeLong((long)data[1]));
                                        break;
                                    }
                                    result = data;
                                    break;
                                }
                                default: {
                                    System.err.println(type.description() + " (" + type.name() + ") is not currently supported by GetPropertyCommand. Likely this camera does not support property " + this.property.name() + " in the current mode or at all.");
                                }
                            }
                        }
                        this.setResult(result);
                        if (references == null) return;
                        break block38;
                    }
                    catch (IllegalArgumentException e) {
                        t = e;
                        break block39;
                    }
                    catch (InterruptedException e) {
                        t = e;
                        break block39;
                    }
                }
                CanonUtils.release(references);
                return;
            }
            CanonUtils.release(references);
            return;
            finally {
                if (references != null) {
                    CanonUtils.release(references);
                }
            }
        }
        System.err.println(t.getMessage());
        this.setResult(null);
    }

    public static class LiveViewCropRectangle
    extends GetPropertyCommand<int[]> {
        public LiveViewCropRectangle() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ImageClipRect, true);
        }
    }

    public static class LiveViewCropPosition
    extends GetPropertyCommand<EdsPoint> {
        public LiveViewCropPosition() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ImagePosition, true);
        }
    }

    public static class LiveViewZoomRectangle
    extends GetPropertyCommand<EdsRect> {
        public LiveViewZoomRectangle() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ZoomRect, EdsRect.class, true);
        }
    }

    public static class LiveViewZoomPosition
    extends GetPropertyCommand<EdsPoint> {
        public LiveViewZoomPosition() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ZoomPosition, true);
        }
    }

    public static class LiveViewCoordinateSystem
    extends GetPropertyCommand<EdsSize> {
        public LiveViewCoordinateSystem() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_CoordinateSystem, EdsSize.class, true);
        }
    }

    public static class LiveViewHistogramStatus
    extends GetPropertyCommand<CanonConstants.EdsEvfHistogramStatus> {
        public LiveViewHistogramStatus() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_HistogramStatus, CanonConstants.EdsEvfHistogramStatus.class, true);
        }
    }

    public static class LiveViewZoomRatio
    extends GetPropertyCommand<CanonConstants.EdsEvfZoom> {
        public LiveViewZoomRatio() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_Zoom, CanonConstants.EdsEvfZoom.class, true);
        }
    }

    public static class LiveViewHistogramB
    extends GetPropertyCommand<int[]> {
        public LiveViewHistogramB() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_HistogramB, true);
        }
    }

    public static class LiveViewHistogramG
    extends GetPropertyCommand<int[]> {
        public LiveViewHistogramG() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_HistogramG, true);
        }
    }

    public static class LiveViewHistogramR
    extends GetPropertyCommand<int[]> {
        public LiveViewHistogramR() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_HistogramR, true);
        }
    }

    public static class LiveViewHistogramY
    extends GetPropertyCommand<int[]> {
        public LiveViewHistogramY() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_HistogramY, true);
        }
    }

    public static class LiveViewHistogram
    extends GetPropertyCommand<int[]> {
        public LiveViewHistogram() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_Histogram, true);
        }
    }

    public static class LiveViewAutoFocusMode
    extends GetPropertyCommand<CanonConstants.EdsEvfAFMode> {
        public LiveViewAutoFocusMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_AFMode, CanonConstants.EdsEvfAFMode.class);
        }
    }

    public static class LiveViewWhiteBalance
    extends GetPropertyCommand<CanonConstants.EdsWhiteBalance> {
        public LiveViewWhiteBalance() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_WhiteBalance, CanonConstants.EdsWhiteBalance.class);
        }
    }

    public static class PictureStyle
    extends GetPropertyCommand<CanonConstants.EdsPictureStyle> {
        public PictureStyle() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_PictureStyle, CanonConstants.EdsPictureStyle.class);
        }
    }

    public static class ColorSpace
    extends GetPropertyCommand<CanonConstants.EdsColorSpace> {
        public ColorSpace() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ColorSpace, CanonConstants.EdsColorSpace.class);
        }
    }

    public static class WhiteBalance
    extends GetPropertyCommand<CanonConstants.EdsWhiteBalance> {
        public WhiteBalance() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_WhiteBalance, CanonConstants.EdsWhiteBalance.class);
        }
    }

    public static class ImageQuality
    extends GetPropertyCommand<CanonConstants.EdsImageQuality> {
        public ImageQuality() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ImageQuality, CanonConstants.EdsImageQuality.class);
        }
    }

    public static class ShootingMode
    extends GetPropertyCommand<CanonConstants.EdsAEMode> {
        public ShootingMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_AEMode, CanonConstants.EdsAEMode.class);
        }
    }

    public static class ExposureCompensation
    extends GetPropertyCommand<CanonConstants.EdsExposureCompensation> {
        public ExposureCompensation() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ExposureCompensation, CanonConstants.EdsExposureCompensation.class);
        }
    }

    public static class ShutterSpeed
    extends GetPropertyCommand<CanonConstants.EdsTv> {
        public ShutterSpeed() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Tv, CanonConstants.EdsTv.class);
        }
    }

    public static class ApertureValue
    extends GetPropertyCommand<CanonConstants.EdsAv> {
        public ApertureValue() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Av, CanonConstants.EdsAv.class);
        }
    }

    public static class AutoFocusMode
    extends GetPropertyCommand<CanonConstants.EdsAFMode> {
        public AutoFocusMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_AFMode, CanonConstants.EdsAFMode.class);
        }
    }

    public static class MeteringMode
    extends GetPropertyCommand<CanonConstants.EdsMeteringMode> {
        public MeteringMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_MeteringMode, CanonConstants.EdsMeteringMode.class);
        }
    }

    public static class ISOSpeed
    extends GetPropertyCommand<CanonConstants.EdsISOSpeed> {
        public ISOSpeed() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ISOSpeed, CanonConstants.EdsISOSpeed.class);
        }
    }

    public static class DriveMode
    extends GetPropertyCommand<CanonConstants.EdsDriveMode> {
        public DriveMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_DriveMode, CanonConstants.EdsDriveMode.class);
        }
    }

    public static class LiveViewDepthOfFieldInPreview
    extends GetPropertyCommand<Boolean> {
        public LiveViewDepthOfFieldInPreview() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_DepthOfFieldPreview, Boolean.class);
        }
    }

    public static class LiveViewColorTemperature
    extends GetPropertyCommand<Long> {
        public LiveViewColorTemperature() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_ColorTemperature);
        }
    }

    public static class LiveViewMode
    extends GetPropertyCommand<Boolean> {
        public LiveViewMode() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_Mode, Boolean.class);
        }
    }

    public static class LiveViewOutputDevice
    extends GetPropertyCommand<CanonConstants.EdsEvfOutputDevice> {
        public LiveViewOutputDevice() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Evf_OutputDevice, CanonConstants.EdsEvfOutputDevice.class);
        }
    }

    public static class MovieShootingStatus
    extends GetPropertyCommand<Long> {
        public MovieShootingStatus() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Record);
        }
    }

    public static class PictureStyleDescription
    extends GetPropertyCommand<EdsPictureStyleDesc> {
        public PictureStyleDescription() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_PictureStyleDesc);
        }
    }

    public static class ParameterSet
    extends GetPropertyCommand<Long> {
        public ParameterSet() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ParameterSet);
        }
    }

    public static class WhiteBalanceShift
    extends GetPropertyCommand<int[]> {
        public WhiteBalanceShift() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_WhiteBalanceShift);
        }
    }

    public static class ColorTemperature
    extends GetPropertyCommand<Long> {
        public ColorTemperature() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ColorTemperature);
        }
    }

    public static class JPEGQuality
    extends GetPropertyCommand<Long> {
        public JPEGQuality() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_JpegQuality);
        }
    }

    public static class HardDriveDirectoryStructure
    extends GetPropertyCommand<String> {
        public HardDriveDirectoryStructure() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_HDDirectoryStructure);
        }
    }

    public static class SaveTo
    extends GetPropertyCommand<CanonConstants.EdsSaveTo> {
        public SaveTo() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_SaveTo, CanonConstants.EdsSaveTo.class);
        }
    }

    public static class OwnerName
    extends GetPropertyCommand<String> {
        public OwnerName() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_OwnerName);
        }
    }

    public static class Copyright
    extends GetPropertyCommand<String> {
        public Copyright() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Copyright);
        }
    }

    public static class Artist
    extends GetPropertyCommand<String> {
        public Artist() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Artist);
        }
    }

    public static class LensStatus
    extends GetPropertyCommand<Boolean> {
        public LensStatus() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_LensStatus, Boolean.class);
        }
    }

    public static class WhiteBalanceBracket
    extends GetPropertyCommand<int[]> {
        public WhiteBalanceBracket() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_WhiteBalanceBracket);
        }
    }

    public static class Bracket
    extends GetPropertyCommand<CanonConstants.EdsBracket> {
        public Bracket() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_Bracket, CanonConstants.EdsBracket.class);
        }
    }

    public static class AvailableShots
    extends GetPropertyCommand<Long> {
        public AvailableShots() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_AvailableShots);
        }
    }

    public static class FlashCompensation
    extends GetPropertyCommand<CanonConstants.EdsExposureCompensation> {
        public FlashCompensation() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_FlashCompensation, CanonConstants.EdsExposureCompensation.class);
        }
    }

    public static class FocusInfo
    extends GetPropertyCommand<EdsFocusInfo> {
        public FocusInfo() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_FocusInfo);
        }
    }

    public static class BodyIDEx
    extends GetPropertyCommand<String> {
        public BodyIDEx() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_BodyIDEx);
        }
    }

    public static class BatteryQuality
    extends GetPropertyCommand<CanonConstants.EdsBatteryQuality> {
        public BatteryQuality() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_BatteryQuality, CanonConstants.EdsBatteryQuality.class);
        }
    }

    public static class CurrentFolder
    extends GetPropertyCommand<String> {
        public CurrentFolder() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_CurrentFolder);
        }
    }

    public static class CurrentStorage
    extends GetPropertyCommand<String> {
        public CurrentStorage() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_CurrentStorage);
        }
    }

    public static class BatteryLevel
    extends GetPropertyCommand<Long> {
        public BatteryLevel() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_BatteryLevel);
        }
    }

    public static class FirmwareVersion
    extends GetPropertyCommand<String> {
        public FirmwareVersion() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_FirmwareVersion);
        }
    }

    public static class DateTime
    extends GetPropertyCommand<EdsTime> {
        public DateTime() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_DateTime);
        }
    }

    public static class ProductName
    extends GetPropertyCommand<String> {
        public ProductName() {
            super(CanonConstants.EdsPropertyID.kEdsPropID_ProductName);
        }
    }

    public static class CustomFunction
    extends GetPropertyCommand<Long> {
        public CustomFunction(CanonConstants.EdsCustomFunction customFunction) {
            super(CanonConstants.EdsPropertyID.kEdsPropID_CFn, customFunction.value().intValue());
        }
    }

    public static class Type
    extends CanonCommand<CanonConstants.EdsDataType> {
        private final CanonConstants.EdsPropertyID property;

        public Type(CanonConstants.EdsPropertyID property) {
            this.property = property;
        }

        @Override
        public void run() {
            this.setResult(CanonUtils.getPropertyType(this.camera.getEdsCamera(), this.property));
        }
    }

    public static class Size
    extends CanonCommand<Long> {
        private final CanonConstants.EdsPropertyID property;

        public Size(CanonConstants.EdsPropertyID property) {
            this.property = property;
        }

        @Override
        public void run() {
            this.setResult(CanonUtils.getPropertySize(this.camera.getEdsCamera(), this.property));
        }
    }

    public static class Data
    extends GetPropertyCommand<Long> {
        public Data(CanonConstants.EdsPropertyID property, boolean isLiveViewCommand) {
            super(property, true);
        }

        public Data(CanonConstants.EdsPropertyID property) {
            super(property);
        }
    }
}

