/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api.commands;

import edsdk.api.CanonCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;

public class FocusModeCommand
extends CanonCommand<Boolean> {
    private final Mode mode;

    public FocusModeCommand(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void run() {
        System.out.println("Begin setting camera to " + this.mode.name().toLowerCase() + " focus");
        switch (this.mode) {
            case AUTO: {
                CanonUtils.setPropertyData((EdSdkLibrary.EdsBaseRef)this.camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_AFMode, CanonConstants.EdsAFMode.kEdsAFMode_OneShot);
                break;
            }
            case MANUAL: {
                CanonUtils.setPropertyData((EdSdkLibrary.EdsBaseRef)this.camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_AFMode, CanonConstants.EdsAFMode.kEdsAFMode_Manual);
                CanonUtils.setPropertyData((EdSdkLibrary.EdsBaseRef)this.camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_Evf_AFMode, CanonConstants.EdsEvfAFMode.Evf_AFMode_Live);
            }
        }
        System.out.println("DONE!");
        this.setResult(true);
    }

    public static enum Mode {
        AUTO,
        MANUAL;

    }
}

