/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import edsdk.api.CanonCamera;
import edsdk.api.CanonCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;
import java.io.File;
import java.util.ArrayList;

public class QuickShootManager
implements EdSdkLibrary.EdsObjectEventHandler {
    ArrayList<EdSdkLibrary.EdsDirectoryItemRef> refs = new ArrayList();
    private final CanonCamera camera;
    int wanted = 0;

    public QuickShootManager(CanonCamera camera) {
        this.camera = camera;
        camera.execute(new CanonCommand<Void>(){

            @Override
            public void run() {
                CanonUtils.endLiveView(this.camera.getEdsCamera());
            }
        });
    }

    public CanonCommand<Void> trigger() {
        if (this.wanted == 0) {
            this.camera.addObjectEventHandler(this);
        }
        ++this.wanted;
        return this.camera.execute(new Shutter());
    }

    public CanonCommand<ArrayList<File>> downloadAll() {
        while (this.refs.size() < this.wanted) {
            try {
                Thread.sleep(1L);
                Thread.yield();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.camera.execute(new Downloader());
    }

    public void reset() {
        this.refs.clear();
        this.camera.removeObjectEventHandler(this);
    }

    @Override
    public NativeLong apply(NativeLong inEvent, EdSdkLibrary.EdsBaseRef inRef, Pointer inContext) {
        return this.apply(inEvent, (EdSdkLibrary.EdsBaseRef)new EdSdkLibrary.EdsDirectoryItemRef(inRef.getPointer()), inContext);
    }

    public CanonConstants.EdsError apply(CanonConstants.EdsObjectEvent inEvent, EdSdkLibrary.EdsDirectoryItemRef inRef, Pointer inContext) {
        if (inEvent == CanonConstants.EdsObjectEvent.kEdsObjectEvent_DirItemCreated || inEvent == CanonConstants.EdsObjectEvent.kEdsObjectEvent_DirItemRequestTransfer) {
            this.refs.add(inRef);
        }
        return null;
    }

    private class Downloader
    extends CanonCommand<ArrayList<File>> {
        private Downloader() {
        }

        @Override
        public void run() {
            ArrayList<File> results = new ArrayList<File>();
            for (EdSdkLibrary.EdsDirectoryItemRef ref : QuickShootManager.this.refs) {
                results.add(CanonUtils.download(ref, null, true));
            }
            this.setResult(results);
            QuickShootManager.this.reset();
        }
    }

    private class Shutter
    extends CanonCommand<Void> {
        private Shutter() {
        }

        @Override
        public void run() {
            CanonConstants.EdsError result = CanonConstants.EdsError.EDS_ERR_UNIMPLEMENTED;
            while (result != CanonConstants.EdsError.EDS_ERR_OK) {
                result = this.sendCommand(CanonConstants.EdsCameraCommand.kEdsCameraCommand_TakePicture, 0L);
            }
        }
    }
}

