/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import edsdk.api.BaseCanonCamera;
import edsdk.api.CanonCamera;
import edsdk.api.CanonCommandListener;
import edsdk.bindings.EdSdkLibrary;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public abstract class CanonCommand<T>
implements EdSdkLibrary.EdsObjectEventHandler {
    public BaseCanonCamera camera;
    public EdSdkLibrary.EdsCameraRef edsCamera;
    private boolean finished = false;
    private boolean waitForFinish = false;
    private boolean ran = false;
    private T result;
    private final ReentrantLock lock = new ReentrantLock();
    private ArrayList<CanonCommandListener<T>> listeners = null;

    public void setCamera(BaseCanonCamera baseCanonCamera) {
        this.camera = baseCanonCamera;
        this.edsCamera = baseCanonCamera.getEdsCamera();
    }

    public abstract void run();

    public void setResult(T result) {
        this.result = result;
    }

    public void notYetFinished() {
        this.waitForFinish = true;
    }

    public void finish() {
        this.finished = true;
        this.notifyListenersIfDone();
    }

    protected void ran() {
        this.ran = true;
        this.notifyListenersIfDone();
    }

    public boolean finished() {
        return this.waitForFinish ? this.finished : this.ran;
    }

    public CanonConstants.EdsError sendCommand(CanonConstants.EdsCameraCommand command, CanonConstants.DescriptiveEnum<? extends Number> params) {
        return this.sendCommand(command, params.value().longValue());
    }

    public CanonConstants.EdsError sendCommand(CanonConstants.EdsCameraCommand command, long params) {
        return CanonUtils.toEdsError(CanonCamera.EDSDK.EdsSendCommand(this.camera.getEdsCamera(), new NativeLong((long)command.value().intValue()), new NativeLong(params)));
    }

    public CanonConstants.EdsError sendStatusCommand(CanonConstants.EdsCameraStatusCommand command, CanonConstants.DescriptiveEnum<? extends Number> params) {
        return this.sendStatusCommand(command, params.value().longValue());
    }

    public CanonConstants.EdsError sendStatusCommand(CanonConstants.EdsCameraStatusCommand command, long params) {
        return CanonUtils.toEdsError(CanonCamera.EDSDK.EdsSendStatusCommand(this.camera.getEdsCamera(), new NativeLong((long)command.value().intValue()), new NativeLong(params)));
    }

    @Override
    public NativeLong apply(NativeLong inEvent, EdSdkLibrary.EdsBaseRef inRef, Pointer inContext) {
        return new NativeLong((long)this.apply(CanonConstants.EdsObjectEvent.enumOfValue(inEvent.intValue()), inRef, inContext).value().intValue());
    }

    public CanonConstants.EdsError apply(CanonConstants.EdsObjectEvent inEvent, EdSdkLibrary.EdsBaseRef inRef, Pointer inContext) {
        return CanonConstants.EdsError.EDS_ERR_OK;
    }

    public T get() {
        try {
            return this.get(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public T get(long timeout) throws InterruptedException {
        if (this.camera == null) {
            System.err.println("Attention: " + this.getClass());
            System.err.println("  This command was not yet added to a queue ");
            System.err.println("  with CanonCamera.execute( ... )");
            System.err.println("  This way you might wait forever until .get() returns. ");
        }
        long startTime = System.currentTimeMillis();
        try {
            while (!(this.finished() || timeout != 0L && System.currentTimeMillis() - startTime >= timeout)) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            System.out.println("Interrupt received by CanonCommand, stopping...");
            Thread.currentThread().interrupt();
            return null;
        }
        if (this.finished()) {
            return this.result;
        }
        throw new InterruptedException("edsdkp5 - command didn't return the result in time");
    }

    public T now() {
        return this.get();
    }

    public void whenDone(CanonCommandListener<T> listener) {
        this.lock.lock();
        if (this.finished()) {
            listener.success(this.result);
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }
        this.lock.unlock();
    }

    private void notifyListenersIfDone() {
        this.lock.lock();
        if (this.finished() && this.listeners != null) {
            for (CanonCommandListener<T> listener : this.listeners) {
                listener.success(this.result);
            }
            this.listeners = null;
        }
        this.lock.unlock();
    }
}

