/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.NativeLongByReference;
import edsdk.api.BaseCanonCamera;
import edsdk.api.CanonCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;
import java.util.Map;

public class CanonCamera
extends BaseCanonCamera
implements EdSdkLibrary.EdsObjectEventHandler {
    public static final int POLL_MILLISECS = 1;
    private static User32 lib;
    public static EdSdkLibrary EDSDK;

    private static void dispatchMessages() {
        CanonConstants.EdsError err = CanonUtils.toEdsError(EDSDK.EdsInitializeSDK());
        if (err != CanonConstants.EdsError.EDS_ERR_OK) {
            System.err.println("EDSDK failed to initialize, most likely you won't be able to speak to your camera (ERROR: " + err.description() + " )");
        }
        WinUser.MSG msg = new WinUser.MSG();
        CanonCommand cmd = null;
        while (!Thread.currentThread().isInterrupted()) {
            boolean hasMessage = lib.PeekMessage(msg, null, 0, 0, 1);
            if (hasMessage) {
                lib.TranslateMessage(msg);
                lib.DispatchMessage(msg);
            }
            if (cmd != null && cmd.finished()) {
                cmd.camera.removeObjectEventHandler(cmd);
                cmd = null;
            }
            if (!queue.isEmpty() && cmd == null) {
                cmd = (CanonCommand)queue.poll();
                if (!(cmd instanceof OpenSessionCommand)) {
                    cmd.camera.addObjectEventHandler(cmd);
                }
                cmd.run();
                cmd.ran();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                System.out.println("\nInterrupt received in CanonCamera, stopping...");
                Thread.currentThread().interrupt();
                break;
            }
        }
        EDSDK.EdsTerminateSDK();
        System.out.println("EDSDK Dispatcher thread says bye!");
    }

    public static void close() {
        if (dispatcherThread != null && dispatcherThread.isAlive()) {
            dispatcherThread.interrupt();
            try {
                dispatcherThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean openSession() {
        Boolean result = this.executeNow(new OpenSessionCommand());
        return result != null && result != false;
    }

    public boolean closeSession() {
        Boolean result = this.executeNow(new CloseSessionCommand());
        return result != null && result != false;
    }

    static {
        EDSDK = null;
        if (Platform.isWindows()) {
            options.put("calling-convention", 63);
        }
        if (Platform.isMac()) {
            options.put("calling-convention", 0);
        }
        CanonCamera.initLibrary();
        EDSDK = (EdSdkLibrary)Native.loadLibrary((String)CanonCamera.libraryInfo.dllLoc, EdSdkLibrary.class, (Map)options);
        if (Platform.isWindows()) {
            lib = User32.INSTANCE;
        }
        dispatcherThread = new Thread(){

            @Override
            public void run() {
                CanonCamera.dispatchMessages();
            }
        };
        dispatcherThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CanonCamera.close();
            }
        });
    }

    private class CloseSessionCommand
    extends CanonCommand<Boolean> {
        private CloseSessionCommand() {
        }

        @Override
        public void run() {
            this.setResult(this.close());
        }

        private boolean close() {
            CanonConstants.EdsError err = CanonUtils.toEdsError(EDSDK.EdsCloseSession(this.edsCamera));
            CanonUtils.release(this.edsCamera);
            if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                return CanonCamera.this.setError(err, "Couldn't close camera session");
            }
            return true;
        }
    }

    private class OpenSessionCommand
    extends CanonCommand<Boolean> {
        private OpenSessionCommand() {
        }

        @Override
        public void run() {
            this.setResult(this.connect());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean connect() {
            CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
            EdSdkLibrary.EdsCameraListRef.ByReference listRef = new EdSdkLibrary.EdsCameraListRef.ByReference();
            EdSdkLibrary.EdsCameraRef.ByReference cameraRef = new EdSdkLibrary.EdsCameraRef.ByReference();
            try {
                err = CanonUtils.toEdsError(EDSDK.EdsGetCameraList(listRef));
                if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                    throw new Exception("Camera failed to initialize");
                }
                NativeLongByReference outRef = new NativeLongByReference();
                err = CanonUtils.toEdsError(EDSDK.EdsGetChildCount(listRef.getValue(), outRef));
                if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                    throw new Exception("Number of attached cameras couldn't be read");
                }
                long numCams = outRef.getValue().longValue();
                if (numCams <= 0L) {
                    err = CanonConstants.EdsError.EDS_ERR_DEVICE_NOT_FOUND;
                    throw new Exception("No cameras found. Have you tried turning it off and on again?");
                }
                err = CanonUtils.toEdsError(EDSDK.EdsGetChildAtIndex(listRef.getValue(), new NativeLong(0L), cameraRef));
                if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                    throw new Exception("Access to camera failed");
                }
                err = CanonUtils.toEdsError(EDSDK.EdsSetObjectEventHandler(cameraRef.getValue(), new NativeLong((long)CanonConstants.EdsObjectEvent.kEdsObjectEvent_All.value().intValue()), CanonCamera.this, new Pointer(0L)));
                if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                    throw new Exception("Callback handler couldn't be added");
                }
                err = CanonUtils.toEdsError(EDSDK.EdsOpenSession(cameraRef.getValue()));
                if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                    throw new Exception("Couldn't open camera session");
                }
                CanonCamera.this.edsCamera = cameraRef.getValue();
            }
            catch (Exception e) {
                try {
                    CanonUtils.release(cameraRef);
                    CanonCamera.this.setError(err, e.getMessage());
                }
                catch (Throwable throwable) {
                    CanonUtils.release(listRef);
                    throw throwable;
                }
                CanonUtils.release(listRef);
            }
            CanonUtils.release(listRef);
            return err == CanonConstants.EdsError.EDS_ERR_OK;
        }
    }
}

