/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import edsdk.api.CanonCommand;
import edsdk.api.commands.DriveLensCommand;
import edsdk.api.commands.FocusModeCommand;
import edsdk.api.commands.GetPropertyCommand;
import edsdk.api.commands.GetPropertyDescCommand;
import edsdk.api.commands.LiveViewCommand;
import edsdk.api.commands.SetPropertyCommand;
import edsdk.api.commands.ShootCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.bindings.EdsFocusInfo;
import edsdk.bindings.EdsPictureStyleDesc;
import edsdk.bindings.EdsPoint;
import edsdk.bindings.EdsPropertyDesc;
import edsdk.bindings.EdsRect;
import edsdk.bindings.EdsSize;
import edsdk.bindings.EdsTime;
import edsdk.utils.CanonConstants;
import edsdk.utils.DLL_Setup;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class BaseCanonCamera
implements EdSdkLibrary.EdsObjectEventHandler {
    public static final Map<String, Integer> options = new LinkedHashMap<String, Integer>();
    public static boolean debug = false;
    public static DLL_Setup.LibraryInfo libraryInfo;
    protected static ConcurrentLinkedQueue<CanonCommand<?>> queue;
    private static ArrayList<EdSdkLibrary.EdsObjectEventHandler> objectEventHandlers;
    protected static Thread dispatcherThread;
    EdSdkLibrary.EdsCameraRef edsCamera = null;
    private String errorMessage = "No Errors Yet";
    private CanonConstants.EdsError errorCode = CanonConstants.EdsError.EDS_ERR_OK;

    public static File getEdSdkLibraryFile() {
        File libFile = new File(BaseCanonCamera.libraryInfo.dllLoc);
        return libFile;
    }

    public static void initLibrary() {
        libraryInfo = DLL_Setup.initLibrary("EdSdk");
        System.setProperty("jna.predictable_field_order", "true");
    }

    public EdSdkLibrary.EdsCameraRef getEdsCamera() {
        return this.edsCamera;
    }

    public File[] shoot() {
        return this.executeNow(new ShootCommand());
    }

    public ShootCommand shootAsync() {
        return this.execute(new ShootCommand());
    }

    public File[] shoot(CanonConstants.EdsSaveTo saveTo) {
        return this.executeNow(new ShootCommand(saveTo));
    }

    public ShootCommand shootAsync(CanonConstants.EdsSaveTo saveTo) {
        return this.execute(new ShootCommand(saveTo));
    }

    public File[] shoot(CanonConstants.EdsSaveTo saveTo, int shotAttempts) {
        return this.executeNow(new ShootCommand(saveTo, shotAttempts));
    }

    public ShootCommand shootAsync(CanonConstants.EdsSaveTo saveTo, int shotAttempts) {
        return this.execute(new ShootCommand(saveTo, shotAttempts));
    }

    public File[] shoot(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File dest) {
        return this.executeNow(new ShootCommand(saveTo, shotAttempts, dest));
    }

    public ShootCommand shootAsync(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File dest) {
        return this.execute(new ShootCommand(saveTo, shotAttempts, dest));
    }

    public File[] shoot(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File[] dest) {
        return this.executeNow(new ShootCommand(saveTo, shotAttempts, dest));
    }

    public ShootCommand shootAsync(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File[] dest) {
        return this.execute(new ShootCommand(saveTo, shotAttempts, dest));
    }

    public File[] shoot(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File[] dest, boolean appendFileExtension) {
        return this.executeNow(new ShootCommand(saveTo, shotAttempts, dest, appendFileExtension));
    }

    public ShootCommand shootAsync(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File[] dest, boolean appendFileExtension) {
        return this.execute(new ShootCommand(saveTo, shotAttempts, dest, appendFileExtension));
    }

    public Boolean setProperty(CanonConstants.EdsPropertyID property, CanonConstants.DescriptiveEnum<? extends Number> value) {
        return this.executeNow(new SetPropertyCommand.EnumData(property, value));
    }

    public SetPropertyCommand.EnumData setPropertyAsync(CanonConstants.EdsPropertyID property, CanonConstants.DescriptiveEnum<? extends Number> value) {
        return this.execute(new SetPropertyCommand.EnumData(property, value));
    }

    public Boolean setProperty(CanonConstants.EdsPropertyID property, int value) {
        return this.executeNow(new SetPropertyCommand.Data(property, value));
    }

    public SetPropertyCommand.Data setPropertyAsync(CanonConstants.EdsPropertyID property, int value) {
        return this.execute(new SetPropertyCommand.Data(property, value));
    }

    public Boolean setProperty(CanonConstants.EdsPropertyID property, long value) {
        return this.executeNow(new SetPropertyCommand.Data(property, value));
    }

    public SetPropertyCommand.Data setPropertyAsync(CanonConstants.EdsPropertyID property, long value) {
        return this.execute(new SetPropertyCommand.Data(property, value));
    }

    public Long getProperty(CanonConstants.EdsPropertyID property) {
        return this.executeNow(new GetPropertyCommand.Data(property));
    }

    public GetPropertyCommand.Data getPropertyAsync(CanonConstants.EdsPropertyID property) {
        return this.execute(new GetPropertyCommand.Data(property));
    }

    public Long getPropertySize(CanonConstants.EdsPropertyID property) {
        return this.executeNow(new GetPropertyCommand.Size(property));
    }

    public GetPropertyCommand.Size getPropertySizeAsync(CanonConstants.EdsPropertyID property) {
        return this.execute(new GetPropertyCommand.Size(property));
    }

    public CanonConstants.EdsDataType getPropertyType(CanonConstants.EdsPropertyID property) {
        return this.executeNow(new GetPropertyCommand.Type(property));
    }

    public GetPropertyCommand.Type getPropertyTypeAsync(CanonConstants.EdsPropertyID property) {
        return this.execute(new GetPropertyCommand.Type(property));
    }

    public EdsPropertyDesc getPropertyDesc(CanonConstants.EdsPropertyID property) {
        return this.executeNow(new GetPropertyDescCommand(property));
    }

    public GetPropertyDescCommand getPropertyDescAsync(CanonConstants.EdsPropertyID property) {
        return this.execute(new GetPropertyDescCommand(property));
    }

    public <T extends CanonCommand<?>> T execute(T cmd) {
        cmd.setCamera(this);
        queue.add(cmd);
        return cmd;
    }

    public <T> T executeNow(CanonCommand<T> cmd) {
        if (dispatcherThread != null && dispatcherThread.isAlive()) {
            return this.execute(cmd).get();
        }
        return null;
    }

    public boolean setError(CanonConstants.EdsError result, String message) {
        this.errorCode = result;
        this.errorMessage = message + " (error " + this.errorCode.value() + ": " + this.errorCode.name() + " - " + this.errorCode.description() + ")";
        System.err.println(this.errorMessage);
        return false;
    }

    public CanonConstants.EdsError getLastError() {
        return this.errorCode;
    }

    public String getLastErrorMessage() {
        return this.errorMessage;
    }

    public void addObjectEventHandler(EdSdkLibrary.EdsObjectEventHandler handler) {
        objectEventHandlers.add(handler);
    }

    public void removeObjectEventHandler(EdSdkLibrary.EdsObjectEventHandler handler) {
        objectEventHandlers.remove(handler);
    }

    @Override
    public NativeLong apply(NativeLong inEvent, EdSdkLibrary.EdsBaseRef inRef, Pointer inContext) {
        for (EdSdkLibrary.EdsObjectEventHandler handler : objectEventHandlers) {
            handler.apply(inEvent, inRef, inContext);
        }
        return new NativeLong(0L);
    }

    public static void close() {
        if (dispatcherThread != null && dispatcherThread.isAlive()) {
            dispatcherThread.interrupt();
            try {
                dispatcherThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Boolean beginLiveView() {
        return this.executeNow(new LiveViewCommand.Begin());
    }

    public LiveViewCommand.Begin beginLiveViewAsync() {
        return this.execute(new LiveViewCommand.Begin());
    }

    public Boolean endLiveView() {
        return this.executeNow(new LiveViewCommand.End());
    }

    public LiveViewCommand.End endLiveViewAsync() {
        return this.execute(new LiveViewCommand.End());
    }

    public BufferedImage downloadLiveView() {
        return this.executeNow(new LiveViewCommand.Download());
    }

    public LiveViewCommand.Download downloadLiveViewAsync() {
        return this.execute(new LiveViewCommand.Download());
    }

    public Boolean isLiveViewEnabled() {
        return this.executeNow(new LiveViewCommand.IsLiveViewEnabled());
    }

    public LiveViewCommand.IsLiveViewEnabled isLiveViewEnabledAsync() {
        return this.execute(new LiveViewCommand.IsLiveViewEnabled());
    }

    public Boolean isLiveViewActive() {
        return this.executeNow(new LiveViewCommand.IsLiveViewActive());
    }

    public LiveViewCommand.IsLiveViewActive isLiveViewActiveAsync() {
        return this.execute(new LiveViewCommand.IsLiveViewActive());
    }

    public Boolean setFocusMode(FocusModeCommand.Mode mode) {
        return this.executeNow(new FocusModeCommand(mode));
    }

    public FocusModeCommand setFocusModeAsync(FocusModeCommand.Mode mode) {
        return this.execute(new FocusModeCommand(mode));
    }

    public Boolean useAutoFocus() {
        return this.executeNow(new FocusModeCommand(FocusModeCommand.Mode.AUTO));
    }

    public FocusModeCommand useAutoFocusAsync() {
        return this.execute(new FocusModeCommand(FocusModeCommand.Mode.AUTO));
    }

    public Boolean useManualFocus() {
        return this.executeNow(new FocusModeCommand(FocusModeCommand.Mode.MANUAL));
    }

    public FocusModeCommand useManualFocusAsync() {
        return this.execute(new FocusModeCommand(FocusModeCommand.Mode.MANUAL));
    }

    public Boolean driveLens(CanonConstants.EdsEvfDriveLens mode) {
        return this.executeNow(new DriveLensCommand(mode));
    }

    public DriveLensCommand driveLensAsync(CanonConstants.EdsEvfDriveLens mode) {
        return this.execute(new DriveLensCommand(mode));
    }

    public CanonConstants.EdsDriveMode[] getAvailableDriveModes() {
        return this.executeNow(new GetPropertyDescCommand.DriveMode());
    }

    public GetPropertyDescCommand.DriveMode getAvailableDriveModesAsync() {
        return this.execute(new GetPropertyDescCommand.DriveMode());
    }

    public CanonConstants.EdsISOSpeed[] getAvailableISOSpeeds() {
        return this.executeNow(new GetPropertyDescCommand.ISOSpeed());
    }

    public GetPropertyDescCommand.ISOSpeed getAvailableISOSpeedsAsync() {
        return this.execute(new GetPropertyDescCommand.ISOSpeed());
    }

    public CanonConstants.EdsMeteringMode[] getAvailableMeteringModes() {
        return this.executeNow(new GetPropertyDescCommand.MeteringMode());
    }

    public GetPropertyDescCommand.MeteringMode getAvailableMeteringModesAsync() {
        return this.execute(new GetPropertyDescCommand.MeteringMode());
    }

    public CanonConstants.EdsAFMode[] getAvailableAutoFocusModes() {
        return this.executeNow(new GetPropertyDescCommand.AutoFocusMode());
    }

    public GetPropertyDescCommand.AutoFocusMode getAvailableAutoFocusModesAsync() {
        return this.execute(new GetPropertyDescCommand.AutoFocusMode());
    }

    public CanonConstants.EdsAv[] getAvailableApertureValues() {
        return this.executeNow(new GetPropertyDescCommand.ApertureValue());
    }

    public GetPropertyDescCommand.ApertureValue getAvailableApertureValuesAsync() {
        return this.execute(new GetPropertyDescCommand.ApertureValue());
    }

    public CanonConstants.EdsTv[] getAvailableShutterSpeeds() {
        return this.executeNow(new GetPropertyDescCommand.ShutterSpeed());
    }

    public GetPropertyDescCommand.ShutterSpeed getAvailableShutterSpeedsAsync() {
        return this.execute(new GetPropertyDescCommand.ShutterSpeed());
    }

    public CanonConstants.EdsExposureCompensation[] getAvailableExposureCompensations() {
        return this.executeNow(new GetPropertyDescCommand.ExposureCompensation());
    }

    public GetPropertyDescCommand.ExposureCompensation getAvailableExposureCompensationsAsync() {
        return this.execute(new GetPropertyDescCommand.ExposureCompensation());
    }

    public CanonConstants.EdsAEMode[] getAvailableShootingModes() {
        return this.executeNow(new GetPropertyDescCommand.ShootingMode());
    }

    public GetPropertyDescCommand.ShootingMode getAvailableShootingModesAsync() {
        return this.execute(new GetPropertyDescCommand.ShootingMode());
    }

    public CanonConstants.EdsImageQuality[] getAvailableImageQualities() {
        return this.executeNow(new GetPropertyDescCommand.ImageQuality());
    }

    public GetPropertyDescCommand.ImageQuality getAvailableImageQualitiesAsync() {
        return this.execute(new GetPropertyDescCommand.ImageQuality());
    }

    public CanonConstants.EdsWhiteBalance[] getAvailableWhiteBalances() {
        return this.executeNow(new GetPropertyDescCommand.WhiteBalance());
    }

    public GetPropertyDescCommand.WhiteBalance getAvailableWhiteBalancesAsync() {
        return this.execute(new GetPropertyDescCommand.WhiteBalance());
    }

    public CanonConstants.EdsColorSpace[] getAvailableColorSpaces() {
        return this.executeNow(new GetPropertyDescCommand.ColorSpace());
    }

    public GetPropertyDescCommand.ColorSpace getAvailableColorSpacesAsync() {
        return this.execute(new GetPropertyDescCommand.ColorSpace());
    }

    public CanonConstants.EdsPictureStyle[] getAvailablePictureStyles() {
        return this.executeNow(new GetPropertyDescCommand.PictureStyle());
    }

    public GetPropertyDescCommand.PictureStyle getAvailablePictureStylesAsync() {
        return this.execute(new GetPropertyDescCommand.PictureStyle());
    }

    public CanonConstants.EdsWhiteBalance[] getAvailableLiveViewWhiteBalances() {
        return this.executeNow(new GetPropertyDescCommand.LiveViewWhiteBalance());
    }

    public GetPropertyDescCommand.LiveViewWhiteBalance getAvailableLiveViewWhiteBalancesAsync() {
        return this.execute(new GetPropertyDescCommand.LiveViewWhiteBalance());
    }

    public CanonConstants.EdsEvfAFMode[] getAvailableLiveViewAutoFocusModes() {
        return this.executeNow(new GetPropertyDescCommand.LiveViewAutoFocusMode());
    }

    public GetPropertyDescCommand.LiveViewAutoFocusMode getAvailableLiveViewAutoFocusModesAsync() {
        return this.execute(new GetPropertyDescCommand.LiveViewAutoFocusMode());
    }

    public CanonConstants.EdsDriveMode getDriveMode() {
        return this.executeNow(new GetPropertyCommand.DriveMode());
    }

    public GetPropertyCommand.DriveMode getDriveModeAsync() {
        return this.execute(new GetPropertyCommand.DriveMode());
    }

    public CanonConstants.EdsISOSpeed getISOSpeed() {
        return this.executeNow(new GetPropertyCommand.ISOSpeed());
    }

    public GetPropertyCommand.ISOSpeed getISOSpeedAsync() {
        return this.execute(new GetPropertyCommand.ISOSpeed());
    }

    public CanonConstants.EdsMeteringMode getMeteringMode() {
        return this.executeNow(new GetPropertyCommand.MeteringMode());
    }

    public GetPropertyCommand.MeteringMode getMeteringModeAsync() {
        return this.execute(new GetPropertyCommand.MeteringMode());
    }

    public CanonConstants.EdsAFMode getAutoFocusMode() {
        return this.executeNow(new GetPropertyCommand.AutoFocusMode());
    }

    public GetPropertyCommand.AutoFocusMode getAutoFocusModeAsync() {
        return this.execute(new GetPropertyCommand.AutoFocusMode());
    }

    public CanonConstants.EdsAv getApertureValue() {
        return this.executeNow(new GetPropertyCommand.ApertureValue());
    }

    public GetPropertyCommand.ApertureValue getApertureValueAsync() {
        return this.execute(new GetPropertyCommand.ApertureValue());
    }

    public CanonConstants.EdsTv getShutterSpeed() {
        return this.executeNow(new GetPropertyCommand.ShutterSpeed());
    }

    public GetPropertyCommand.ShutterSpeed getShutterSpeedAsync() {
        return this.execute(new GetPropertyCommand.ShutterSpeed());
    }

    public CanonConstants.EdsExposureCompensation getExposureCompensation() {
        return this.executeNow(new GetPropertyCommand.ExposureCompensation());
    }

    public GetPropertyCommand.ExposureCompensation getExposureCompensationAsync() {
        return this.execute(new GetPropertyCommand.ExposureCompensation());
    }

    public CanonConstants.EdsAEMode getShootingMode() {
        return this.executeNow(new GetPropertyCommand.ShootingMode());
    }

    public GetPropertyCommand.ShootingMode getShootingModeAsync() {
        return this.execute(new GetPropertyCommand.ShootingMode());
    }

    public CanonConstants.EdsImageQuality getImageQuality() {
        return this.executeNow(new GetPropertyCommand.ImageQuality());
    }

    public GetPropertyCommand.ImageQuality getImageQualityAsync() {
        return this.execute(new GetPropertyCommand.ImageQuality());
    }

    public CanonConstants.EdsWhiteBalance getWhiteBalance() {
        return this.executeNow(new GetPropertyCommand.WhiteBalance());
    }

    public GetPropertyCommand.WhiteBalance getWhiteBalanceAsync() {
        return this.execute(new GetPropertyCommand.WhiteBalance());
    }

    public CanonConstants.EdsColorSpace getColorSpace() {
        return this.executeNow(new GetPropertyCommand.ColorSpace());
    }

    public GetPropertyCommand.ColorSpace getColorSpaceAsync() {
        return this.execute(new GetPropertyCommand.ColorSpace());
    }

    public CanonConstants.EdsPictureStyle getPictureStyle() {
        return this.executeNow(new GetPropertyCommand.PictureStyle());
    }

    public GetPropertyCommand.PictureStyle getPictureStyleAsync() {
        return this.execute(new GetPropertyCommand.PictureStyle());
    }

    public CanonConstants.EdsWhiteBalance getLiveViewWhiteBalance() {
        return this.executeNow(new GetPropertyCommand.LiveViewWhiteBalance());
    }

    public GetPropertyCommand.LiveViewWhiteBalance getLiveViewWhiteBalanceAsync() {
        return this.execute(new GetPropertyCommand.LiveViewWhiteBalance());
    }

    public CanonConstants.EdsEvfAFMode getLiveViewAutoFocusMode() {
        return this.executeNow(new GetPropertyCommand.LiveViewAutoFocusMode());
    }

    public GetPropertyCommand.LiveViewAutoFocusMode getLiveViewAutoFocusModeAsync() {
        return this.execute(new GetPropertyCommand.LiveViewAutoFocusMode());
    }

    public Long getCustomFunction(CanonConstants.EdsCustomFunction customFunction) {
        return this.executeNow(new GetPropertyCommand.CustomFunction(customFunction));
    }

    public GetPropertyCommand.CustomFunction getCustomFunctionAsync(CanonConstants.EdsCustomFunction customFunction) {
        return this.execute(new GetPropertyCommand.CustomFunction(customFunction));
    }

    public String getProductName() {
        return this.executeNow(new GetPropertyCommand.ProductName());
    }

    public GetPropertyCommand.ProductName getProductNameAsync() {
        return this.execute(new GetPropertyCommand.ProductName());
    }

    public EdsTime getDateTime() {
        return this.executeNow(new GetPropertyCommand.DateTime());
    }

    public GetPropertyCommand.DateTime getDateTimeAsync() {
        return this.execute(new GetPropertyCommand.DateTime());
    }

    public String getFirmwareVersion() {
        return this.executeNow(new GetPropertyCommand.FirmwareVersion());
    }

    public GetPropertyCommand.FirmwareVersion getFirmwareVersionAsync() {
        return this.execute(new GetPropertyCommand.FirmwareVersion());
    }

    public Long getBatteryLevel() {
        return this.executeNow(new GetPropertyCommand.BatteryLevel());
    }

    public GetPropertyCommand.BatteryLevel getBatteryLevelAsync() {
        return this.execute(new GetPropertyCommand.BatteryLevel());
    }

    public String getCurrentStorage() {
        return this.executeNow(new GetPropertyCommand.CurrentStorage());
    }

    public GetPropertyCommand.CurrentStorage getCurrentStorageAsync() {
        return this.execute(new GetPropertyCommand.CurrentStorage());
    }

    public String getCurrentFolder() {
        return this.executeNow(new GetPropertyCommand.CurrentFolder());
    }

    public GetPropertyCommand.CurrentFolder getCurrentFolderAsync() {
        return this.execute(new GetPropertyCommand.CurrentFolder());
    }

    public CanonConstants.EdsBatteryQuality getBatteryQuality() {
        return this.executeNow(new GetPropertyCommand.BatteryQuality());
    }

    public GetPropertyCommand.BatteryQuality getBatteryQualityAsync() {
        return this.execute(new GetPropertyCommand.BatteryQuality());
    }

    public String getBodyIDEx() {
        return this.executeNow(new GetPropertyCommand.BodyIDEx());
    }

    public GetPropertyCommand.BodyIDEx getBodyIDExAsync() {
        return this.execute(new GetPropertyCommand.BodyIDEx());
    }

    public EdsFocusInfo getFocusInfo() {
        return this.executeNow(new GetPropertyCommand.FocusInfo());
    }

    public GetPropertyCommand.FocusInfo getFocusInfoAsync() {
        return this.execute(new GetPropertyCommand.FocusInfo());
    }

    public CanonConstants.EdsExposureCompensation getFlashCompensation() {
        return this.executeNow(new GetPropertyCommand.FlashCompensation());
    }

    public GetPropertyCommand.FlashCompensation getFlashCompensationAsync() {
        return this.execute(new GetPropertyCommand.FlashCompensation());
    }

    public Long getAvailableShots() {
        return this.executeNow(new GetPropertyCommand.AvailableShots());
    }

    public GetPropertyCommand.AvailableShots getAvailableShotsAsync() {
        return this.execute(new GetPropertyCommand.AvailableShots());
    }

    public CanonConstants.EdsBracket getBracket() {
        return this.executeNow(new GetPropertyCommand.Bracket());
    }

    public GetPropertyCommand.Bracket getBracketAsync() {
        return this.execute(new GetPropertyCommand.Bracket());
    }

    public int[] getWhiteBalanceBracket() {
        return this.executeNow(new GetPropertyCommand.WhiteBalanceBracket());
    }

    public GetPropertyCommand.WhiteBalanceBracket getWhiteBalanceBracketAsync() {
        return this.execute(new GetPropertyCommand.WhiteBalanceBracket());
    }

    public Boolean getLensStatus() {
        return this.executeNow(new GetPropertyCommand.LensStatus());
    }

    public GetPropertyCommand.LensStatus getLensStatusAsync() {
        return this.execute(new GetPropertyCommand.LensStatus());
    }

    public String getArtist() {
        return this.executeNow(new GetPropertyCommand.Artist());
    }

    public GetPropertyCommand.Artist getArtistAsync() {
        return this.execute(new GetPropertyCommand.Artist());
    }

    public String getCopyright() {
        return this.executeNow(new GetPropertyCommand.Copyright());
    }

    public GetPropertyCommand.Copyright getCopyrightAsync() {
        return this.execute(new GetPropertyCommand.Copyright());
    }

    public String getOwnerName() {
        return this.executeNow(new GetPropertyCommand.OwnerName());
    }

    public GetPropertyCommand.OwnerName getOwnerNameAsync() {
        return this.execute(new GetPropertyCommand.OwnerName());
    }

    public CanonConstants.EdsSaveTo getSaveTo() {
        return this.executeNow(new GetPropertyCommand.SaveTo());
    }

    public GetPropertyCommand.SaveTo getSaveToAsync() {
        return this.execute(new GetPropertyCommand.SaveTo());
    }

    public String getHardDriveDirectoryStructure() {
        return this.executeNow(new GetPropertyCommand.HardDriveDirectoryStructure());
    }

    public GetPropertyCommand.HardDriveDirectoryStructure getHardDriveDirectoryStructureAsync() {
        return this.execute(new GetPropertyCommand.HardDriveDirectoryStructure());
    }

    public Long getJPEGQuality() {
        return this.executeNow(new GetPropertyCommand.JPEGQuality());
    }

    public GetPropertyCommand.JPEGQuality getJPEGQualityAsync() {
        return this.execute(new GetPropertyCommand.JPEGQuality());
    }

    public Long getColorTemperature() {
        return this.executeNow(new GetPropertyCommand.ColorTemperature());
    }

    public GetPropertyCommand.ColorTemperature getColorTemperatureAsync() {
        return this.execute(new GetPropertyCommand.ColorTemperature());
    }

    public int[] getWhiteBalanceShift() {
        return this.executeNow(new GetPropertyCommand.WhiteBalanceShift());
    }

    public GetPropertyCommand.WhiteBalanceShift getWhiteBalanceShiftAsync() {
        return this.execute(new GetPropertyCommand.WhiteBalanceShift());
    }

    public Long getParameterSet() {
        return this.executeNow(new GetPropertyCommand.ParameterSet());
    }

    public GetPropertyCommand.ParameterSet getParameterSetAsync() {
        return this.execute(new GetPropertyCommand.ParameterSet());
    }

    public EdsPictureStyleDesc getPictureStyleDescription() {
        return this.executeNow(new GetPropertyCommand.PictureStyleDescription());
    }

    public GetPropertyCommand.PictureStyleDescription getPictureStyleDescriptionAsync() {
        return this.execute(new GetPropertyCommand.PictureStyleDescription());
    }

    public Long getMovieShootingStatus() {
        return this.executeNow(new GetPropertyCommand.MovieShootingStatus());
    }

    public GetPropertyCommand.MovieShootingStatus getMovieShootingStatusAsync() {
        return this.execute(new GetPropertyCommand.MovieShootingStatus());
    }

    public CanonConstants.EdsEvfOutputDevice getLiveViewOutputDevice() {
        return this.executeNow(new GetPropertyCommand.LiveViewOutputDevice());
    }

    public GetPropertyCommand.LiveViewOutputDevice getLiveViewOutputDeviceAsync() {
        return this.execute(new GetPropertyCommand.LiveViewOutputDevice());
    }

    public Boolean getLiveViewMode() {
        return this.executeNow(new GetPropertyCommand.LiveViewMode());
    }

    public GetPropertyCommand.LiveViewMode getLiveViewModeAsync() {
        return this.execute(new GetPropertyCommand.LiveViewMode());
    }

    public Long getLiveViewColorTemperature() {
        return this.executeNow(new GetPropertyCommand.LiveViewColorTemperature());
    }

    public GetPropertyCommand.LiveViewColorTemperature getLiveViewColorTemperatureAsync() {
        return this.execute(new GetPropertyCommand.LiveViewColorTemperature());
    }

    public Boolean getLiveViewDepthOfFieldInPreview() {
        return this.executeNow(new GetPropertyCommand.LiveViewDepthOfFieldInPreview());
    }

    public GetPropertyCommand.LiveViewDepthOfFieldInPreview getLiveViewDepthOfFieldInPreviewAsync() {
        return this.execute(new GetPropertyCommand.LiveViewDepthOfFieldInPreview());
    }

    public CanonConstants.EdsEvfZoom getLiveViewZoomRatio() {
        return this.executeNow(new GetPropertyCommand.LiveViewZoomRatio());
    }

    public GetPropertyCommand.LiveViewZoomRatio getLiveViewZoomRatioAsync() {
        return this.execute(new GetPropertyCommand.LiveViewZoomRatio());
    }

    public EdsPoint getLiveViewZoomPosition() {
        return this.executeNow(new GetPropertyCommand.LiveViewZoomPosition());
    }

    public GetPropertyCommand.LiveViewZoomPosition getLiveViewZoomPositionAsync() {
        return this.execute(new GetPropertyCommand.LiveViewZoomPosition());
    }

    public int[] getLiveViewHistogram() {
        return this.executeNow(new GetPropertyCommand.LiveViewHistogram());
    }

    public GetPropertyCommand.LiveViewHistogram getLiveViewHistogramAsync() {
        return this.execute(new GetPropertyCommand.LiveViewHistogram());
    }

    public int[] getLiveViewHistogramY() {
        return this.executeNow(new GetPropertyCommand.LiveViewHistogramY());
    }

    public GetPropertyCommand.LiveViewHistogramY getLiveViewHistogramYAsync() {
        return this.execute(new GetPropertyCommand.LiveViewHistogramY());
    }

    public int[] getLiveViewHistogramR() {
        return this.executeNow(new GetPropertyCommand.LiveViewHistogramR());
    }

    public GetPropertyCommand.LiveViewHistogramR getLiveViewHistogramRAsync() {
        return this.execute(new GetPropertyCommand.LiveViewHistogramR());
    }

    public int[] getLiveViewHistogramG() {
        return this.executeNow(new GetPropertyCommand.LiveViewHistogramG());
    }

    public GetPropertyCommand.LiveViewHistogramG getLiveViewHistogramGAsync() {
        return this.execute(new GetPropertyCommand.LiveViewHistogramG());
    }

    public int[] getLiveViewHistogramB() {
        return this.executeNow(new GetPropertyCommand.LiveViewHistogramB());
    }

    public GetPropertyCommand.LiveViewHistogramB getLiveViewHistogramBAsync() {
        return this.execute(new GetPropertyCommand.LiveViewHistogramB());
    }

    public EdsPoint getLiveViewCropPosition() {
        return this.executeNow(new GetPropertyCommand.LiveViewCropPosition());
    }

    public GetPropertyCommand.LiveViewCropPosition getLiveViewCropPositionAsync() {
        return this.execute(new GetPropertyCommand.LiveViewCropPosition());
    }

    public CanonConstants.EdsEvfHistogramStatus getLiveViewHistogramStatus() {
        return this.executeNow(new GetPropertyCommand.LiveViewHistogramStatus());
    }

    public GetPropertyCommand.LiveViewHistogramStatus getLiveViewHistogramStatusAsync() {
        return this.execute(new GetPropertyCommand.LiveViewHistogramStatus());
    }

    public EdsSize getLiveViewCoordinateSystem() {
        return this.executeNow(new GetPropertyCommand.LiveViewCoordinateSystem());
    }

    public GetPropertyCommand.LiveViewCoordinateSystem getLiveViewCoordinateSystemAsync() {
        return this.execute(new GetPropertyCommand.LiveViewCoordinateSystem());
    }

    public EdsRect getLiveViewZoomRectangle() {
        return this.executeNow(new GetPropertyCommand.LiveViewZoomRectangle());
    }

    public GetPropertyCommand.LiveViewZoomRectangle getLiveViewZoomRectangleAsync() {
        return this.execute(new GetPropertyCommand.LiveViewZoomRectangle());
    }

    public int[] getLiveViewCropRectangle() {
        return this.executeNow(new GetPropertyCommand.LiveViewCropRectangle());
    }

    public GetPropertyCommand.LiveViewCropRectangle getLiveViewCropRectangleAsync() {
        return this.execute(new GetPropertyCommand.LiveViewCropRectangle());
    }

    public Boolean setCustomFunction(CanonConstants.EdsCustomFunction customFunction, long value) {
        return this.executeNow(new SetPropertyCommand.CustomFunction(customFunction, value));
    }

    public SetPropertyCommand.CustomFunction setCustomFunctionAsync(CanonConstants.EdsCustomFunction customFunction, long value) {
        return this.execute(new SetPropertyCommand.CustomFunction(customFunction, value));
    }

    public Boolean setArtist(String value) {
        return this.executeNow(new SetPropertyCommand.Artist(value));
    }

    public SetPropertyCommand.Artist setArtistAsync(String value) {
        return this.execute(new SetPropertyCommand.Artist(value));
    }

    public Boolean setCopyright(String value) {
        return this.executeNow(new SetPropertyCommand.Copyright(value));
    }

    public SetPropertyCommand.Copyright setCopyrightAsync(String value) {
        return this.execute(new SetPropertyCommand.Copyright(value));
    }

    public Boolean setOwnerName(String value) {
        return this.executeNow(new SetPropertyCommand.OwnerName(value));
    }

    public SetPropertyCommand.OwnerName setOwnerNameAsync(String value) {
        return this.execute(new SetPropertyCommand.OwnerName(value));
    }

    public Boolean setSaveTo(CanonConstants.EdsSaveTo value) {
        return this.executeNow(new SetPropertyCommand.SaveTo(value));
    }

    public SetPropertyCommand.SaveTo setSaveToAsync(CanonConstants.EdsSaveTo value) {
        return this.execute(new SetPropertyCommand.SaveTo(value));
    }

    public Boolean setHardDriveDirectoryStructure(String value) {
        return this.executeNow(new SetPropertyCommand.HardDriveDirectoryStructure(value));
    }

    public SetPropertyCommand.HardDriveDirectoryStructure setHardDriveDirectoryStructureAsync(String value) {
        return this.execute(new SetPropertyCommand.HardDriveDirectoryStructure(value));
    }

    public Boolean setImageQuality(CanonConstants.EdsImageQuality value) {
        return this.executeNow(new SetPropertyCommand.ImageQuality(value));
    }

    public SetPropertyCommand.ImageQuality setImageQualityAsync(CanonConstants.EdsImageQuality value) {
        return this.execute(new SetPropertyCommand.ImageQuality(value));
    }

    public Boolean setJPEGQuality(long value) {
        return this.executeNow(new SetPropertyCommand.JPEGQuality(value));
    }

    public SetPropertyCommand.JPEGQuality setJPEGQualityAsync(long value) {
        return this.execute(new SetPropertyCommand.JPEGQuality(value));
    }

    public Boolean setWhiteBalance(CanonConstants.EdsWhiteBalance value) {
        return this.executeNow(new SetPropertyCommand.WhiteBalance(value));
    }

    public SetPropertyCommand.WhiteBalance setWhiteBalanceAsync(CanonConstants.EdsWhiteBalance value) {
        return this.execute(new SetPropertyCommand.WhiteBalance(value));
    }

    public Boolean setColorTemperature(long value) {
        return this.executeNow(new SetPropertyCommand.ColorTemperature(value));
    }

    public SetPropertyCommand.ColorTemperature setColorTemperatureAsync(long value) {
        return this.execute(new SetPropertyCommand.ColorTemperature(value));
    }

    public Boolean setWhiteBalanceShift(int[] value) {
        return this.executeNow(new SetPropertyCommand.WhiteBalanceShift(value));
    }

    public SetPropertyCommand.WhiteBalanceShift setWhiteBalanceShiftAsync(int[] value) {
        return this.execute(new SetPropertyCommand.WhiteBalanceShift(value));
    }

    public Boolean setColorSpace(CanonConstants.EdsColorSpace value) {
        return this.executeNow(new SetPropertyCommand.ColorSpace(value));
    }

    public SetPropertyCommand.ColorSpace setColorSpaceAsync(CanonConstants.EdsColorSpace value) {
        return this.execute(new SetPropertyCommand.ColorSpace(value));
    }

    public Boolean setParameterSet(long value) {
        return this.executeNow(new SetPropertyCommand.ParameterSet(value));
    }

    public SetPropertyCommand.ParameterSet setParameterSetAsync(long value) {
        return this.execute(new SetPropertyCommand.ParameterSet(value));
    }

    public Boolean setPictureStyle(CanonConstants.EdsPictureStyle value) {
        return this.executeNow(new SetPropertyCommand.PictureStyle(value));
    }

    public SetPropertyCommand.PictureStyle setPictureStyleAsync(CanonConstants.EdsPictureStyle value) {
        return this.execute(new SetPropertyCommand.PictureStyle(value));
    }

    public Boolean setPictureStyleDescription(EdsPictureStyleDesc value) {
        return this.executeNow(new SetPropertyCommand.PictureStyleDescription(value));
    }

    public SetPropertyCommand.PictureStyleDescription setPictureStyleDescriptionAsync(EdsPictureStyleDesc value) {
        return this.execute(new SetPropertyCommand.PictureStyleDescription(value));
    }

    public Boolean setPictureStyleDescription(long contrast, long sharpness, long saturation, long colorTone, CanonConstants.EdsFilterEffect filterEffect, CanonConstants.EdsTonigEffect toningEffect) {
        return this.executeNow(new SetPropertyCommand.PictureStyleDescription(contrast, sharpness, saturation, colorTone, filterEffect, toningEffect));
    }

    public SetPropertyCommand.PictureStyleDescription setPictureStyleDescriptionAsync(long contrast, long sharpness, long saturation, long colorTone, CanonConstants.EdsFilterEffect filterEffect, CanonConstants.EdsTonigEffect toningEffect) {
        return this.execute(new SetPropertyCommand.PictureStyleDescription(contrast, sharpness, saturation, colorTone, filterEffect, toningEffect));
    }

    public Boolean setDriveMode(CanonConstants.EdsDriveMode value) {
        return this.executeNow(new SetPropertyCommand.DriveMode(value));
    }

    public SetPropertyCommand.DriveMode setDriveModeAsync(CanonConstants.EdsDriveMode value) {
        return this.execute(new SetPropertyCommand.DriveMode(value));
    }

    public Boolean setISOSpeed(CanonConstants.EdsISOSpeed value) {
        return this.executeNow(new SetPropertyCommand.ISOSpeed(value));
    }

    public SetPropertyCommand.ISOSpeed setISOSpeedAsync(CanonConstants.EdsISOSpeed value) {
        return this.execute(new SetPropertyCommand.ISOSpeed(value));
    }

    public Boolean setMeteringMode(CanonConstants.EdsMeteringMode value) {
        return this.executeNow(new SetPropertyCommand.MeteringMode(value));
    }

    public SetPropertyCommand.MeteringMode setMeteringModeAsync(CanonConstants.EdsMeteringMode value) {
        return this.execute(new SetPropertyCommand.MeteringMode(value));
    }

    public Boolean setApertureValue(CanonConstants.EdsAv value) {
        return this.executeNow(new SetPropertyCommand.ApertureValue(value));
    }

    public SetPropertyCommand.ApertureValue setApertureValueAsync(CanonConstants.EdsAv value) {
        return this.execute(new SetPropertyCommand.ApertureValue(value));
    }

    public Boolean setShutterSpeed(CanonConstants.EdsTv value) {
        return this.executeNow(new SetPropertyCommand.ShutterSpeed(value));
    }

    public SetPropertyCommand.ShutterSpeed setShutterSpeedAsync(CanonConstants.EdsTv value) {
        return this.execute(new SetPropertyCommand.ShutterSpeed(value));
    }

    public Boolean setExposureCompensation(CanonConstants.EdsExposureCompensation value) {
        return this.executeNow(new SetPropertyCommand.ExposureCompensation(value));
    }

    public SetPropertyCommand.ExposureCompensation setExposureCompensationAsync(CanonConstants.EdsExposureCompensation value) {
        return this.execute(new SetPropertyCommand.ExposureCompensation(value));
    }

    public Boolean setMovieShootingStatus(long value) {
        return this.executeNow(new SetPropertyCommand.MovieShootingStatus(value));
    }

    public SetPropertyCommand.MovieShootingStatus setMovieShootingStatusAsync(long value) {
        return this.execute(new SetPropertyCommand.MovieShootingStatus(value));
    }

    public Boolean setLiveViewOutputDevice(CanonConstants.EdsEvfOutputDevice value) {
        return this.executeNow(new SetPropertyCommand.LiveViewOutputDevice(value));
    }

    public SetPropertyCommand.LiveViewOutputDevice setLiveViewOutputDeviceAsync(CanonConstants.EdsEvfOutputDevice value) {
        return this.execute(new SetPropertyCommand.LiveViewOutputDevice(value));
    }

    public Boolean setLiveViewMode(boolean value) {
        return this.executeNow(new SetPropertyCommand.LiveViewMode(value));
    }

    public SetPropertyCommand.LiveViewMode setLiveViewModeAsync(boolean value) {
        return this.execute(new SetPropertyCommand.LiveViewMode(value));
    }

    public Boolean setLiveViewWhiteBalance(CanonConstants.EdsWhiteBalance value) {
        return this.executeNow(new SetPropertyCommand.LiveViewWhiteBalance(value));
    }

    public SetPropertyCommand.LiveViewWhiteBalance setLiveViewWhiteBalanceAsync(CanonConstants.EdsWhiteBalance value) {
        return this.execute(new SetPropertyCommand.LiveViewWhiteBalance(value));
    }

    public Boolean setLiveViewColorTemperature(long value) {
        return this.executeNow(new SetPropertyCommand.LiveViewColorTemperature(value));
    }

    public SetPropertyCommand.LiveViewColorTemperature setLiveViewColorTemperatureAsync(long value) {
        return this.execute(new SetPropertyCommand.LiveViewColorTemperature(value));
    }

    public Boolean setLiveViewDepthOfFieldInPreview(boolean value) {
        return this.executeNow(new SetPropertyCommand.LiveViewDepthOfFieldInPreview(value));
    }

    public SetPropertyCommand.LiveViewDepthOfFieldInPreview setLiveViewDepthOfFieldInPreviewAsync(boolean value) {
        return this.execute(new SetPropertyCommand.LiveViewDepthOfFieldInPreview(value));
    }

    public Boolean setLiveViewAutoFocusMode(CanonConstants.EdsEvfAFMode value) {
        return this.executeNow(new SetPropertyCommand.LiveViewAutoFocusMode(value));
    }

    public SetPropertyCommand.LiveViewAutoFocusMode setLiveViewAutoFocusModeAsync(CanonConstants.EdsEvfAFMode value) {
        return this.execute(new SetPropertyCommand.LiveViewAutoFocusMode(value));
    }

    public Boolean setLiveViewZoomRatio(CanonConstants.EdsEvfZoom value) {
        return this.executeNow(new SetPropertyCommand.LiveViewZoomRatio(value));
    }

    public SetPropertyCommand.LiveViewZoomRatio setLiveViewZoomRatioAsync(CanonConstants.EdsEvfZoom value) {
        return this.execute(new SetPropertyCommand.LiveViewZoomRatio(value));
    }

    public Boolean setLiveViewZoomPosition(EdsPoint value) {
        return this.executeNow(new SetPropertyCommand.LiveViewZoomPosition(value));
    }

    public SetPropertyCommand.LiveViewZoomPosition setLiveViewZoomPositionAsync(EdsPoint value) {
        return this.execute(new SetPropertyCommand.LiveViewZoomPosition(value));
    }

    public Boolean setLiveViewZoomPosition(long x, long y) {
        return this.executeNow(new SetPropertyCommand.LiveViewZoomPosition(x, y));
    }

    public SetPropertyCommand.LiveViewZoomPosition setLiveViewZoomPositionAsync(long x, long y) {
        return this.execute(new SetPropertyCommand.LiveViewZoomPosition(x, y));
    }

    public Boolean setShootingMode(CanonConstants.EdsAEMode value) {
        return this.executeNow(new SetPropertyCommand.ShootingMode(value));
    }

    public SetPropertyCommand.ShootingMode setShootingModeAsync(CanonConstants.EdsAEMode value) {
        return this.execute(new SetPropertyCommand.ShootingMode(value));
    }

    static {
        queue = new ConcurrentLinkedQueue();
        objectEventHandlers = new ArrayList(10);
    }
}

