/*
 * Decompiled with CFR 0.152.
 */
package com.birin.gridlistviewadapters.utils;

import android.view.View;
import com.birin.gridlistviewadapters.utils.ChildViewsClickHandler;
import java.lang.reflect.Field;
import java.util.List;

public class ViewHolderPositionTagger {
    public void scanAndTagViewsWithPositionValue(Object holder, int position) {
        for (Field field : holder.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Class<?> thisClass = field.getType();
            if (thisClass.isPrimitive()) continue;
            Object child = null;
            try {
                child = field.get(holder);
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (child == null) continue;
            if (this.isViewInstance(child)) {
                this.tagObjectIfViewInstanceOrScanObjectForEnclosedViews(child, position);
                continue;
            }
            if (child instanceof Object[]) {
                this.tagViewsWithinArray((Object[])child, position);
                continue;
            }
            if (child instanceof List) {
                this.tagViewsWithinList((List)child, position);
                continue;
            }
            this.handleCustomDataObject(child, position);
        }
    }

    protected void tagObjectIfViewInstanceOrScanObjectForEnclosedViews(Object object, int position) {
        if (this.isViewInstance(object)) {
            View view = (View)object;
            this.addPositionTag(view, position);
        } else {
            this.scanAndTagViewsWithPositionValue(object, position);
        }
    }

    private void tagViewsWithinArray(Object[] childrenArray, int position) {
        for (Object child3 : childrenArray) {
            this.tagObjectIfViewInstanceOrScanObjectForEnclosedViews(child3, position);
        }
    }

    private void tagViewsWithinList(List<Object> childrenList, int position) {
        for (Object childObject : childrenList) {
            this.tagObjectIfViewInstanceOrScanObjectForEnclosedViews(childObject, position);
        }
    }

    protected void handleCustomDataObject(Object child, int position) {
        throw new IllegalArgumentException("Unable to tag position data to " + child.getClass().getSimpleName() + " in your view-holder" + " object currently only View, java.util.List of Custom-View-Wrappers," + " Array of Custom-View-wrappers are supported within ViewHolder class" + " if you have custom datastructure within your ViewHolder class consider" + " passing subclass of ViewHolderPositionTagger with your handling in" + " handleCustomDataObject(), and passing that subclass to adapter by" + " overriding getPositionTagger() method in your adapter this class.");
    }

    protected boolean isViewInstance(Object object) {
        return object instanceof View;
    }

    protected void addPositionTag(View view, int position) {
        if (ChildViewsClickHandler.getEventIdFromViewTag(view) >= 0) {
            ChildViewsClickHandler.tagPositionValueToView(view, position);
        }
    }
}

