/*
 * Decompiled with CFR 0.152.
 */
package com.birin.gridlistviewadapters.utils;

import com.birin.gridlistviewadapters.utils.MaxCardsInfo;

public class PositionCalculator {
    private final MaxCardsInfo maxCardsInfo;

    public PositionCalculator(MaxCardsInfo info) {
        this.maxCardsInfo = info;
    }

    public int calculatePositionInNewOrientation(int VISIBLE_POSITION_IN_OLD_ORIENTATION, int OLD_ORIENTATION, int NEW_ORIENTATION) {
        int positionInNewOrientation = VISIBLE_POSITION_IN_OLD_ORIENTATION;
        if (OLD_ORIENTATION != NEW_ORIENTATION) {
            this.validateOrientation(OLD_ORIENTATION);
            this.validateOrientation(NEW_ORIENTATION);
            int maxCardsInOldOrientation = this.getMaxCardsFor(OLD_ORIENTATION);
            int maxCardsInNewOrientation = this.getMaxCardsFor(NEW_ORIENTATION);
            int firstVisibleCardIndexInOldOrientation = VISIBLE_POSITION_IN_OLD_ORIENTATION * maxCardsInOldOrientation;
            positionInNewOrientation = this.calculateBucket(++firstVisibleCardIndexInOldOrientation, maxCardsInNewOrientation);
        }
        return positionInNewOrientation;
    }

    private int calculateBucket(int firstVisibleCardIndexInOldOrientation, int maxCardsInNewOrientation) {
        int quotient = firstVisibleCardIndexInOldOrientation / maxCardsInNewOrientation;
        int remainder = firstVisibleCardIndexInOldOrientation % maxCardsInNewOrientation;
        --quotient;
        if (remainder != 0) {
            ++quotient;
        }
        return quotient;
    }

    public static int getMaxCardsFor(int ORIENTATION, MaxCardsInfo maxCardsInfo) {
        int maxCards = 0;
        if (ORIENTATION == 1) {
            maxCards = maxCardsInfo.getPotraitMaxCards();
        } else if (ORIENTATION == 2) {
            maxCards = maxCardsInfo.getLandscapeMaxCards();
        }
        return maxCards;
    }

    private int getMaxCardsFor(int ORIENTATION) {
        return PositionCalculator.getMaxCardsFor(ORIENTATION, this.maxCardsInfo);
    }

    private void validateOrientation(int ORIENTATION) {
        boolean isValid;
        boolean bl = isValid = ORIENTATION == 2 || ORIENTATION == 1;
        if (!isValid) {
            throw new UnsupportedOperationException("Unsupported Orientation: " + ORIENTATION + ", Valid ones are Configuration.ORIENTATION_LANDSCAPE, Configuration.ORIENTATION_PORTRAIT");
        }
    }
}

