/*
 * Decompiled with CFR 0.152.
 */
package com.birin.gridlistviewadapters.utils;

import com.birin.gridlistviewadapters.dataholders.CardPositionInfo;
import com.birin.gridlistviewadapters.dataholders.RowDataHolder;
import java.util.List;

public class GridDataStructure {
    private int totalCardsInRow = 0;

    public GridDataStructure(int totalCardsInRow) {
        this.totalCardsInRow = totalCardsInRow;
        if (totalCardsInRow <= 0) {
            throw new IllegalArgumentException("Invalid number of cards in a row should be greater than 0");
        }
    }

    public void updateStructure(List<RowDataHolder> gridStructuredDataList, int dataListSize) {
        RowDataHolder lastRow;
        boolean isFirstChunk;
        if (null == gridStructuredDataList) {
            throw new IllegalArgumentException("Data lists shouldn't be empty.");
        }
        int size = gridStructuredDataList.size();
        int absoluteCardposition = 0;
        int emptyCardIndex = -1;
        boolean bl = isFirstChunk = size == 0;
        if (!isFirstChunk && null != (lastRow = gridStructuredDataList.get(size - 1))) {
            CardPositionInfo positionInfo;
            absoluteCardposition = lastRow.getCardPositionInfos().get(this.totalCardsInRow - 1).getAbsolutePositionValue() + 1;
            for (int i = this.totalCardsInRow - 1; i >= 0 && (positionInfo = lastRow.getCardPositionInfos().get(i)).isEmptyCard(); --i) {
                absoluteCardposition = positionInfo.getAbsolutePositionValue();
                emptyCardIndex = i;
                lastRow.getCardPositionInfos().remove(i);
            }
            if (emptyCardIndex != -1) {
                for (int cardPositionInaRow = emptyCardIndex; cardPositionInaRow < this.totalCardsInRow; ++cardPositionInaRow) {
                    absoluteCardposition = this.addNewCard(lastRow, absoluteCardposition, dataListSize);
                }
            }
        }
        while (absoluteCardposition < dataListSize) {
            absoluteCardposition = this.addNewRow(gridStructuredDataList, dataListSize, absoluteCardposition);
        }
    }

    private int addNewRow(List<RowDataHolder> gridRowList, int dataListSize, int absoluteCardposition) {
        RowDataHolder newRow = new RowDataHolder();
        for (int i = 0; i < this.totalCardsInRow; ++i) {
            absoluteCardposition = this.addNewCard(newRow, absoluteCardposition, dataListSize);
        }
        gridRowList.add(newRow);
        return absoluteCardposition;
    }

    private int addNewCard(RowDataHolder gridRow, int absoluteCardposition, int dataListSize) {
        boolean isEmptyCard = false;
        if (absoluteCardposition >= dataListSize) {
            isEmptyCard = true;
        }
        int type = -1;
        type = isEmptyCard ? 112 : 111;
        CardPositionInfo cardPositionInfo = new CardPositionInfo(type, absoluteCardposition);
        gridRow.getCardPositionInfos().add(cardPositionInfo);
        return ++absoluteCardposition;
    }
}

