/*
 * Decompiled with CFR 0.152.
 */
package com.birin.gridlistviewadapters.utils;

import android.view.View;
import com.birin.gridlistviewadapters.R;

public final class ChildViewsClickHandler {
    private static int TAG_VIEW_POSITION = R.string.key_view_position;
    private static int TAG_CLICK_EVENT_ID = R.string.key_click_event_id;
    private View.OnClickListener onClickListener;

    public ChildViewsClickHandler(View.OnClickListener clickEventListener) {
        this.onClickListener = clickEventListener;
    }

    public void registerChildViewForClickEvent(View childView, int clickEventId) {
        if (clickEventId < 0) {
            throw new IllegalArgumentException("Event-Id should be a positive integer");
        }
        ChildViewsClickHandler.tagEventIdValueToView(childView, clickEventId);
        childView.setOnClickListener(this.onClickListener);
    }

    public static int getPositionFromViewTag(View view) {
        return ChildViewsClickHandler.getIntValueFromViewTag(view, TAG_VIEW_POSITION);
    }

    public static int getEventIdFromViewTag(View view) {
        return ChildViewsClickHandler.getIntValueFromViewTag(view, TAG_CLICK_EVENT_ID);
    }

    public static void tagPositionValueToView(View view, int value) {
        ChildViewsClickHandler.tagIntValueToView(view, TAG_VIEW_POSITION, value);
    }

    public static void tagEventIdValueToView(View view, int value) {
        ChildViewsClickHandler.tagIntValueToView(view, TAG_CLICK_EVENT_ID, value);
    }

    private static int getIntValueFromViewTag(View view, int key) {
        Object taggedValue;
        if (null != view && null != (taggedValue = view.getTag(key)) && taggedValue instanceof Integer) {
            return (Integer)taggedValue;
        }
        return -1;
    }

    private static void tagIntValueToView(View view, int key, int value) {
        if (null != view) {
            view.setTag(key, (Object)value);
        }
    }
}

