/*
 * Decompiled with CFR 0.152.
 */
package com.birin.gridlistviewadapters;

import android.content.Context;
import com.birin.gridlistviewadapters.BaseGridAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class ListGridAdapter<T, CVH>
extends BaseGridAdapter<T, CVH> {
    private List<T> dataList = new ArrayList<T>();

    public ListGridAdapter(Context context, int totalCardsInRow) {
        super(context, totalCardsInRow);
    }

    @Override
    public T getCardData(int absoluteCardPosition) {
        this.validatePositionOrThrow(absoluteCardPosition);
        return this.dataList.get(absoluteCardPosition);
    }

    @Override
    public void validatePositionOrThrow(int position) {
        if (position < 0 || position >= this.getAbsoluteCardsCount()) {
            throw new IndexOutOfBoundsException("Position requested " + position + " Available list size " + this.getAbsoluteCardsCount());
        }
    }

    @Override
    public int getAbsoluteCardsCount() {
        if (null != this.dataList) {
            return this.dataList.size();
        }
        return 0;
    }

    public void addItemsInGrid(List<T> newDataList) {
        int newDataSize = 0;
        if (newDataList != null && !newDataList.isEmpty()) {
            this.dataList.addAll(newDataList);
            newDataSize = this.getAbsoluteCardsCount();
        }
        this.updateGridWithNewSize(newDataSize);
    }

    public void swapDataList(List<T> newDataList) {
        this.dataList.clear();
        this.invalidateStructure();
        this.addItemsInGrid(newDataList);
    }

    public void deleteItemFromList(int position) {
        this.validatePositionOrThrow(position);
        this.dataList.remove(position);
        this.invalidateStructure();
        this.updateGridWithNewSize(this.getAbsoluteCardsCount());
    }

    public boolean deleteItemFromList(T data) {
        boolean isRemoved = this.dataList.remove(data);
        if (isRemoved) {
            this.invalidateStructure();
            this.updateGridWithNewSize(this.getAbsoluteCardsCount());
        }
        return isRemoved;
    }

    public void clearList() {
        this.swapDataList(null);
    }
}

