/*
 * Decompiled with CFR 0.152.
 */
package com.birin.gridlistviewadapters;

import android.content.Context;
import android.database.Cursor;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;
import com.birin.gridlistviewadapters.BaseGridAdapter;
import com.birin.gridlistviewadapters.CursorFilter;

public abstract class CursorGridAdapter<CVH>
extends BaseGridAdapter<Cursor, CVH>
implements Filterable,
CursorFilter.CursorFilterClient {
    protected Cursor mCursor;
    protected CursorFilter mCursorFilter;
    protected FilterQueryProvider mFilterQueryProvider;

    public CursorGridAdapter(Context context, int totalCardsInRow, Cursor c) {
        super(context, totalCardsInRow);
        this.init(c);
    }

    void init(Cursor c) {
        boolean cursorPresent = c != null;
        this.mCursor = c;
        if (cursorPresent) {
            this.updateGridWithNewSize(c.getCount());
        }
    }

    @Override
    public Cursor getCursor() {
        return this.mCursor;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return null;
    }

    @Override
    public void changeCursor(Cursor cursor) {
        Cursor old = this.swapCursor(cursor);
        if (old != null) {
            old.close();
        }
    }

    public Cursor swapCursor(Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return null;
        }
        Cursor oldCursor = this.mCursor;
        this.mCursor = newCursor;
        this.invalidateStructure();
        if (newCursor != null) {
            this.updateGridWithNewSize(newCursor.getCount());
        } else {
            this.notifyDataSetChanged();
        }
        return oldCursor;
    }

    @Override
    public CharSequence convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mCursor;
    }

    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    @Override
    public void validatePositionOrThrow(int position) {
        if (position < 0 || position >= this.getAbsoluteCardsCount()) {
            throw new IndexOutOfBoundsException("Position requested " + position + " Available Cursor size " + this.getAbsoluteCardsCount());
        }
    }

    @Override
    public int getAbsoluteCardsCount() {
        if (this.mCursor != null) {
            return this.mCursor.getCount();
        }
        return 0;
    }

    @Override
    public Cursor getCardData(int absoluteCardPosition) {
        this.validatePositionOrThrow(absoluteCardPosition);
        if (this.mCursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (!this.mCursor.moveToPosition(absoluteCardPosition)) {
            throw new IllegalStateException("couldn't move cursor to position " + absoluteCardPosition);
        }
        return this.mCursor;
    }
}

