/*
 * Decompiled with CFR 0.152.
 */
package com.birin.gridlistviewadapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import com.birin.gridlistviewadapters.Card;
import com.birin.gridlistviewadapters.RowViewHolder;
import com.birin.gridlistviewadapters.dataholders.CardDataHolder;
import com.birin.gridlistviewadapters.dataholders.CardPositionInfo;
import com.birin.gridlistviewadapters.dataholders.RowDataHolder;
import com.birin.gridlistviewadapters.utils.ChildViewsClickHandler;
import com.birin.gridlistviewadapters.utils.GridDataStructure;
import com.birin.gridlistviewadapters.utils.OnLoadMoreRequestListener;
import com.birin.gridlistviewadapters.utils.ViewHolderPositionTagger;
import java.util.ArrayList;
import java.util.List;

abstract class BaseGridAdapter<E, CVH>
extends BaseAdapter {
    private final int DEVICE_WT;
    private final int DEVICE_HT;
    private final int CARD_SPACING;
    private final float SPACING_BETWEEN_CARDS_SCREEN_PERCENT = 0.02f;
    private final int CARD_CLICK_EVENT_ID = -99;
    private Context context = null;
    private LayoutInflater inflater = null;
    private OnLoadMoreRequestListener loadMoreRequestListener;
    private List<RowDataHolder> gridStructuredData = null;
    private GridDataStructure dataStructureCreator = null;
    private ChildViewsClickHandler childViewsClickHandler;
    private ViewHolderPositionTagger positionTagger;
    private View.OnClickListener childrenOnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            int absoluteCardPosition = ChildViewsClickHandler.getPositionFromViewTag(view);
            int eventId = ChildViewsClickHandler.getEventIdFromViewTag(view);
            Object cardData = BaseGridAdapter.this.getCardData(absoluteCardPosition);
            if (BaseGridAdapter.this.isCardClickEvent(eventId)) {
                BaseGridAdapter.this.onCardClicked(cardData);
            } else {
                BaseGridAdapter.this.onChildViewClicked(view, cardData, eventId);
            }
        }
    };

    public BaseGridAdapter(Context context, int totalCardsInRow) {
        this.context = context;
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.dataStructureCreator = this.getDataStructureManager(totalCardsInRow);
        this.gridStructuredData = new ArrayList<RowDataHolder>();
        DisplayMetrics displaymetrics = context.getResources().getDisplayMetrics();
        this.DEVICE_WT = displaymetrics.widthPixels;
        this.DEVICE_HT = displaymetrics.heightPixels;
        this.CARD_SPACING = this.getCardSpacing();
        this.positionTagger = this.getPositionTagger();
        this.childViewsClickHandler = new ChildViewsClickHandler(this.childrenOnClickListener);
    }

    protected GridDataStructure getDataStructureManager(int totalCardsInRow) {
        return new GridDataStructure(totalCardsInRow);
    }

    protected ViewHolderPositionTagger getPositionTagger() {
        return new ViewHolderPositionTagger();
    }

    public int getCount() {
        if (null != this.gridStructuredData) {
            return this.gridStructuredData.size();
        }
        return 0;
    }

    public RowDataHolder getItem(int position) {
        if (null != this.gridStructuredData && position < this.gridStructuredData.size()) {
            return this.gridStructuredData.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    @SuppressLint(value={"InflateParams"})
    public View getView(int position, View rowView, ViewGroup parent) {
        RowViewHolder<CVH> rowViewHolder = null;
        RowDataHolder rowDataHolder = this.getItem(position);
        int totalCardsInRow = rowDataHolder.getCardPositionInfos().size();
        if (rowView == null) {
            rowView = this.getNewRowView();
            rowViewHolder = this.getNewRowViewHolder();
            this.addNewCardsInRow((LinearLayout)rowView, rowViewHolder, totalCardsInRow);
            rowView.setTag(rowViewHolder);
        } else {
            rowViewHolder = this.getTaggedRowViewHolder(rowView);
        }
        this.setCardViews(rowView, rowViewHolder, rowDataHolder);
        this.setRowView(rowView, position);
        this.setRowSpacing(rowView, position);
        this.setRowViewProperties(rowView);
        this.checkAndDispatchLoadMoreEvent(position);
        return rowView;
    }

    private RowViewHolder<CVH> getTaggedRowViewHolder(View rowView) {
        return (RowViewHolder)rowView.getTag();
    }

    private View getNewRowView() {
        return new LinearLayout(this.context);
    }

    private RowViewHolder<CVH> getNewRowViewHolder() {
        return new RowViewHolder();
    }

    private void checkAndDispatchLoadMoreEvent(int position) {
        if (position == this.getCount() - 1 && this.isLoadMoreRequestListenerSet()) {
            this.dispatchLoadMoreRequest();
        }
    }

    private void dispatchLoadMoreRequest() {
        this.loadMoreRequestListener.onLoadMoreRequested();
    }

    protected void setRowViewProperties(View rowView) {
        rowView.setClickable(true);
        rowView.setEnabled(false);
        rowView.setFocusable(false);
    }

    private void setRowSpacing(View rowView, int position) {
        int topPadding = this.getRowSpacing();
        boolean isLastRow = position == this.getCount() - 1;
        int bottomPadding = isLastRow ? topPadding : 0;
        rowView.setPadding(0, topPadding, 0, bottomPadding);
    }

    private void setCardViews(View rowView, RowViewHolder<CVH> rowViewHolder, RowDataHolder rowDataHolder) {
        int totalCardsInRow = rowDataHolder.getCardPositionInfos().size();
        for (int positionInRow = 0; positionInRow < totalCardsInRow; ++positionInRow) {
            View cardView = rowView.findViewWithTag((Object)positionInRow);
            CardPositionInfo cardPositionInfo = rowDataHolder.getCardPositionInfos().get(positionInRow);
            CVH cardViewHolder = rowViewHolder.getCardViewHolders().get(positionInRow);
            this.setSingleCardView(cardView, cardViewHolder, cardPositionInfo);
        }
    }

    private void setSingleCardView(View cardView, CVH cardViewHolder, CardPositionInfo cardPositionInfo) {
        if (cardPositionInfo.isEmptyCard()) {
            this.hideCardView(cardView);
        } else {
            this.setVisibleCardViews(cardView, cardViewHolder, cardPositionInfo);
        }
    }

    private void hideCardView(View cardView) {
        cardView.setVisibility(8);
    }

    private void setVisibleCardViews(View cardView, CVH cardViewHolder, CardPositionInfo cardPositionInfo) {
        cardView.setVisibility(0);
        int absoluteCardPosition = cardPositionInfo.getAbsolutePositionValue();
        this.positionTagger.scanAndTagViewsWithPositionValue(cardViewHolder, absoluteCardPosition);
        E cardData = this.getCardData(absoluteCardPosition);
        CardDataHolder<E> cardDataHolder = new CardDataHolder<E>(cardData, cardPositionInfo);
        this.setCardView(cardDataHolder, cardViewHolder);
        this.registerCardForClickEvent(cardView, absoluteCardPosition);
    }

    private void registerCardForClickEvent(View cardView, int absoluteCardPosition) {
        ChildViewsClickHandler.tagPositionValueToView(cardView, absoluteCardPosition);
        ChildViewsClickHandler.tagEventIdValueToView(cardView, -99);
        cardView.setOnClickListener(this.childrenOnClickListener);
    }

    private boolean isCardClickEvent(int eventId) {
        return eventId == -99;
    }

    private void addNewCardsInRow(LinearLayout rowView, RowViewHolder<CVH> rowViewHolder, int totalCardsInRow) {
        int cardwidth = this.getCardWidth(totalCardsInRow);
        LinearLayout.LayoutParams layoutParams = null;
        CVH cardViewHolder = null;
        for (int positionInRow = 0; positionInRow < totalCardsInRow; ++positionInRow) {
            boolean isLastCardInaRow = positionInRow == totalCardsInRow - 1;
            Card<CVH> card = this.getNewCard(cardwidth);
            View cardView = card.getCardView();
            cardView.setTag((Object)positionInRow);
            layoutParams = this.getCardLayoutParams(cardwidth, isLastCardInaRow);
            rowView.addView(cardView, (ViewGroup.LayoutParams)layoutParams);
            cardViewHolder = card.getCardViewHolder();
            rowViewHolder.getCardViewHolders().add(cardViewHolder);
            this.registerChildrenViewClickEvents(cardViewHolder, this.childViewsClickHandler);
        }
    }

    private LinearLayout.LayoutParams getCardLayoutParams(int cardwidth, boolean isLastCardInaRow) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(cardwidth, -2);
        layoutParams.leftMargin = this.CARD_SPACING;
        if (isLastCardInaRow) {
            layoutParams.rightMargin = this.CARD_SPACING;
        }
        return layoutParams;
    }

    void updateGridWithNewSize(int totalDataSize) {
        if (totalDataSize > 0) {
            this.dataStructureCreator.updateStructure(this.gridStructuredData, totalDataSize);
        }
        this.notifyDataSetChanged();
    }

    void invalidateStructure() {
        this.gridStructuredData.clear();
    }

    public int getRowSpacing() {
        return this.getCardSpacing();
    }

    public int getCardSpacing() {
        int minDeviceDimention = this.DEVICE_HT > this.DEVICE_WT ? this.DEVICE_WT : this.DEVICE_HT;
        return (int)(0.02f * (float)minDeviceDimention);
    }

    public int getCardWidth(int totalCardsInRow) {
        int cardwidth = (this.DEVICE_WT - (totalCardsInRow + 1) * this.CARD_SPACING) / totalCardsInRow;
        return cardwidth;
    }

    public Context getContext() {
        return this.context;
    }

    public LayoutInflater getLayoutInflater() {
        return this.inflater;
    }

    public int getDeviceWidth() {
        return this.DEVICE_WT;
    }

    public int getDeviceHeight() {
        return this.DEVICE_HT;
    }

    protected void setRowView(View rowView, int position) {
        rowView.setBackgroundColor(-3355444);
    }

    public void setOnLoadMoreRequestListener(OnLoadMoreRequestListener loadMoreRequestListener) {
        this.loadMoreRequestListener = loadMoreRequestListener;
    }

    private boolean isLoadMoreRequestListenerSet() {
        return this.loadMoreRequestListener != null;
    }

    public abstract E getCardData(int var1);

    public abstract int getAbsoluteCardsCount();

    public abstract void validatePositionOrThrow(int var1);

    protected abstract Card<CVH> getNewCard(int var1);

    protected abstract void setCardView(CardDataHolder<E> var1, CVH var2);

    protected abstract void onCardClicked(E var1);

    protected abstract void registerChildrenViewClickEvents(CVH var1, ChildViewsClickHandler var2);

    protected abstract void onChildViewClicked(View var1, E var2, int var3);
}

