/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.scheduling;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.PersistableBundle;
import android.support.annotation.Nullable;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.scheduling.FrameworkJobSchedulerService;
import com.birbit.android.jobqueue.scheduling.Scheduler;
import com.birbit.android.jobqueue.scheduling.SchedulerConstraint;
import java.util.UUID;

@TargetApi(value=21)
class FrameworkScheduler
extends Scheduler {
    private static final String KEY_UUID = "uuid";
    static final String KEY_ID = "id";
    private static final String KEY_DELAY = "delay";
    private static final String KEY_NETWORK_STATUS = "networkStatus";
    private static final String KEY_DEADLINE = "keyDeadline";
    private JobScheduler jobScheduler;
    private SharedPreferences preferences;
    private ComponentName componentName;
    @Nullable
    private JobService jobService;
    final Class<? extends FrameworkJobSchedulerService> serviceImpl;

    FrameworkScheduler(Class<? extends FrameworkJobSchedulerService> serviceImpl) {
        this.serviceImpl = serviceImpl;
    }

    void setJobService(@Nullable JobService jobService) {
        this.jobService = jobService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedPreferences getPreferences(Context context) {
        Class<FrameworkScheduler> clazz = FrameworkScheduler.class;
        synchronized (FrameworkScheduler.class) {
            if (this.preferences == null) {
                this.preferences = context.getSharedPreferences("jobqueue_fw_scheduler", 0);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.preferences;
        }
    }

    ComponentName getComponentName() {
        if (this.componentName == null) {
            this.componentName = new ComponentName(this.getApplicationContext().getPackageName(), this.serviceImpl.getCanonicalName());
        }
        return this.componentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    int createId() {
        Class<FrameworkScheduler> clazz = FrameworkScheduler.class;
        synchronized (FrameworkScheduler.class) {
            SharedPreferences preferences = this.getPreferences(this.getApplicationContext());
            int id = preferences.getInt(KEY_ID, 0) + 1;
            preferences.edit().putInt(KEY_ID, id).commit();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return id;
        }
    }

    JobScheduler getJobScheduler() {
        if (this.jobScheduler == null) {
            this.jobScheduler = (JobScheduler)this.getApplicationContext().getSystemService("jobscheduler");
        }
        return this.jobScheduler;
    }

    @Override
    public void request(SchedulerConstraint constraint) {
        JobScheduler jobScheduler = this.getJobScheduler();
        int id = this.createId();
        JobInfo.Builder builder = new JobInfo.Builder(id, this.getComponentName()).setExtras(FrameworkScheduler.toPersistentBundle(constraint)).setPersisted(true);
        switch (constraint.getNetworkStatus()) {
            case 2: {
                builder.setRequiredNetworkType(2);
                break;
            }
            case 1: {
                builder.setRequiredNetworkType(1);
                break;
            }
            default: {
                builder.setRequiredNetworkType(0);
                builder.setRequiresDeviceIdle(true);
            }
        }
        if (constraint.getDelayInMs() > 0L) {
            builder.setMinimumLatency(constraint.getDelayInMs());
        }
        if (constraint.getOverrideDeadlineInMs() != null) {
            builder.setOverrideDeadline(constraint.getOverrideDeadlineInMs().longValue());
        }
        int scheduled = jobScheduler.schedule(builder.build());
        JqLog.d("[FW Scheduler] scheduled a framework job. Success? %s id: %d created id: %d", scheduled > 0, scheduled, id);
    }

    @Override
    public void onFinished(SchedulerConstraint constraint, boolean reschedule) {
        JqLog.d("[FW Scheduler] on finished job %s. reschedule:%s", constraint, reschedule);
        JobService service = this.jobService;
        if (service == null) {
            JqLog.e("[FW Scheduler] scheduler onFinished is called but i don't have a job service", new Object[0]);
            return;
        }
        Object data = constraint.getData();
        if (data instanceof JobParameters) {
            JobParameters params = (JobParameters)data;
            service.jobFinished(params, reschedule);
        } else {
            JqLog.e("[FW Scheduler] cannot obtain the job parameters", new Object[0]);
        }
    }

    @Override
    public void cancelAll() {
        JqLog.d("[FW Scheduler] cancel all", new Object[0]);
        this.getJobScheduler().cancelAll();
    }

    static PersistableBundle toPersistentBundle(SchedulerConstraint constraint) {
        PersistableBundle bundle = new PersistableBundle();
        bundle.putString(KEY_UUID, constraint.getUuid());
        bundle.putInt(KEY_NETWORK_STATUS, constraint.getNetworkStatus());
        bundle.putLong(KEY_DELAY, constraint.getDelayInMs());
        Long deadline = constraint.getOverrideDeadlineInMs();
        if (deadline != null) {
            bundle.putLong(KEY_DEADLINE, deadline.longValue());
        }
        return bundle;
    }

    static SchedulerConstraint fromBundle(PersistableBundle bundle) throws Exception {
        SchedulerConstraint constraint = new SchedulerConstraint(bundle.getString(KEY_UUID));
        if (constraint.getUuid() == null) {
            constraint.setUuid(UUID.randomUUID().toString());
        }
        constraint.setNetworkStatus(bundle.getInt(KEY_NETWORK_STATUS, 0));
        constraint.setDelayInMs(bundle.getLong(KEY_DELAY, 0L));
        if (bundle.containsKey(KEY_DEADLINE)) {
            constraint.setOverrideDeadlineInMs(bundle.getLong(KEY_DEADLINE, Long.MAX_VALUE));
        }
        return constraint;
    }

    boolean onStartJob(JobParameters params) {
        SchedulerConstraint constraint;
        try {
            constraint = FrameworkScheduler.fromBundle(params.getExtras());
        }
        catch (Exception e) {
            JqLog.e(e, "bad bundle from framework job scheduler start callback.", new Object[0]);
            return false;
        }
        JqLog.d("[FW Scheduler] start job %s %d", constraint, params.getJobId());
        constraint.setData(params);
        return this.start(constraint);
    }

    boolean onStopJob(JobParameters params) {
        SchedulerConstraint constraint;
        try {
            constraint = FrameworkScheduler.fromBundle(params.getExtras());
        }
        catch (Exception e) {
            JqLog.e(e, "bad bundle from job scheduler stop callback", new Object[0]);
            return false;
        }
        return this.stop(constraint);
    }
}

