/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.persistentQueue.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.persistentQueue.sqlite.DbOpenHelper;

public class SqlHelper {
    String FIND_BY_ID_QUERY;
    String FIND_BY_TAG_QUERY;
    String LOAD_ALL_IDS_QUERY;
    String LOAD_TAGS_QUERY;
    String RE_ENABLE_PENDING_CANCELLATIONS_QUERY;
    private SQLiteStatement insertStatement;
    private SQLiteStatement insertTagsStatement;
    private SQLiteStatement insertOrReplaceStatement;
    private SQLiteStatement deleteStatement;
    private SQLiteStatement deleteJobTagsStatement;
    private SQLiteStatement onJobFetchedForRunningStatement;
    private SQLiteStatement countStatement;
    private SQLiteStatement markAsCancelledStatement;
    final StringBuilder reusedStringBuilder = new StringBuilder();
    final SQLiteDatabase db;
    final String tableName;
    final String primaryKeyColumnName;
    final int columnCount;
    final String tagsTableName;
    final int tagsColumnCount;
    final long sessionId;

    public SqlHelper(SQLiteDatabase db, String tableName, String primaryKeyColumnName, int columnCount, String tagsTableName, int tagsColumnCount, long sessionId) {
        this.db = db;
        this.tableName = tableName;
        this.columnCount = columnCount;
        this.primaryKeyColumnName = primaryKeyColumnName;
        this.sessionId = sessionId;
        this.tagsColumnCount = tagsColumnCount;
        this.tagsTableName = tagsTableName;
        this.FIND_BY_ID_QUERY = "SELECT * FROM " + tableName + " WHERE " + DbOpenHelper.ID_COLUMN.columnName + " = ?";
        this.FIND_BY_TAG_QUERY = "SELECT * FROM " + tableName + " WHERE " + DbOpenHelper.ID_COLUMN.columnName + " IN ( SELECT " + DbOpenHelper.TAGS_JOB_ID_COLUMN.columnName + " FROM " + tagsTableName + " WHERE " + DbOpenHelper.TAGS_NAME_COLUMN.columnName + " = ?)";
        this.LOAD_ALL_IDS_QUERY = "SELECT " + DbOpenHelper.ID_COLUMN.columnName + " FROM " + tableName;
        this.LOAD_TAGS_QUERY = "SELECT " + DbOpenHelper.TAGS_NAME_COLUMN.columnName + " FROM " + "job_holder_tags" + " WHERE " + DbOpenHelper.TAGS_JOB_ID_COLUMN.columnName + " = ?";
        this.RE_ENABLE_PENDING_CANCELLATIONS_QUERY = "UPDATE " + tableName + " SET " + DbOpenHelper.CANCELLED_COLUMN.columnName + " = 0";
    }

    public static String create(String tableName, Property primaryKey, Property ... properties) {
        StringBuilder builder = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        builder.append(tableName).append(" (");
        builder.append(primaryKey.columnName).append(" ");
        builder.append(primaryKey.type);
        builder.append("  primary key ");
        for (Property property : properties) {
            builder.append(", `").append(property.columnName).append("` ").append(property.type);
            if (!property.unique) continue;
            builder.append(" UNIQUE");
        }
        for (Property property : properties) {
            if (property.foreignKey == null) continue;
            ForeignKey key = property.foreignKey;
            builder.append(", FOREIGN KEY(`").append(property.columnName).append("`) REFERENCES ").append(key.targetTable).append("(`").append(key.targetFieldName).append("`) ON DELETE CASCADE");
        }
        builder.append(" );");
        JqLog.d(builder.toString(), new Object[0]);
        return builder.toString();
    }

    public static String drop(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    public SQLiteStatement getInsertStatement() {
        if (this.insertStatement == null) {
            this.reusedStringBuilder.setLength(0);
            this.reusedStringBuilder.append("INSERT INTO ").append(this.tableName);
            this.reusedStringBuilder.append(" VALUES (");
            for (int i = 0; i < this.columnCount; ++i) {
                if (i != 0) {
                    this.reusedStringBuilder.append(",");
                }
                this.reusedStringBuilder.append("?");
            }
            this.reusedStringBuilder.append(")");
            this.insertStatement = this.db.compileStatement(this.reusedStringBuilder.toString());
        }
        return this.insertStatement;
    }

    public SQLiteStatement getInsertTagsStatement() {
        if (this.insertTagsStatement == null) {
            this.reusedStringBuilder.setLength(0);
            this.reusedStringBuilder.append("INSERT INTO ").append("job_holder_tags");
            this.reusedStringBuilder.append(" VALUES (");
            for (int i = 0; i < this.tagsColumnCount; ++i) {
                if (i != 0) {
                    this.reusedStringBuilder.append(",");
                }
                this.reusedStringBuilder.append("?");
            }
            this.reusedStringBuilder.append(")");
            this.insertTagsStatement = this.db.compileStatement(this.reusedStringBuilder.toString());
        }
        return this.insertTagsStatement;
    }

    public SQLiteStatement getCountStatement() {
        if (this.countStatement == null) {
            this.countStatement = this.db.compileStatement("SELECT COUNT(*) FROM " + this.tableName + " WHERE " + DbOpenHelper.RUNNING_SESSION_ID_COLUMN.columnName + " != ?");
        }
        return this.countStatement;
    }

    public SQLiteStatement getInsertOrReplaceStatement() {
        if (this.insertOrReplaceStatement == null) {
            this.reusedStringBuilder.setLength(0);
            this.reusedStringBuilder.append("INSERT OR REPLACE INTO ").append(this.tableName);
            this.reusedStringBuilder.append(" VALUES (");
            for (int i = 0; i < this.columnCount; ++i) {
                if (i != 0) {
                    this.reusedStringBuilder.append(",");
                }
                this.reusedStringBuilder.append("?");
            }
            this.reusedStringBuilder.append(")");
            this.insertOrReplaceStatement = this.db.compileStatement(this.reusedStringBuilder.toString());
        }
        return this.insertOrReplaceStatement;
    }

    public SQLiteStatement getDeleteStatement() {
        if (this.deleteStatement == null) {
            this.deleteStatement = this.db.compileStatement("DELETE FROM " + this.tableName + " WHERE " + this.primaryKeyColumnName + " = ?");
        }
        return this.deleteStatement;
    }

    public SQLiteStatement getDeleteJobTagsStatement() {
        if (this.deleteJobTagsStatement == null) {
            this.deleteJobTagsStatement = this.db.compileStatement("DELETE FROM " + this.tagsTableName + " WHERE " + DbOpenHelper.TAGS_JOB_ID_COLUMN.columnName + "= ?");
        }
        return this.deleteJobTagsStatement;
    }

    public SQLiteStatement getOnJobFetchedForRunningStatement() {
        if (this.onJobFetchedForRunningStatement == null) {
            String sql = "UPDATE " + this.tableName + " SET " + DbOpenHelper.RUN_COUNT_COLUMN.columnName + " = ? , " + DbOpenHelper.RUNNING_SESSION_ID_COLUMN.columnName + " = ? " + " WHERE " + this.primaryKeyColumnName + " = ? ";
            this.onJobFetchedForRunningStatement = this.db.compileStatement(sql);
        }
        return this.onJobFetchedForRunningStatement;
    }

    public SQLiteStatement getMarkAsCancelledStatement() {
        if (this.markAsCancelledStatement == null) {
            String sql = "UPDATE " + this.tableName + " SET " + DbOpenHelper.CANCELLED_COLUMN.columnName + " = 1 " + " WHERE " + this.primaryKeyColumnName + " = ? ";
            this.markAsCancelledStatement = this.db.compileStatement(sql);
        }
        return this.markAsCancelledStatement;
    }

    public String createSelect(String where, Integer limit, Order ... orders) {
        this.reusedStringBuilder.setLength(0);
        this.reusedStringBuilder.append("SELECT * FROM ");
        this.reusedStringBuilder.append(this.tableName);
        if (where != null) {
            this.reusedStringBuilder.append(" WHERE ").append(where);
        }
        boolean first = true;
        for (Order order : orders) {
            if (first) {
                this.reusedStringBuilder.append(" ORDER BY ");
            } else {
                this.reusedStringBuilder.append(",");
            }
            first = false;
            this.reusedStringBuilder.append(order.property.columnName).append(" ").append((Object)order.type);
        }
        if (limit != null) {
            this.reusedStringBuilder.append(" LIMIT ").append(limit);
        }
        return this.reusedStringBuilder.toString();
    }

    public String createSelectOneField(String selectArg, String where, Integer limit, Order ... orders) {
        this.reusedStringBuilder.setLength(0);
        this.reusedStringBuilder.append("SELECT ").append(selectArg).append(" FROM ").append(this.tableName);
        if (where != null) {
            this.reusedStringBuilder.append(" WHERE ").append(where);
        }
        boolean first = true;
        for (Order order : orders) {
            if (first) {
                this.reusedStringBuilder.append(" ORDER BY ");
            } else {
                this.reusedStringBuilder.append(",");
            }
            first = false;
            this.reusedStringBuilder.append(order.property.columnName).append(" ").append((Object)order.type);
        }
        if (limit != null) {
            this.reusedStringBuilder.append(" LIMIT ").append(limit);
        }
        return this.reusedStringBuilder.toString();
    }

    static void addPlaceholdersInto(StringBuilder stringBuilder, int count) {
        if (count == 0) {
            throw new IllegalArgumentException("cannot create placeholders for 0 items");
        }
        stringBuilder.append("?");
        for (int i = 1; i < count; ++i) {
            stringBuilder.append(",?");
        }
    }

    public void truncate() {
        this.db.execSQL("DELETE FROM job_holder");
        this.db.execSQL("DELETE FROM job_holder_tags");
        this.vacuum();
    }

    public void vacuum() {
        this.db.execSQL("VACUUM");
    }

    public void resetDelayTimesTo(long newDelayTime) {
        this.db.execSQL("UPDATE job_holder SET " + DbOpenHelper.DELAY_UNTIL_NS_COLUMN.columnName + "=?", new Object[]{newDelayTime});
    }

    public static class Order {
        final Property property;
        final Type type;

        public Order(Property property, Type type) {
            this.property = property;
            this.type = type;
        }

        public static enum Type {
            ASC,
            DESC;

        }
    }

    public static class ForeignKey {
        final String targetTable;
        final String targetFieldName;

        public ForeignKey(String targetTable, String targetFieldName) {
            this.targetTable = targetTable;
            this.targetFieldName = targetFieldName;
        }
    }

    public static class Property {
        final String columnName;
        final String type;
        public final int columnIndex;
        public final ForeignKey foreignKey;
        public final boolean unique;

        public Property(String columnName, String type, int columnIndex) {
            this(columnName, type, columnIndex, null, false);
        }

        public Property(String columnName, String type, int columnIndex, ForeignKey foreignKey) {
            this(columnName, type, columnIndex, foreignKey, false);
        }

        public Property(String columnName, String type, int columnIndex, ForeignKey foreignKey, boolean unique) {
            this.columnName = columnName;
            this.type = type;
            this.columnIndex = columnIndex;
            this.foreignKey = foreignKey;
            this.unique = unique;
        }
    }
}

