/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.messaging;

import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessagePredicate;
import java.util.concurrent.atomic.AtomicInteger;

class UnsafeMessageQueue {
    private Message queue = null;
    private Message tail = null;
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    public final String logTag;
    private final MessageFactory factory;

    public UnsafeMessageQueue(MessageFactory factory, String logTag) {
        this.factory = factory;
        this.logTag = logTag + "_" + idCounter.incrementAndGet();
    }

    Message next() {
        Message result = this.queue;
        JqLog.d("[%s] remove message %s", this.logTag, result);
        if (result != null) {
            this.queue = result.next;
            if (this.tail == result) {
                this.tail = null;
            }
        }
        return result;
    }

    protected void post(Message message) {
        JqLog.d("[%s] post message %s", this.logTag, message);
        if (this.tail == null) {
            this.queue = message;
            this.tail = message;
        } else {
            this.tail.next = message;
            this.tail = message;
        }
    }

    protected void postAtFront(Message message) {
        message.next = this.queue;
        if (this.tail == null) {
            this.tail = message;
        }
        this.queue = message;
    }

    protected void removeMessages(MessagePredicate predicate) {
        Message prev = null;
        Message curr = this.queue;
        while (curr != null) {
            boolean remove = predicate.onMessage(curr);
            if (remove) {
                Message next = curr.next;
                this.remove(prev, curr);
                curr = next;
                continue;
            }
            prev = curr;
            curr = curr.next;
        }
    }

    private void remove(Message prev, Message curr) {
        if (this.tail == curr) {
            this.tail = prev;
        }
        if (prev == null) {
            this.queue = curr.next;
        } else {
            prev.next = curr.next;
        }
        this.factory.release(curr);
    }

    public void clear() {
        while (this.queue != null) {
            Message curr = this.queue;
            this.queue = curr.next;
            this.factory.release(curr);
        }
        this.tail = null;
    }
}

