/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import android.content.Context;
import android.support.annotation.Nullable;
import com.birbit.android.jobqueue.BatchingScheduler;
import com.birbit.android.jobqueue.CallbackManager;
import com.birbit.android.jobqueue.CancelHandler;
import com.birbit.android.jobqueue.Constraint;
import com.birbit.android.jobqueue.ConsumerManager;
import com.birbit.android.jobqueue.Job;
import com.birbit.android.jobqueue.JobHolder;
import com.birbit.android.jobqueue.JobManager;
import com.birbit.android.jobqueue.JobQueue;
import com.birbit.android.jobqueue.JobStatus;
import com.birbit.android.jobqueue.RetryConstraint;
import com.birbit.android.jobqueue.TagConstraint;
import com.birbit.android.jobqueue.callback.JobManagerCallback;
import com.birbit.android.jobqueue.config.Configuration;
import com.birbit.android.jobqueue.di.DependencyInjector;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessageQueueConsumer;
import com.birbit.android.jobqueue.messaging.PriorityMessageQueue;
import com.birbit.android.jobqueue.messaging.message.AddJobMessage;
import com.birbit.android.jobqueue.messaging.message.CancelMessage;
import com.birbit.android.jobqueue.messaging.message.CommandMessage;
import com.birbit.android.jobqueue.messaging.message.ConstraintChangeMessage;
import com.birbit.android.jobqueue.messaging.message.JobConsumerIdleMessage;
import com.birbit.android.jobqueue.messaging.message.PublicQueryMessage;
import com.birbit.android.jobqueue.messaging.message.RunJobResultMessage;
import com.birbit.android.jobqueue.messaging.message.SchedulerMessage;
import com.birbit.android.jobqueue.network.NetworkEventProvider;
import com.birbit.android.jobqueue.network.NetworkUtil;
import com.birbit.android.jobqueue.scheduling.Scheduler;
import com.birbit.android.jobqueue.scheduling.SchedulerConstraint;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

class JobManagerThread
implements Runnable,
NetworkEventProvider.Listener {
    public static final long NS_PER_MS = 1000000L;
    public static final long NOT_RUNNING_SESSION_ID = Long.MIN_VALUE;
    public static final long NOT_DELAYED_JOB_DELAY = Long.MIN_VALUE;
    final Timer timer;
    private final Context appContext;
    private final long sessionId;
    final JobQueue persistentJobQueue;
    final JobQueue nonPersistentJobQueue;
    private final NetworkUtil networkUtil;
    private final DependencyInjector dependencyInjector;
    private final MessageFactory messageFactory;
    final ConsumerManager consumerManager;
    @Nullable
    private List<CancelHandler> pendingCancelHandlers;
    @Nullable
    private List<SchedulerConstraint> pendingSchedulerCallbacks;
    final Constraint queryConstraint = new Constraint();
    final CallbackManager callbackManager;
    private boolean running = true;
    private boolean shouldCancelAllScheduledWhenEmpty = false;
    private boolean canScheduleConstraintChangeOnIdle = true;
    final PriorityMessageQueue messageQueue;
    @Nullable
    Scheduler scheduler;

    JobManagerThread(Configuration config, PriorityMessageQueue messageQueue, MessageFactory messageFactory) {
        this.messageQueue = messageQueue;
        if (config.getCustomLogger() != null) {
            JqLog.setCustomLogger(config.getCustomLogger());
        }
        this.messageFactory = messageFactory;
        this.timer = config.getTimer();
        this.appContext = config.getAppContext();
        this.sessionId = this.timer.nanoTime();
        this.scheduler = config.getScheduler();
        if (this.scheduler != null && config.batchSchedulerRequests() && !(this.scheduler instanceof BatchingScheduler)) {
            this.scheduler = new BatchingScheduler(this.scheduler, this.timer);
        }
        this.persistentJobQueue = config.getQueueFactory().createPersistentQueue(config, this.sessionId);
        this.nonPersistentJobQueue = config.getQueueFactory().createNonPersistent(config, this.sessionId);
        this.networkUtil = config.getNetworkUtil();
        this.dependencyInjector = config.getDependencyInjector();
        if (this.networkUtil instanceof NetworkEventProvider) {
            ((NetworkEventProvider)((Object)this.networkUtil)).setListener(this);
        }
        this.consumerManager = new ConsumerManager(this, this.timer, messageFactory, config);
        this.callbackManager = new CallbackManager(messageFactory, this.timer);
    }

    void addCallback(JobManagerCallback callback) {
        this.callbackManager.addCallback(callback);
    }

    boolean removeCallback(JobManagerCallback callback) {
        return this.callbackManager.removeCallback(callback);
    }

    boolean canListenToNetwork() {
        return this.networkUtil instanceof NetworkEventProvider;
    }

    private void handleAddJob(AddJobMessage message) {
        boolean insert;
        Job job = message.getJob();
        long now = this.timer.nanoTime();
        long delayUntilNs = job.getDelayInMs() > 0L ? now + job.getDelayInMs() * 1000000L : Long.MIN_VALUE;
        long deadline = job.getDeadlineInMs() > 0L ? now + job.getDeadlineInMs() * 1000000L : Long.MAX_VALUE;
        JobHolder jobHolder = new JobHolder.Builder().priority(job.getPriority()).job(job).groupId(job.getRunGroupId()).createdNs(now).delayUntilNs(delayUntilNs).id(job.getId()).tags(job.getTags()).persistent(job.isPersistent()).runCount(0).deadline(deadline, job.shouldCancelOnDeadline()).requiredNetworkType(job.requiredNetworkType).runningSessionId(Long.MIN_VALUE).build();
        JobHolder oldJob = this.findJobBySingleId(job.getSingleInstanceId());
        boolean bl = insert = oldJob == null || this.consumerManager.isJobRunning(oldJob.getId());
        if (insert) {
            JobQueue queue;
            JobQueue jobQueue = queue = job.isPersistent() ? this.persistentJobQueue : this.nonPersistentJobQueue;
            if (oldJob != null) {
                this.consumerManager.markJobsCancelledSingleId(TagConstraint.ANY, new String[]{job.getSingleInstanceId()});
                queue.substitute(jobHolder, oldJob);
            } else {
                queue.insert(jobHolder);
            }
            if (JqLog.isDebugEnabled()) {
                JqLog.d("added job class: %s priority: %d delay: %d group : %s persistent: %s", job.getClass().getSimpleName(), job.getPriority(), job.getDelayInMs(), job.getRunGroupId(), job.isPersistent());
            }
        } else {
            JqLog.d("another job with same singleId: %s was already queued", job.getSingleInstanceId());
        }
        if (this.dependencyInjector != null) {
            this.dependencyInjector.inject(job);
        }
        jobHolder.setApplicationContext(this.appContext);
        jobHolder.getJob().onAdded();
        this.callbackManager.notifyOnAdded(jobHolder.getJob());
        if (insert) {
            this.consumerManager.onJobAdded();
            if (job.isPersistent()) {
                this.scheduleWakeUpFor(jobHolder, now);
            }
        } else {
            this.cancelSafely(jobHolder, 1);
            this.callbackManager.notifyOnDone(jobHolder.getJob());
        }
    }

    private void scheduleWakeUpFor(JobHolder holder, long now) {
        boolean hasLargeDeadline;
        if (this.scheduler == null) {
            return;
        }
        int requiredNetwork = holder.requiredNetworkType;
        long delayUntilNs = holder.getDelayUntilNs();
        long deadlineNs = holder.getDeadlineNs();
        long delay = delayUntilNs > now ? TimeUnit.NANOSECONDS.toMillis(delayUntilNs - now) : 0L;
        Long deadline = deadlineNs != Long.MAX_VALUE ? Long.valueOf(TimeUnit.NANOSECONDS.toMillis(deadlineNs - now)) : null;
        boolean hasLargeDelay = delayUntilNs > now && delay >= 30000L;
        boolean bl = hasLargeDeadline = deadline != null && deadline >= 30000L;
        if (requiredNetwork == 0 && !hasLargeDelay && !hasLargeDeadline) {
            return;
        }
        SchedulerConstraint constraint = new SchedulerConstraint(UUID.randomUUID().toString());
        constraint.setNetworkStatus(requiredNetwork);
        constraint.setDelayInMs(delay);
        constraint.setOverrideDeadlineInMs(deadline);
        this.scheduler.request(constraint);
        this.shouldCancelAllScheduledWhenEmpty = true;
    }

    private JobHolder findJobBySingleId(String singleIdTag) {
        if (singleIdTag != null) {
            this.queryConstraint.clear();
            this.queryConstraint.setTags(new String[]{singleIdTag});
            this.queryConstraint.setTagConstraint(TagConstraint.ANY);
            this.queryConstraint.setMaxNetworkType(2);
            Set<JobHolder> jobs = this.nonPersistentJobQueue.findJobs(this.queryConstraint);
            jobs.addAll(this.persistentJobQueue.findJobs(this.queryConstraint));
            if (!jobs.isEmpty()) {
                for (JobHolder job : jobs) {
                    if (this.consumerManager.isJobRunning(job.getId())) continue;
                    return job;
                }
                return jobs.iterator().next();
            }
        }
        return null;
    }

    @Override
    public void run() {
        this.messageQueue.consume(new MessageQueueConsumer(){

            @Override
            public void handleMessage(Message message) {
                JobManagerThread.this.canScheduleConstraintChangeOnIdle = true;
                switch (message.type) {
                    case ADD_JOB: {
                        JobManagerThread.this.handleAddJob((AddJobMessage)message);
                        break;
                    }
                    case JOB_CONSUMER_IDLE: {
                        boolean busy = JobManagerThread.this.consumerManager.handleIdle((JobConsumerIdleMessage)message);
                        if (busy) break;
                        JobManagerThread.this.invokeSchedulersIfIdle();
                        break;
                    }
                    case RUN_JOB_RESULT: {
                        JobManagerThread.this.handleRunJobResult((RunJobResultMessage)message);
                        break;
                    }
                    case CONSTRAINT_CHANGE: {
                        boolean handled = JobManagerThread.this.consumerManager.handleConstraintChange();
                        ConstraintChangeMessage constraintChangeMessage = (ConstraintChangeMessage)message;
                        JobManagerThread.this.canScheduleConstraintChangeOnIdle = handled || !constraintChangeMessage.isForNextJob();
                        break;
                    }
                    case CANCEL: {
                        JobManagerThread.this.handleCancel((CancelMessage)message);
                        break;
                    }
                    case PUBLIC_QUERY: {
                        JobManagerThread.this.handlePublicQuery((PublicQueryMessage)message);
                        break;
                    }
                    case COMMAND: {
                        JobManagerThread.this.handleCommand((CommandMessage)message);
                        break;
                    }
                    case SCHEDULER: {
                        JobManagerThread.this.handleSchedulerMessage((SchedulerMessage)message);
                    }
                }
            }

            @Override
            public void onIdle() {
                JqLog.v("joq idle. running:? %s", JobManagerThread.this.running);
                if (!JobManagerThread.this.running) {
                    return;
                }
                if (!JobManagerThread.this.canScheduleConstraintChangeOnIdle) {
                    JqLog.v("skipping scheduling a new idle callback because looks like last one did not do anything", new Object[0]);
                    return;
                }
                Long nextJobTimeNs = JobManagerThread.this.getNextWakeUpNs(true);
                JqLog.d("Job queue idle. next job at: %s", nextJobTimeNs);
                if (nextJobTimeNs != null) {
                    ConstraintChangeMessage constraintMessage = JobManagerThread.this.messageFactory.obtain(ConstraintChangeMessage.class);
                    constraintMessage.setForNextJob(true);
                    JobManagerThread.this.messageQueue.postAt(constraintMessage, nextJobTimeNs);
                } else if (JobManagerThread.this.scheduler != null && JobManagerThread.this.shouldCancelAllScheduledWhenEmpty && JobManagerThread.this.persistentJobQueue.count() == 0) {
                    JobManagerThread.this.shouldCancelAllScheduledWhenEmpty = false;
                    JobManagerThread.this.scheduler.cancelAll();
                }
            }
        });
    }

    private void invokeSchedulersIfIdle() {
        if (this.scheduler == null || this.pendingSchedulerCallbacks == null || this.pendingSchedulerCallbacks.isEmpty() || !this.consumerManager.areAllConsumersIdle()) {
            return;
        }
        for (int i = this.pendingSchedulerCallbacks.size() - 1; i >= 0; --i) {
            SchedulerConstraint constraint = this.pendingSchedulerCallbacks.remove(i);
            boolean reschedule = this.hasJobsWithSchedulerConstraint(constraint);
            this.scheduler.onFinished(constraint, reschedule);
        }
    }

    private void handleSchedulerMessage(SchedulerMessage message) {
        int what = message.getWhat();
        if (what == 1) {
            this.handleSchedulerStart(message.getConstraint());
        } else if (what == 2) {
            this.handleSchedulerStop(message.getConstraint());
        } else {
            throw new IllegalArgumentException("Unknown scheduler message with what " + what);
        }
    }

    private boolean hasJobsWithSchedulerConstraint(SchedulerConstraint constraint) {
        if (this.consumerManager.hasJobsWithSchedulerConstraint(constraint)) {
            return true;
        }
        this.queryConstraint.clear();
        this.queryConstraint.setNowInNs(this.timer.nanoTime());
        this.queryConstraint.setMaxNetworkType(constraint.getNetworkStatus());
        return this.persistentJobQueue.countReadyJobs(this.queryConstraint) > 0;
    }

    private void handleSchedulerStop(SchedulerConstraint constraint) {
        List<SchedulerConstraint> pendingCallbacks = this.pendingSchedulerCallbacks;
        if (pendingCallbacks != null) {
            for (int i = pendingCallbacks.size() - 1; i >= 0; --i) {
                SchedulerConstraint pendingConstraint = pendingCallbacks.get(i);
                if (!pendingConstraint.getUuid().equals(constraint.getUuid())) continue;
                pendingCallbacks.remove(i);
            }
        }
        if (this.scheduler == null) {
            return;
        }
        boolean hasMatchingJobs = this.hasJobsWithSchedulerConstraint(constraint);
        if (hasMatchingJobs) {
            this.scheduler.request(constraint);
        }
    }

    private void handleSchedulerStart(SchedulerConstraint constraint) {
        if (!this.isRunning()) {
            if (this.scheduler != null) {
                this.scheduler.onFinished(constraint, true);
            }
            return;
        }
        boolean hasMatchingJobs = this.hasJobsWithSchedulerConstraint(constraint);
        if (!hasMatchingJobs) {
            if (this.scheduler != null) {
                this.scheduler.onFinished(constraint, false);
            }
            return;
        }
        if (this.pendingSchedulerCallbacks == null) {
            this.pendingSchedulerCallbacks = new ArrayList<SchedulerConstraint>();
        }
        this.pendingSchedulerCallbacks.add(constraint);
        this.consumerManager.handleConstraintChange();
    }

    private void handleCommand(CommandMessage message) {
        if (message.getWhat() == 1) {
            this.messageQueue.stop();
            this.messageQueue.clear();
        }
    }

    int count() {
        return this.persistentJobQueue.count() + this.nonPersistentJobQueue.count();
    }

    private void handlePublicQuery(PublicQueryMessage message) {
        switch (message.getWhat()) {
            case 0: {
                message.getCallback().onResult(this.count());
                break;
            }
            case 1: {
                message.getCallback().onResult(this.countReadyJobs(this.getNetworkStatus()));
                break;
            }
            case 2: {
                JqLog.d("handling start request...", new Object[0]);
                if (this.running) {
                    return;
                }
                this.running = true;
                this.consumerManager.handleConstraintChange();
                break;
            }
            case 3: {
                JqLog.d("handling stop request...", new Object[0]);
                this.running = false;
                this.consumerManager.handleStop();
                break;
            }
            case 4: {
                JobStatus status = this.getJobStatus(message.getStringArg());
                message.getCallback().onResult(status.ordinal());
                break;
            }
            case 5: {
                this.clear();
                if (message.getCallback() == null) break;
                message.getCallback().onResult(0);
                break;
            }
            case 6: {
                message.getCallback().onResult(this.consumerManager.getWorkerCount());
                break;
            }
            case 101: {
                message.getCallback().onResult(0);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot handle public query with type " + message.getWhat());
            }
        }
    }

    private void clear() {
        this.nonPersistentJobQueue.clear();
        this.persistentJobQueue.clear();
    }

    private JobStatus getJobStatus(String id) {
        if (this.consumerManager.isJobRunning(id)) {
            return JobStatus.RUNNING;
        }
        JobHolder holder = this.nonPersistentJobQueue.findJobById(id);
        if (holder == null) {
            holder = this.persistentJobQueue.findJobById(id);
        }
        if (holder == null) {
            return JobStatus.UNKNOWN;
        }
        int networkStatus = this.getNetworkStatus();
        long now = this.timer.nanoTime();
        if (networkStatus < holder.requiredNetworkType) {
            return JobStatus.WAITING_NOT_READY;
        }
        if (holder.getDelayUntilNs() > now) {
            return JobStatus.WAITING_NOT_READY;
        }
        return JobStatus.WAITING_READY;
    }

    private void handleCancel(CancelMessage message) {
        CancelHandler handler = new CancelHandler(message.getConstraint(), message.getTags(), message.getCallback());
        handler.query(this, this.consumerManager);
        if (handler.isDone()) {
            handler.commit(this);
        } else {
            if (this.pendingCancelHandlers == null) {
                this.pendingCancelHandlers = new ArrayList<CancelHandler>();
            }
            this.pendingCancelHandlers.add(handler);
        }
    }

    private void handleRunJobResult(RunJobResultMessage message) {
        int result = message.getResult();
        JobHolder jobHolder = message.getJobHolder();
        this.callbackManager.notifyOnRun(jobHolder.getJob(), result);
        RetryConstraint retryConstraint = null;
        switch (result) {
            case 1: {
                this.removeJob(jobHolder);
                break;
            }
            case 2: {
                this.cancelSafely(jobHolder, 2);
                this.removeJob(jobHolder);
                break;
            }
            case 5: {
                this.cancelSafely(jobHolder, 5);
                this.removeJob(jobHolder);
                break;
            }
            case 6: {
                this.cancelSafely(jobHolder, 6);
                this.removeJob(jobHolder);
                break;
            }
            case 7: {
                this.cancelSafely(jobHolder, 7);
                this.removeJob(jobHolder);
                break;
            }
            case 4: {
                retryConstraint = jobHolder.getRetryConstraint();
                this.insertOrReplace(jobHolder);
                break;
            }
            case 3: {
                JqLog.d("running job failed and cancelled, doing nothing. Will be removed after it's onCancel is called by the CancelHandler", new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown job holder result");
            }
        }
        this.consumerManager.handleRunJobResult(message, jobHolder, retryConstraint);
        this.callbackManager.notifyAfterRun(jobHolder.getJob(), result);
        if (this.pendingCancelHandlers != null) {
            int limit = this.pendingCancelHandlers.size();
            for (int i = 0; i < limit; ++i) {
                CancelHandler handler = this.pendingCancelHandlers.get(i);
                handler.onJobRun(jobHolder, result);
                if (!handler.isDone()) continue;
                handler.commit(this);
                this.pendingCancelHandlers.remove(i);
                --i;
                --limit;
            }
        }
    }

    private void cancelSafely(JobHolder jobHolder, int cancelReason) {
        try {
            jobHolder.onCancel(cancelReason);
        }
        catch (Throwable t) {
            JqLog.e(t, "job's onCancel did throw an exception, ignoring...", new Object[0]);
        }
        this.callbackManager.notifyOnCancel(jobHolder.getJob(), false, jobHolder.getThrowable());
    }

    private void insertOrReplace(JobHolder jobHolder) {
        RetryConstraint retryConstraint = jobHolder.getRetryConstraint();
        if (retryConstraint == null) {
            this.reAddJob(jobHolder);
            return;
        }
        if (retryConstraint.getNewPriority() != null) {
            jobHolder.setPriority(retryConstraint.getNewPriority());
        }
        long delay = -1L;
        if (retryConstraint.getNewDelayInMs() != null) {
            delay = retryConstraint.getNewDelayInMs();
        }
        jobHolder.setDelayUntilNs(delay > 0L ? this.timer.nanoTime() + delay * 1000000L : Long.MIN_VALUE);
        this.reAddJob(jobHolder);
    }

    private void reAddJob(JobHolder jobHolder) {
        if (!jobHolder.isCancelled()) {
            if (jobHolder.getJob().isPersistent()) {
                this.persistentJobQueue.insertOrReplace(jobHolder);
            } else {
                this.nonPersistentJobQueue.insertOrReplace(jobHolder);
            }
        } else {
            JqLog.d("not re-adding cancelled job " + jobHolder, new Object[0]);
        }
    }

    private void removeJob(JobHolder jobHolder) {
        if (jobHolder.getJob().isPersistent()) {
            this.persistentJobQueue.remove(jobHolder);
        } else {
            this.nonPersistentJobQueue.remove(jobHolder);
        }
        this.callbackManager.notifyOnDone(jobHolder.getJob());
    }

    @Override
    public void onNetworkChange(int networkStatus) {
        ConstraintChangeMessage constraint = this.messageFactory.obtain(ConstraintChangeMessage.class);
        this.messageQueue.post(constraint);
    }

    boolean isRunning() {
        return this.running;
    }

    int countRemainingReadyJobs() {
        return this.countReadyJobs(this.getNetworkStatus());
    }

    private int countReadyJobs(int networkStatus) {
        Collection<String> runningJobs = this.consumerManager.runningJobGroups.getSafe();
        this.queryConstraint.clear();
        this.queryConstraint.setNowInNs(this.timer.nanoTime());
        this.queryConstraint.setMaxNetworkType(networkStatus);
        this.queryConstraint.setExcludeGroups(runningJobs);
        this.queryConstraint.setExcludeRunning(true);
        this.queryConstraint.setTimeLimit(this.timer.nanoTime());
        int total = 0;
        total += this.nonPersistentJobQueue.countReadyJobs(this.queryConstraint);
        return total += this.persistentJobQueue.countReadyJobs(this.queryConstraint);
    }

    private int getNetworkStatus() {
        return this.networkUtil == null ? 2 : this.networkUtil.getNetworkStatus(this.appContext);
    }

    Long getNextWakeUpNs(boolean includeNetworkWatch) {
        Long groupDelay = this.consumerManager.runningJobGroups.getNextDelayForGroups();
        int networkStatus = this.getNetworkStatus();
        Collection<String> groups = this.consumerManager.runningJobGroups.getSafe();
        this.queryConstraint.clear();
        this.queryConstraint.setNowInNs(this.timer.nanoTime());
        this.queryConstraint.setMaxNetworkType(networkStatus);
        this.queryConstraint.setExcludeGroups(groups);
        this.queryConstraint.setExcludeRunning(true);
        Long nonPersistent = this.nonPersistentJobQueue.getNextJobDelayUntilNs(this.queryConstraint);
        Long persistent = this.persistentJobQueue.getNextJobDelayUntilNs(this.queryConstraint);
        Long delay = null;
        if (groupDelay != null) {
            delay = groupDelay;
        }
        if (nonPersistent != null) {
            delay = delay == null ? nonPersistent : Math.min(nonPersistent, delay);
        }
        if (persistent != null) {
            delay = delay == null ? persistent : Math.min(persistent, delay);
        }
        if (includeNetworkWatch && !(this.networkUtil instanceof NetworkEventProvider)) {
            long checkNetworkAt = this.timer.nanoTime() + JobManager.NETWORK_CHECK_INTERVAL;
            delay = delay == null ? checkNetworkAt : Math.min(checkNetworkAt, delay);
        }
        return delay;
    }

    JobHolder getNextJobForTesting() {
        return this.getNextJobForTesting(null);
    }

    JobHolder getNextJobForTesting(Collection<String> runningJobGroups) {
        return this.getNextJob(runningJobGroups, true);
    }

    JobHolder getNextJob(Collection<String> runningJobGroups) {
        return this.getNextJob(runningJobGroups, false);
    }

    JobHolder getNextJob(Collection<String> runningJobGroups, boolean ignoreRunning) {
        if (!this.running && !ignoreRunning) {
            return null;
        }
        JobHolder jobHolder = null;
        while (jobHolder == null) {
            int networkStatus = this.getNetworkStatus();
            boolean persistent = false;
            JqLog.v("looking for next job", new Object[0]);
            this.queryConstraint.clear();
            long now = this.timer.nanoTime();
            this.queryConstraint.setNowInNs(now);
            this.queryConstraint.setMaxNetworkType(networkStatus);
            this.queryConstraint.setExcludeGroups(runningJobGroups);
            this.queryConstraint.setExcludeRunning(true);
            this.queryConstraint.setTimeLimit(now);
            jobHolder = this.nonPersistentJobQueue.nextJobAndIncRunCount(this.queryConstraint);
            JqLog.v("non persistent result %s", jobHolder);
            if (jobHolder == null) {
                jobHolder = this.persistentJobQueue.nextJobAndIncRunCount(this.queryConstraint);
                persistent = true;
                JqLog.v("persistent result %s", jobHolder);
            }
            if (jobHolder == null) {
                return null;
            }
            if (persistent && this.dependencyInjector != null) {
                this.dependencyInjector.inject(jobHolder.getJob());
            }
            jobHolder.setApplicationContext(this.appContext);
            jobHolder.setDeadlineIsReached(jobHolder.getDeadlineNs() <= now);
            if (jobHolder.getDeadlineNs() > now || !jobHolder.shouldCancelOnDeadline()) continue;
            this.cancelSafely(jobHolder, 7);
            this.removeJob(jobHolder);
            jobHolder = null;
        }
        return jobHolder;
    }
}

