/*
 * Decompiled with CFR 0.152.
 */
package com.binjar.prefsdroid;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import java.util.Map;
import java.util.Set;

public class Preference {
    private static SharedPreferences mPrefs;

    public static Builder load() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Preference(Context context, String key, int mode) {
        if (mPrefs != null) return;
        Class<Preference> clazz = Preference.class;
        synchronized (Preference.class) {
            if (mPrefs != null) return;
            mPrefs = context.getSharedPreferences(key, mode);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static SharedPreferences getPreference() {
        if (mPrefs == null) {
            new Builder().prepare();
        }
        return mPrefs;
    }

    public static Map<String, ?> getAll() {
        return Preference.getPreference().getAll();
    }

    public static void putBoolean(String key, boolean value) {
        Preference.getPreference().edit().putBoolean(key, value).apply();
    }

    public static boolean getBoolean(String key) {
        return Preference.getBoolean(key, false);
    }

    public static boolean getBoolean(String key, boolean defValue) {
        return Preference.getPreference().getBoolean(key, defValue);
    }

    public static void putInt(String key, int value) {
        Preference.getPreference().edit().putInt(key, value).apply();
    }

    public static int getInt(String key) {
        return Preference.getInt(key, 0);
    }

    public static int getInt(String key, int defValue) {
        return Preference.getPreference().getInt(key, defValue);
    }

    public static void putLong(String key, long value) {
        Preference.getPreference().edit().putLong(key, value).apply();
    }

    public static long getLong(String key) {
        return Preference.getLong(key, 0L);
    }

    public static long getLong(String key, long defValue) {
        return Preference.getPreference().getLong(key, defValue);
    }

    public static void putFloat(String key, float value) {
        Preference.getPreference().edit().putFloat(key, value).apply();
    }

    public static float getFloat(String key) {
        return Preference.getFloat(key, 0.0f);
    }

    public static float getFloat(String key, float defValue) {
        return Preference.getPreference().getFloat(key, defValue);
    }

    public static void putDouble(String key, double value) {
        Preference.getPreference().edit().putLong(key, Double.doubleToRawLongBits(value)).apply();
    }

    public static double getDouble(String key) {
        return Preference.getDouble(key, 0.0);
    }

    public static double getDouble(String key, double defValue) {
        return Double.longBitsToDouble(Preference.getPreference().getLong(key, Double.doubleToRawLongBits(defValue)));
    }

    public static void putString(String key, String value) {
        Preference.getPreference().edit().putString(key, value).apply();
    }

    public static String getString(String key) {
        return Preference.getString(key, null);
    }

    public static String getString(String key, String defValue) {
        return Preference.getPreference().getString(key, defValue);
    }

    @TargetApi(value=11)
    public static void putStringSet(String key, Set<String> values) {
        Preference.getPreference().edit().putStringSet(key, values).apply();
    }

    @TargetApi(value=11)
    public static Set<String> getStringSet(String key) {
        return Preference.getStringSet(key, null);
    }

    @TargetApi(value=11)
    public static Set<String> getStringSet(String key, Set<String> values) {
        return Preference.getPreference().getStringSet(key, values);
    }

    public static <T> void putObject(String key, T t) {
        Preference.getPreference().edit().putString(key, new Gson().toJson(t)).apply();
    }

    public static <T> T getObject(String key, Class<T> classOfT) {
        return (T)new Gson().fromJson(Preference.getPreference().getString(key, null), classOfT);
    }

    public static void remove(String key) {
        Preference.getPreference().edit().remove(key).apply();
    }

    public static boolean containsKey(String key) {
        return Preference.getPreference().contains(key);
    }

    public static void clear() {
        Preference.getPreference().edit().clear().apply();
    }

    public static final class Builder {
        private String mKey;
        private Context mContext;
        private int mMode = 0;

        private Builder() {
        }

        public Builder using(Context context) {
            this.mContext = context.getApplicationContext();
            return this;
        }

        public Builder with(String KEY) {
            this.mKey = KEY;
            return this;
        }

        public Preference prepare() {
            if (this.mContext == null) {
                throw new RuntimeException("Context must not be null.");
            }
            if (TextUtils.isEmpty((CharSequence)this.mKey)) {
                this.mKey = this.mContext.getPackageName();
            }
            return new Preference(this.mContext, this.mKey, this.mMode);
        }
    }
}

