/*
 * Decompiled with CFR 0.152.
 */
package com.binaryfork.spanny;

import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;

public class Spanny
extends SpannableStringBuilder {
    private int flag = 33;

    public Spanny(String text) {
        super((CharSequence)text);
    }

    public Spanny(String text, Object span) {
        super((CharSequence)text);
        this.setSpan(span, 0, text.length());
    }

    public Spanny append(String text, Object ... spans) {
        this.append(text);
        for (Object span : spans) {
            this.setSpan(span, this.length() - text.length(), this.length());
        }
        return this;
    }

    public Spanny append(String text, ImageSpan imageSpan) {
        text = "." + text;
        this.append(text);
        this.setSpan(imageSpan, this.length() - text.length(), this.length() - text.length() + 1);
        return this;
    }

    public Spanny appendText(String text) {
        this.append(text);
        return this;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    private void setSpan(Object span, int start, int end) {
        this.setSpan(span, start, end, this.flag);
    }

    public Spanny findAndSpan(String textToSpan, GetSpan getSpan) {
        int lastIndex = 0;
        while (lastIndex != -1) {
            lastIndex = this.toString().indexOf(textToSpan, lastIndex);
            if (lastIndex == -1) continue;
            this.setSpan(getSpan.getSpan(), lastIndex, lastIndex + textToSpan.length());
            lastIndex += textToSpan.length();
        }
        return this;
    }

    public static SpannableString spanText(CharSequence text, Object ... spans) {
        SpannableString spannableString = new SpannableString(text);
        for (Object span : spans) {
            spannableString.setSpan(span, 0, text.length(), 33);
        }
        return spannableString;
    }

    public static interface GetSpan {
        public Object getSpan();
    }
}

