/*
 * Decompiled with CFR 0.152.
 */
package com.billy.android.preloader.util;

import android.util.Log;
import com.billy.android.preloader.util.ILogger;

public class PreLoaderLogger
implements ILogger {
    private boolean isShowLog;

    @Override
    public void showLog(boolean isShowLog) {
        this.isShowLog = isShowLog;
        Log.i((String)this.getDefaultTag(), (String)("showLog=" + isShowLog));
    }

    @Override
    public void debug(String message) {
        this.debug(this.getDefaultTag(), message);
    }

    @Override
    public void debug(String tag, String message) {
        if (this.isShowLog) {
            if (tag == null) {
                tag = "";
            }
            if (message == null) {
                message = "";
            }
            Log.d((String)tag, (String)message);
        }
    }

    @Override
    public void info(String message) {
        this.info(this.getDefaultTag(), message);
    }

    @Override
    public void info(String tag, String message) {
        if (this.isShowLog) {
            if (tag == null) {
                tag = "";
            }
            if (message == null) {
                message = "";
            }
            Log.i((String)tag, (String)message);
        }
    }

    @Override
    public void warning(String message) {
        this.warning(this.getDefaultTag(), message);
    }

    @Override
    public void warning(String tag, String message) {
        if (this.isShowLog) {
            if (tag == null) {
                tag = "";
            }
            if (message == null) {
                message = "";
            }
            Log.w((String)tag, (String)message);
        }
    }

    @Override
    public void error(String message) {
        this.error(this.getDefaultTag(), message);
    }

    @Override
    public void error(String tag, String message) {
        if (this.isShowLog) {
            if (tag == null) {
                tag = "";
            }
            if (message == null) {
                message = "";
            }
            Log.e((String)tag, (String)message);
        }
    }

    @Override
    public void throwable(Throwable th) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        this.error(PreLoaderLogger.getMessageByStackTrace(stackTraceElement));
    }

    @Override
    public String getDefaultTag() {
        return "PreLoader";
    }

    public static String getMessageByStackTrace(StackTraceElement stackTraceElement) {
        String separator = " & ";
        StringBuilder sb = new StringBuilder("[");
        String threadName = Thread.currentThread().getName();
        String fileName = stackTraceElement.getFileName();
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        long threadID = Thread.currentThread().getId();
        int lineNumber = stackTraceElement.getLineNumber();
        sb.append("ThreadId=").append(threadID).append(separator);
        sb.append("ThreadName=").append(threadName).append(separator);
        sb.append("FileName=").append(fileName).append(separator);
        sb.append("ClassName=").append(className).append(separator);
        sb.append("MethodName=").append(methodName).append(separator);
        sb.append("LineNumber=").append(lineNumber);
        sb.append(" ] ");
        return sb.toString();
    }
}

