/*
 * Decompiled with CFR 0.152.
 */
package com.billy.android.preloader;

import com.billy.android.preloader.PreLoaderPool;
import com.billy.android.preloader.PreLoaderWrapper;
import com.billy.android.preloader.Worker;
import com.billy.android.preloader.interfaces.DataListener;
import com.billy.android.preloader.interfaces.DataLoader;
import com.billy.android.preloader.util.ILogger;
import com.billy.android.preloader.util.PreLoaderLogger;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class PreLoader<T> {
    static ILogger logger = new PreLoaderLogger();

    public static void setLogger(ILogger logger) {
        if (logger != null) {
            PreLoader.logger = logger;
        }
    }

    public static void showLog(boolean show) {
        if (logger != null) {
            logger.showLog(show);
        }
    }

    public static <E> PreLoaderWrapper<E> just(DataLoader<E> loader) {
        return PreLoader.just(loader, (DataListener)null);
    }

    public static <E> PreLoaderWrapper<E> just(DataLoader<E> loader, DataListener<E> listener) {
        PreLoaderWrapper<E> preLoader = new PreLoaderWrapper<E>(loader, listener);
        preLoader.preLoad();
        return preLoader;
    }

    public static <E> PreLoaderWrapper<E> just(DataLoader<E> loader, List<DataListener<E>> listeners) {
        PreLoaderWrapper<E> preLoader = new PreLoaderWrapper<E>(loader, listeners);
        preLoader.preLoad();
        return preLoader;
    }

    public static void setDefaultThreadPoolExecutor(ExecutorService threadPoolExecutor) {
        Worker.setDefaultThreadPoolExecutor(threadPoolExecutor);
    }

    public static <E> int preLoad(DataLoader<E> loader, List<DataListener<E>> listeners) {
        return PreLoaderPool.getDefault().preLoad(loader, listeners);
    }

    public static <E> int preLoad(DataLoader<E> loader, DataListener<E> listener) {
        return PreLoaderPool.getDefault().preLoad(loader, listener);
    }

    public static <E> int preLoad(DataLoader<E> loader) {
        return PreLoaderPool.getDefault().preLoad(loader);
    }

    public static PreLoaderPool newPool() {
        return new PreLoaderPool();
    }

    public static boolean listenData(int id) {
        return PreLoaderPool.getDefault().listenData(id);
    }

    public static <T> boolean listenData(int id, DataListener<T> dataListener) {
        return PreLoaderPool.getDefault().listenData(id, dataListener);
    }

    public static <T> boolean removeListener(int id, DataListener<T> dataListener) {
        return PreLoaderPool.getDefault().removeListener(id, dataListener);
    }

    public static <T> boolean exists(int id) {
        return PreLoaderPool.getDefault().exists(id);
    }

    public static boolean refresh(int id) {
        return PreLoaderPool.getDefault().refresh(id);
    }

    public static boolean destroy(int id) {
        return PreLoaderPool.getDefault().destroy(id);
    }

    public static boolean destroyAll() {
        return PreLoaderPool.getDefault().destroyAll();
    }
}

