/*
 * Decompiled with CFR 0.152.
 */
package com.bikomobile.donutprogress;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.bikomobile.donutprogress.R;
import java.util.Timer;
import java.util.TimerTask;

public class DonutProgress
extends View {
    private Paint finishedPaint;
    private Paint unfinishedPaint;
    private Paint innerCirclePaint;
    protected Paint textPaint;
    protected Paint innerBottomTextPaint;
    protected Timer timer;
    private RectF finishedOuterRect = new RectF();
    private RectF unfinishedOuterRect = new RectF();
    private String text;
    private float textSize;
    private int textColor;
    private int innerBottomTextColor;
    private int progress = 0;
    private float startAngle = 0.0f;
    private int max;
    private int finishedStrokeColor;
    private int unfinishedStrokeColor;
    private float finishedStrokeWidth;
    private float unfinishedStrokeWidth;
    private int innerBackgroundColor;
    private float innerBottomTextSize;
    private String innerBottomText;
    private float innerBottomTextHeight;
    private final float default_stroke_width;
    private final int default_finished_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_unfinished_color = Color.rgb((int)204, (int)204, (int)204);
    private final int default_text_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_inner_bottom_text_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_inner_background_color = 0;
    private final int default_max = 100;
    private final float default_text_size = DonutProgress.sp2px(this.getResources(), 18.0f);
    private final float default_inner_bottom_text_size;
    private final int min_size = (int)DonutProgress.dp2px(this.getResources(), 100.0f);
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_TEXT = "text";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_INNER_BOTTOM_TEXT_SIZE = "inner_bottom_text_size";
    private static final String INSTANCE_INNER_BOTTOM_TEXT = "inner_bottom_text";
    private static final String INSTANCE_INNER_BOTTOM_TEXT_COLOR = "inner_bottom_text_color";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_START_ANGLE = "start_angle";
    private static final String INSTANCE_FINISHED_STROKE_WIDTH = "finished_stroke_width";
    private static final String INSTANCE_UNFINISHED_STROKE_WIDTH = "unfinished_stroke_width";
    private static final String INSTANCE_BACKGROUND_COLOR = "inner_background_color";

    public DonutProgress(Context context) {
        this(context, null);
    }

    public DonutProgress(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DonutProgress(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.default_stroke_width = DonutProgress.dp2px(this.getResources(), 10.0f);
        this.default_inner_bottom_text_size = DonutProgress.sp2px(this.getResources(), 18.0f);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DonutProgress, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    protected void initPainters() {
        this.textPaint = new TextPaint();
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setAntiAlias(true);
        this.innerBottomTextPaint = new TextPaint();
        this.innerBottomTextPaint.setColor(this.innerBottomTextColor);
        this.innerBottomTextPaint.setTextSize(this.innerBottomTextSize);
        this.innerBottomTextPaint.setAntiAlias(true);
        this.finishedPaint = new Paint();
        this.finishedPaint.setColor(this.finishedStrokeColor);
        this.finishedPaint.setStyle(Paint.Style.STROKE);
        this.finishedPaint.setAntiAlias(true);
        this.finishedPaint.setStrokeWidth(this.finishedStrokeWidth);
        this.unfinishedPaint = new Paint();
        this.unfinishedPaint.setColor(this.unfinishedStrokeColor);
        this.unfinishedPaint.setStyle(Paint.Style.STROKE);
        this.unfinishedPaint.setAntiAlias(true);
        this.unfinishedPaint.setStrokeWidth(this.unfinishedStrokeWidth);
        this.innerCirclePaint = new Paint();
        this.innerCirclePaint.setColor(this.innerBackgroundColor);
        this.innerCirclePaint.setAntiAlias(true);
    }

    protected void initByAttributes(TypedArray attributes) {
        this.finishedStrokeColor = attributes.getColor(R.styleable.DonutProgress_donut_finished_color, this.default_finished_color);
        this.unfinishedStrokeColor = attributes.getColor(R.styleable.DonutProgress_donut_unfinished_color, this.default_unfinished_color);
        if (attributes.getString(R.styleable.DonutProgress_donut_text) != null) {
            this.text = attributes.getString(R.styleable.DonutProgress_donut_text);
        }
        this.textColor = attributes.getColor(R.styleable.DonutProgress_donut_text_color, this.default_text_color);
        this.textSize = attributes.getDimension(R.styleable.DonutProgress_donut_text_size, this.default_text_size);
        this.setMax(attributes.getInt(R.styleable.DonutProgress_donut_max, 100));
        this.setProgress(attributes.getInt(R.styleable.DonutProgress_donut_progress, 0));
        this.startAngle = attributes.getFloat(R.styleable.DonutProgress_donut_start_angle, 0.0f);
        this.finishedStrokeWidth = attributes.getDimension(R.styleable.DonutProgress_donut_finished_stroke_width, this.default_stroke_width);
        this.unfinishedStrokeWidth = attributes.getDimension(R.styleable.DonutProgress_donut_unfinished_stroke_width, this.default_stroke_width);
        this.innerBackgroundColor = attributes.getColor(R.styleable.DonutProgress_donut_background_color, 0);
        this.innerBottomTextSize = attributes.getDimension(R.styleable.DonutProgress_donut_inner_bottom_text_size, this.default_inner_bottom_text_size);
        this.innerBottomTextColor = attributes.getColor(R.styleable.DonutProgress_donut_inner_bottom_text_color, this.default_inner_bottom_text_color);
        this.innerBottomText = attributes.getString(R.styleable.DonutProgress_donut_inner_bottom_text);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public float getFinishedStrokeWidth() {
        return this.finishedStrokeWidth;
    }

    public void setFinishedStrokeWidth(float finishedStrokeWidth) {
        this.finishedStrokeWidth = finishedStrokeWidth;
        this.invalidate();
    }

    public float getUnfinishedStrokeWidth() {
        return this.unfinishedStrokeWidth;
    }

    public void setUnfinishedStrokeWidth(float unfinishedStrokeWidth) {
        this.unfinishedStrokeWidth = unfinishedStrokeWidth;
        this.invalidate();
    }

    private float getProgressAngle() {
        return (float)this.getProgress() / (float)this.max * 360.0f;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setStartAngle(float startAngle) {
        this.startAngle = startAngle;
        this.invalidate();
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public String getText() {
        return this.text;
    }

    public void setProgress(int progress) {
        this.setProgress(progress, 0);
    }

    public void setProgress(int progress, int period) {
        this.progress = progress;
        if (this.progress > this.getMax()) {
            this.progress %= this.getMax();
        }
        if (period > 0) {
            this.startAnimation(period);
        } else {
            this.invalidate();
        }
    }

    private void startAnimation(int period) {
        final int finalProgress = this.getProgress();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){
            private Handler handler = new Handler(Looper.getMainLooper());
            int initProgress = 0;

            @Override
            public void run() {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (initProgress < finalProgress) {
                            ++initProgress;
                            DonutProgress.this.setProgress(initProgress);
                            DonutProgress.this.setText(initProgress + "%");
                        } else {
                            DonutProgress.this.timer.cancel();
                        }
                    }
                });
            }
        }, 0L, (long)period);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public int getFinishedStrokeColor() {
        return this.finishedStrokeColor;
    }

    public void setFinishedStrokeColor(int finishedStrokeColor) {
        this.finishedStrokeColor = finishedStrokeColor;
        this.invalidate();
    }

    public int getUnfinishedStrokeColor() {
        return this.unfinishedStrokeColor;
    }

    public void setUnfinishedStrokeColor(int unfinishedStrokeColor) {
        this.unfinishedStrokeColor = unfinishedStrokeColor;
        this.invalidate();
    }

    public int getInnerBackgroundColor() {
        return this.innerBackgroundColor;
    }

    public void setInnerBackgroundColor(int innerBackgroundColor) {
        this.innerBackgroundColor = innerBackgroundColor;
        this.invalidate();
    }

    public String getInnerBottomText() {
        return this.innerBottomText;
    }

    public void setInnerBottomText(String innerBottomText) {
        this.innerBottomText = innerBottomText;
        this.invalidate();
    }

    public float getInnerBottomTextSize() {
        return this.innerBottomTextSize;
    }

    public void setInnerBottomTextSize(float innerBottomTextSize) {
        this.innerBottomTextSize = innerBottomTextSize;
        this.invalidate();
    }

    public int getInnerBottomTextColor() {
        return this.innerBottomTextColor;
    }

    public void setInnerBottomTextColor(int innerBottomTextColor) {
        this.innerBottomTextColor = innerBottomTextColor;
        this.invalidate();
    }

    public static float dp2px(Resources resources, float dp) {
        float scale = resources.getDisplayMetrics().density;
        return dp * scale + 0.5f;
    }

    public static float sp2px(Resources resources, float sp) {
        float scale = resources.getDisplayMetrics().scaledDensity;
        return sp * scale;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measure(widthMeasureSpec), this.measure(heightMeasureSpec));
        this.innerBottomTextHeight = this.getHeight() - this.getHeight() * 3 / 5;
    }

    private int measure(int measureSpec) {
        int result;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            result = size;
        } else {
            result = this.min_size;
            if (mode == Integer.MIN_VALUE) {
                result = Math.min(result, size);
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float delta = Math.max(this.finishedStrokeWidth, this.unfinishedStrokeWidth);
        this.finishedOuterRect.set(delta, delta, (float)this.getWidth() - delta, (float)this.getHeight() - delta);
        this.unfinishedOuterRect.set(delta, delta, (float)this.getWidth() - delta, (float)this.getHeight() - delta);
        float innerCircleRadius = ((float)this.getWidth() - Math.min(this.finishedStrokeWidth, this.unfinishedStrokeWidth) + Math.abs(this.finishedStrokeWidth - this.unfinishedStrokeWidth)) / 2.0f;
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, innerCircleRadius, this.innerCirclePaint);
        canvas.drawArc(this.finishedOuterRect, this.startAngle - 90.0f, this.getProgressAngle(), false, this.finishedPaint);
        canvas.drawArc(this.unfinishedOuterRect, this.getProgressAngle() + this.startAngle - 90.0f, 360.0f - this.getProgressAngle(), false, this.unfinishedPaint);
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            float textHeight = this.textPaint.descent() + this.textPaint.ascent();
            canvas.drawText(this.text, ((float)this.getWidth() - this.textPaint.measureText(this.text)) / 2.0f, ((float)this.getWidth() - textHeight) / 2.0f, this.textPaint);
        }
        if (!TextUtils.isEmpty((CharSequence)this.getInnerBottomText())) {
            this.innerBottomTextPaint.setTextSize(this.innerBottomTextSize);
            float bottomTextBaseline = (float)this.getHeight() - this.innerBottomTextHeight - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f;
            canvas.drawText(this.getInnerBottomText(), ((float)this.getWidth() - this.innerBottomTextPaint.measureText(this.getInnerBottomText())) / 2.0f, bottomTextBaseline, this.innerBottomTextPaint);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putString(INSTANCE_TEXT, this.getText());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putFloat(INSTANCE_INNER_BOTTOM_TEXT_SIZE, this.getInnerBottomTextSize());
        bundle.putFloat(INSTANCE_INNER_BOTTOM_TEXT_COLOR, (float)this.getInnerBottomTextColor());
        bundle.putString(INSTANCE_INNER_BOTTOM_TEXT, this.getInnerBottomText());
        bundle.putInt(INSTANCE_INNER_BOTTOM_TEXT_COLOR, this.getInnerBottomTextColor());
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedStrokeColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedStrokeColor());
        bundle.putInt(INSTANCE_MAX, this.getMax());
        bundle.putInt(INSTANCE_PROGRESS, this.getProgress());
        bundle.putFloat(INSTANCE_START_ANGLE, this.getStartAngle());
        bundle.putFloat(INSTANCE_FINISHED_STROKE_WIDTH, this.getFinishedStrokeWidth());
        bundle.putFloat(INSTANCE_UNFINISHED_STROKE_WIDTH, this.getUnfinishedStrokeWidth());
        bundle.putInt(INSTANCE_BACKGROUND_COLOR, this.getInnerBackgroundColor());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.text = bundle.getString(INSTANCE_TEXT);
            this.textColor = bundle.getInt(INSTANCE_TEXT_COLOR);
            this.textSize = bundle.getFloat(INSTANCE_TEXT_SIZE);
            this.innerBottomTextSize = bundle.getFloat(INSTANCE_INNER_BOTTOM_TEXT_SIZE);
            this.innerBottomText = bundle.getString(INSTANCE_INNER_BOTTOM_TEXT);
            this.innerBottomTextColor = bundle.getInt(INSTANCE_INNER_BOTTOM_TEXT_COLOR);
            this.finishedStrokeColor = bundle.getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedStrokeColor = bundle.getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.finishedStrokeWidth = bundle.getFloat(INSTANCE_FINISHED_STROKE_WIDTH);
            this.unfinishedStrokeWidth = bundle.getFloat(INSTANCE_UNFINISHED_STROKE_WIDTH);
            this.innerBackgroundColor = bundle.getInt(INSTANCE_BACKGROUND_COLOR);
            this.initPainters();
            this.setMax(bundle.getInt(INSTANCE_MAX));
            this.setProgress(bundle.getInt(INSTANCE_PROGRESS));
            this.setStartAngle(bundle.getFloat(INSTANCE_START_ANGLE));
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }
}

