/*
 * Decompiled with CFR 0.152.
 */
package com.bikomobile.circleindicatorpager;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.bikomobile.circleindicatorpager.R;

public class CircleIndicatorPager
extends LinearLayout {
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    private ViewPager mViewpager;
    private int mIndicatorMargin = -1;
    private int mIndicatorWidth = -1;
    private int mIndicatorHeight = -1;
    private int mIndicatorBackgroundResId = R.drawable.white_radius;
    private int mIndicatorUnselectedBackgroundResId = R.drawable.white_radius;
    private int mLastPosition = -1;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            View selectedIndicator;
            View currentIndicator;
            if (CircleIndicatorPager.this.mViewpager.getAdapter() == null || CircleIndicatorPager.this.mViewpager.getAdapter().getCount() <= 0) {
                return;
            }
            if (CircleIndicatorPager.this.mLastPosition >= 0 && (currentIndicator = CircleIndicatorPager.this.getChildAt(CircleIndicatorPager.this.mLastPosition)) != null) {
                currentIndicator.setBackgroundResource(CircleIndicatorPager.this.mIndicatorUnselectedBackgroundResId);
            }
            if ((selectedIndicator = CircleIndicatorPager.this.getChildAt(position)) != null) {
                selectedIndicator.setBackgroundResource(CircleIndicatorPager.this.mIndicatorBackgroundResId);
            }
            CircleIndicatorPager.this.mLastPosition = position;
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public CircleIndicatorPager(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleIndicatorPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircleIndicatorPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CircleIndicatorPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewpager = viewPager;
        if (this.mViewpager != null && this.mViewpager.getAdapter() != null) {
            this.mLastPosition = -1;
            this.createIndicators();
            this.mViewpager.removeOnPageChangeListener(this.mInternalPageChangeListener);
            this.mViewpager.addOnPageChangeListener(this.mInternalPageChangeListener);
            this.mInternalPageChangeListener.onPageSelected(this.mViewpager.getCurrentItem());
        }
    }

    public void configureIndicator(int indicatorWidth, int indicatorHeight, int indicatorMargin) {
        this.configureIndicator(indicatorWidth, indicatorHeight, indicatorMargin, R.drawable.white_radius, R.drawable.white_radius);
    }

    public void configureIndicator(int indicatorWidth, int indicatorHeight, int indicatorMargin, @DrawableRes int indicatorBackgroundId, @DrawableRes int indicatorUnselectedBackgroundId) {
        this.mIndicatorWidth = indicatorWidth;
        this.mIndicatorHeight = indicatorHeight;
        this.mIndicatorMargin = indicatorMargin;
        this.mIndicatorBackgroundResId = indicatorBackgroundId;
        this.mIndicatorUnselectedBackgroundResId = indicatorUnselectedBackgroundId;
        this.checkIndicatorConfig(this.getContext());
    }

    private void init(Context context, AttributeSet attrs) {
        this.handleTypedArray(context, attrs);
        this.checkIndicatorConfig(context);
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleIndicatorPager);
        this.mIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.CircleIndicatorPager_ci_width, -1);
        this.mIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.CircleIndicatorPager_ci_height, -1);
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.CircleIndicatorPager_ci_margin, -1);
        this.mIndicatorBackgroundResId = typedArray.getResourceId(R.styleable.CircleIndicatorPager_ci_drawable, R.drawable.white_radius);
        this.mIndicatorUnselectedBackgroundResId = typedArray.getResourceId(R.styleable.CircleIndicatorPager_ci_drawable_unselected, this.mIndicatorBackgroundResId);
        int orientation = typedArray.getInt(R.styleable.CircleIndicatorPager_ci_orientation, -1);
        this.setOrientation(orientation == 1 ? 1 : 0);
        int gravity = typedArray.getInt(R.styleable.CircleIndicatorPager_ci_gravity, -1);
        this.setGravity(gravity >= 0 ? gravity : 17);
        typedArray.recycle();
    }

    private void checkIndicatorConfig(Context context) {
        this.mIndicatorWidth = this.mIndicatorWidth < 0 ? this.dip2px(5.0f) : this.mIndicatorWidth;
        this.mIndicatorHeight = this.mIndicatorHeight < 0 ? this.dip2px(5.0f) : this.mIndicatorHeight;
        this.mIndicatorMargin = this.mIndicatorMargin < 0 ? this.dip2px(5.0f) : this.mIndicatorMargin;
        this.mIndicatorBackgroundResId = this.mIndicatorBackgroundResId == 0 ? R.drawable.white_radius : this.mIndicatorBackgroundResId;
        this.mIndicatorUnselectedBackgroundResId = this.mIndicatorUnselectedBackgroundResId == 0 ? this.mIndicatorBackgroundResId : this.mIndicatorUnselectedBackgroundResId;
    }

    private void createIndicators() {
        this.removeAllViews();
        int count = this.mViewpager.getAdapter().getCount();
        if (count <= 0) {
            return;
        }
        int currentItem = this.mViewpager.getCurrentItem();
        for (int i = 0; i < count; ++i) {
            if (currentItem == i) {
                this.addIndicator(this.mIndicatorBackgroundResId);
                continue;
            }
            this.addIndicator(this.mIndicatorUnselectedBackgroundResId);
        }
    }

    private void addIndicator(@DrawableRes int backgroundDrawableId) {
        View Indicator = new View(this.getContext());
        Indicator.setBackgroundResource(backgroundDrawableId);
        this.addView(Indicator, this.mIndicatorWidth, this.mIndicatorHeight);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)Indicator.getLayoutParams();
        lp.leftMargin = this.mIndicatorMargin;
        lp.rightMargin = this.mIndicatorMargin;
        Indicator.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

