/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.intent.wrapper.PermissionIntent;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.utils.os.ManufacturerUtil;
import java.util.Set;
import org.json.JSONObject;

public class IntentUtils {
    private static final String TAG = "IntentUtils";

    public static boolean jumpToOtherApp(String url, Context context) {
        if (context == null) {
            return false;
        }
        try {
            Intent intent = Intent.parseUri((String)url, (int)1);
            ZLog.d((String)TAG, (String)("jumpToOtherApp url:" + url + ",intent:" + intent.toString()));
            intent.setFlags(0x10000000);
            intent.addFlags(0x20000000);
            context.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            ZLog.e((String)TAG, (String)("jumpToOtherApp failed:" + e.getMessage()));
            return false;
        }
    }

    public static boolean openWebPage(String url, Context context) {
        if (context == null || TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        try {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ZLog.d((String)TAG, (String)("openWebPage url:" + url + ",intent:" + intent.toString()));
            intent.setFlags(0x10000000);
            intent.addFlags(0x20000000);
            context.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            ZLog.e((String)TAG, (String)("openWebPage failed:" + e.getMessage()));
            return false;
        }
    }

    public static boolean startIntent(Context ctx, Intent intent) {
        if (null == intent) {
            ZLog.d((String)"startIntent intent == null");
            return false;
        }
        if (null == ctx) {
            ZLog.d((String)"startIntent ctx == null");
            return false;
        }
        try {
            intent.addFlags(0x10000000);
            ctx.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean startAppDetailSettings(Context ctx) {
        boolean result = false;
        if (ManufacturerUtil.INSTANCE.isXiaomi()) {
            result = PermissionIntent.gotoMiuiPermission(ctx);
        } else if (ManufacturerUtil.INSTANCE.isMeizu()) {
            result = PermissionIntent.gotoMeizuPermission(ctx);
        } else if (ManufacturerUtil.INSTANCE.isHuawei()) {
            result = PermissionIntent.gotoHuaweiPermission(ctx);
        }
        if (result) {
            return true;
        }
        if (BuildUtils.INSTANCE.getSDK_INT() <= 22) {
            return IntentUtils.startAppSettings(ctx, "android.settings.SETTINGS", false);
        }
        return IntentUtils.startAppSettings(ctx, "android.settings.APPLICATION_DETAILS_SETTINGS", false);
    }

    public static boolean startAppSettings(Context ctx, String data) {
        return IntentUtils.startAppSettings(ctx, data, true);
    }

    public static boolean startAppSettings(Context ctx, String data, boolean showDetail) {
        if (null == ctx) {
            ZLog.d((String)"startAppSettings ctx == null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)data)) {
            ZLog.d((String)"startAppSettings data == null");
            if (showDetail) {
                return IntentUtils.startAppDetailSettings(ctx);
            }
            return false;
        }
        Intent intent = new Intent(data);
        if (BuildUtils.INSTANCE.getSDK_INT() >= 26) {
            intent.putExtra("android.provider.extra.APP_PACKAGE", ctx.getPackageName());
        } else if (BuildUtils.INSTANCE.getSDK_INT() >= 21) {
            intent.putExtra("app_package", ctx.getPackageName());
            if (null != ctx.getApplicationInfo()) {
                intent.putExtra("app_uid", ctx.getApplicationInfo().uid);
            }
        }
        intent.setData(Uri.fromParts((String)"package", (String)ctx.getPackageName(), null));
        if (!IntentUtils.startIntent(ctx, intent)) {
            if (showDetail) {
                return IntentUtils.startAppDetailSettings(ctx);
            }
            return false;
        }
        return true;
    }

    public static boolean startSettings(Context ctx, String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction(data);
        return IntentUtils.startIntent(ctx, intent);
    }

    public static void sendTextInfo(Context context, String title, String content) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", content);
        sendIntent.setFlags(0x10000000);
        sendIntent.addFlags(0x20000000);
        sendIntent.setType("text/plain");
        try {
            context.startActivity(Intent.createChooser((Intent)sendIntent, (CharSequence)title));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                context.startActivity(sendIntent);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public static String convertIntentToJson(Intent intent) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (null != intent && !intent.getExtras().isEmpty()) {
                Bundle b = intent.getExtras();
                Set keys = b.keySet();
                for (String key : keys) {
                    try {
                        jsonObject.put(key, b.get(key));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }
}

