/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils.apk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.bihe0832.android.lib.aaf.tools.AAFException;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.ui.toast.ToastUtil;
import com.bihe0832.android.lib.utils.ConvertUtils;
import com.bihe0832.android.lib.utils.encrypt.HexUtils;
import com.bihe0832.android.lib.utils.encrypt.MD5;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;

public class APKUtils {
    public static long getAppVersionCode(Context context) {
        return APKUtils.getAppVersionCode(context, context.getPackageName());
    }

    public static long getAppVersionCode(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            if (BuildUtils.INSTANCE.getSDK_INT() > 27) {
                return pi == null ? 0L : pi.getLongVersionCode();
            }
            return pi == null ? 0L : (long)pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static String getAppVersionName(Context context) {
        return APKUtils.getAppVersionName(context, context.getPackageName());
    }

    public static String getAppVersionName(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? "" : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static int compareVersion(String oldVersion, String newVersion) throws AAFException {
        ZLog.d((String)"testVerion", (String)("oldVersion:" + oldVersion + "\uff1b oldVersion:" + newVersion));
        if (TextUtils.isEmpty((CharSequence)oldVersion) || TextUtils.isEmpty((CharSequence)newVersion)) {
            return -1;
        }
        if (oldVersion.equals(newVersion)) {
            return 0;
        }
        String[] v1Array = oldVersion.split("\\.");
        String[] v2Array = newVersion.split("\\.");
        int v1Len = v1Array.length;
        int v2Len = v2Array.length;
        int baseLen = 0;
        baseLen = v1Len > v2Len ? v2Len : v1Len;
        for (int i = 0; i < baseLen; ++i) {
            if (v1Array[i].equals(v2Array[i])) continue;
            return ConvertUtils.parseInt((String)v1Array[i]) > ConvertUtils.parseInt((String)v2Array[i]) ? 1 : -1;
        }
        if (v1Len != v2Len) {
            return v1Len > v2Len ? 1 : 2;
        }
        return 0;
    }

    public static String getAppName(Context context) {
        return APKUtils.getAppName(context, context.getPackageName());
    }

    public static String getAppName(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? "" : pi.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static List<PackageInfo> getInstalledPackageList(Context ctx) {
        try {
            PackageManager pm = ctx.getPackageManager();
            return pm.getInstalledPackages(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PackageInfo getInstalledPackage(Context ctx, String pkgName) {
        try {
            PackageManager pm = ctx.getPackageManager();
            return pm.getPackageInfo(pkgName.trim(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean startApp(Context ctx, String pkgName) {
        return APKUtils.startApp(ctx, pkgName, true);
    }

    public static boolean startApp(Context ctx, String appName, String pkgName, String launcerClass) {
        return APKUtils.startApp(ctx, appName, pkgName, launcerClass, true);
    }

    public static boolean startApp(Context ctx, String pkgName, boolean showTips) {
        try {
            PackageManager pm = ctx.getPackageManager();
            Intent intent = pm.getLaunchIntentForPackage(pkgName);
            return APKUtils.startApp(ctx, APKUtils.getAppName(ctx, pkgName), pkgName, intent, showTips);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean startApp(Context ctx, String appName, String pkgName, String launcerClass, boolean showTips) {
        try {
            Intent intent = new Intent();
            ComponentName cmp = new ComponentName(pkgName, launcerClass);
            intent.setComponent(cmp);
            return APKUtils.startApp(ctx, appName, pkgName, intent, showTips);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean startApp(Context ctx, String appName, String pkgName) {
        return APKUtils.startApp(ctx, appName, pkgName, true);
    }

    public static boolean startApp(Context ctx, String appName, String pkgName, boolean showTips) {
        try {
            PackageManager pm = ctx.getPackageManager();
            Intent intent = pm.getLaunchIntentForPackage(pkgName);
            return APKUtils.startApp(ctx, appName, pkgName, intent, showTips);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean startApp(Context ctx, String appName, String pkgName, Intent intent, boolean showTips) {
        try {
            if (APKUtils.getInstalledPackage(ctx, pkgName) == null) {
                if (showTips) {
                    ToastUtil.showShort((Context)ctx, (String)"\u5e94\u7528\u672a\u5b89\u88c5\uff0c\u8bf7\u5b89\u88c5\u540e\u91cd\u8bd5");
                }
                return false;
            }
            intent.setAction("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.LAUNCHER");
            intent.addFlags(0x10000000);
            ctx.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (showTips) {
                ToastUtil.showShort((Context)ctx, (String)("\u62c9\u8d77" + appName + "\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5c1d\u8bd5"));
            }
            return false;
        }
    }

    private static String getUid(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            ZLog.d((String)"APKUtils", (String)"getUid context or packageName is null");
            return "";
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 128);
            return String.valueOf(ai.uid);
        }
        catch (Exception e) {
            ZLog.d((String)"APKUtils", (String)("getUid Exception:" + e.getStackTrace()));
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunningTask(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            ZLog.d((String)"APKUtils", (String)"getTcpCountOfRunningTask context or packageName is null");
            return false;
        }
        BufferedReader bufferReader = null;
        try {
            bufferReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/net/tcp"), "UTF-8"));
            String line = null;
            String uid = APKUtils.getUid(context, packageName);
            HashSet<String> ports = new HashSet<String>();
            line = bufferReader.readLine();
            while (line != null) {
                String cur;
                String[] targets = (line = line.trim()).split("\\s+");
                if (targets.length > 7 && !TextUtils.isEmpty((CharSequence)(cur = targets[7])) && Character.isDigit(cur.charAt(0))) {
                    ports.add(cur);
                    if (cur == uid) {
                        boolean bl = true;
                        return bl;
                    }
                }
                line = bufferReader.readLine();
            }
            ZLog.d((String)"APKUtils", (String)"getTcpCountOfRunningTask app: ${packageName}, uid:${uid}, result:${ports.toTypedArray().contentToString()}");
            boolean bl = ports.contains(uid);
            return bl;
        }
        catch (Exception e) {
            ZLog.d((String)"APKUtils", (String)("getTcpCountOfRunningTask, execNetStat IP failed." + e.getStackTrace()));
        }
        finally {
            if (bufferReader != null) {
                try {
                    bufferReader.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        return false;
    }

    public static String getSigMd5ByPkgName(Context context, String pkgName) {
        return APKUtils.getSigMd5ByPkgName(context, pkgName, false);
    }

    public static String getSigMd5ByPkgName(Context context, String pkgName, boolean showTips) {
        block7: {
            if (null != pkgName && pkgName.length() > 0) {
                try {
                    Signature sig = context.getPackageManager().getPackageInfo((String)pkgName, (int)64).signatures[0];
                    String result = MD5.getMd5((byte[])sig.toByteArray());
                    if (null != result && result.length() > 0) {
                        return result;
                    }
                    if (showTips) {
                        ToastUtil.showShort((Context)context, (String)"\u8bfb\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u68c0\u67e5\u5e94\u7528\u662f\u5426\u6709\u7b7e\u540d\uff01");
                    }
                    break block7;
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                    if (showTips) {
                        ToastUtil.showShort((Context)context, (String)"\u5e94\u7528\u672a\u5b89\u88c5\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u5305\u540d\u662f\u5426\u6b63\u786e\uff01");
                    }
                    break block7;
                }
            }
            if (showTips) {
                ToastUtil.showShort((Context)context, (String)"\u8bf7\u5148\u5728\u8f93\u5165\u6846\u8f93\u5165\u9700\u8981\u67e5\u8be2\u7b7e\u540d\u5e94\u7528\u7684\u5305\u540d\uff01");
            }
        }
        return "";
    }

    public static String getSigFingerprint(Context context, String packageName) {
        String hexString = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
            Signature[] signatures = packageInfo.signatures;
            byte[] cert = signatures[0].toByteArray();
            ByteArrayInputStream input = new ByteArrayInputStream(cert);
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate c = (X509Certificate)cf.generateCertificate(input);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(c.getEncoded());
            hexString = HexUtils.bytes2HexStr((byte[])publicKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hexString;
    }
}

