/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.touchregion;

import android.graphics.Rect;
import android.util.Log;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import com.bihe0832.android.lib.ui.touchregion.TouchDelegateGroup;

public class TouchRegion {
    private static final String TAG = TouchRegion.class.getSimpleName();
    private TouchDelegateGroup touchDelegateGroup;

    public TouchRegion(ViewGroup viewGroup) {
        this.touchDelegateGroup = new TouchDelegateGroup((View)viewGroup);
    }

    public TouchRegion(View view) {
        this.touchDelegateGroup = new TouchDelegateGroup((View)view.getParent());
    }

    public void expandViewTouchRegion(View view, float margin) {
        this.expandViewTouchRegion(view, (int)margin);
    }

    public void expandViewTouchRegion(View view, int margin) {
        this.expandViewTouchRegion(view, margin, margin, margin, margin);
    }

    public void expandViewTouchRegion(View view, float left, float top, float right, float bottom) {
        this.expandViewTouchRegion(view, (int)left, (int)top, (int)right, (int)bottom);
    }

    public void expandViewTouchRegion(final View view, final int left, final int top, final int right, final int bottom) {
        if (view == null) {
            Log.e((String)TAG, (String)"expandViewTouchRegion -> view cannot be null!!!");
            return;
        }
        this.restoreViewTouchRegion(view);
        final ViewGroup viewGroup = (ViewGroup)view.getParent();
        if (viewGroup != null) {
            viewGroup.post(new Runnable(){

                @Override
                public void run() {
                    Rect bounds = new Rect();
                    view.setEnabled(true);
                    view.getHitRect(bounds);
                    bounds.left -= left;
                    bounds.top -= top;
                    bounds.right += right;
                    bounds.bottom += bottom;
                    TouchRegion.this.touchDelegateGroup.addTouchDelegate(new TouchDelegate(bounds, view));
                    if (View.class.isInstance(viewGroup)) {
                        viewGroup.setTouchDelegate((TouchDelegate)TouchRegion.this.touchDelegateGroup);
                    }
                }
            });
        }
    }

    public void restoreViewTouchRegion(final View view) {
        if (view == null) {
            Log.e((String)TAG, (String)"restoreViewTouchRegion -> view cannot be null!!!");
            return;
        }
        final ViewGroup viewGroup = (ViewGroup)view.getParent();
        if (viewGroup != null) {
            viewGroup.post(new Runnable(){

                @Override
                public void run() {
                    Rect bounds = new Rect();
                    bounds.setEmpty();
                    TouchRegion.this.touchDelegateGroup.addTouchDelegate(new TouchDelegate(bounds, view));
                    if (View.class.isInstance(viewGroup)) {
                        viewGroup.setTouchDelegate((TouchDelegate)TouchRegion.this.touchDelegateGroup);
                    }
                }
            });
        }
    }
}

