/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.touchregion;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import java.util.ArrayList;

public class TouchDelegateGroup
extends TouchDelegate {
    private static final Rect DEFAULT_RECT = new Rect();
    private ArrayList<TouchDelegate> mTouchDelegates;
    private TouchDelegate mCurrentTouchDelegate;

    public TouchDelegateGroup(View delegateView) {
        super(DEFAULT_RECT, delegateView);
    }

    public void addTouchDelegate(TouchDelegate touchDelegate) {
        if (this.mTouchDelegates == null) {
            this.mTouchDelegates = new ArrayList();
        }
        this.mTouchDelegates.add(touchDelegate);
    }

    public void removeTouchDelegate(TouchDelegate touchDelegate) {
        if (this.mTouchDelegates != null) {
            this.mTouchDelegates.remove(touchDelegate);
            if (this.mTouchDelegates.isEmpty()) {
                this.mTouchDelegates = null;
            }
        }
    }

    public void clearTouchDelegates() {
        if (this.mTouchDelegates != null) {
            this.mTouchDelegates.clear();
        }
        this.mCurrentTouchDelegate = null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        TouchDelegate delegate = null;
        switch (event.getAction()) {
            case 0: {
                if (this.mTouchDelegates == null) break;
                for (TouchDelegate touchDelegate : this.mTouchDelegates) {
                    if (touchDelegate == null || !touchDelegate.onTouchEvent(event)) continue;
                    this.mCurrentTouchDelegate = touchDelegate;
                    return true;
                }
                break;
            }
            case 2: {
                delegate = this.mCurrentTouchDelegate;
                break;
            }
            case 1: 
            case 3: {
                delegate = this.mCurrentTouchDelegate;
                this.mCurrentTouchDelegate = null;
                break;
            }
        }
        return delegate == null ? false : delegate.onTouchEvent(event);
    }
}

