/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.toast;

import android.content.Context;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.toast.R;

public class ToastUtil {
    public static void showLong(Context ctx, String toastInfo) {
        ToastUtil.show(ctx, toastInfo, 1);
    }

    public static void showShort(Context ctx, String toastInfo) {
        ToastUtil.show(ctx, toastInfo, 0);
    }

    public static void showTop(Context ctx, String toastInfo, int duration) {
        ToastUtil.show(ctx, toastInfo, ctx.getResources().getDimension(R.dimen.bihe0832_common_toast_text_size), duration, 48, 0, 200);
    }

    public static void show(Context ctx, String toastInfo, int duration) {
        ToastUtil.show(ctx, toastInfo, ctx.getResources().getDimension(R.dimen.bihe0832_common_toast_text_size), duration, 80, 0, (int)ctx.getResources().getDimension(R.dimen.bihe0832_common_toast_y_offset));
    }

    public static void show(Context ctx, String toastInfo, float textSize, int duration, int gravityType, int xOffset, int yOffset) {
        View contentView = LayoutInflater.from((Context)ctx).inflate(R.layout.com_bihe0832_common_toast, null);
        View layout2 = contentView.findViewById(R.id.bihe0832_common_custom_toast_layout_id);
        TextView toastText = (TextView)layout2.findViewById(R.id.bihe0832_common_toastText);
        Spanned charSequence = TextFactoryUtils.getSpannedTextByHtml((String)toastInfo);
        toastText.setText((CharSequence)charSequence);
        toastText.setTextSize(0, textSize);
        ToastUtil.show(ctx, layout2, duration, gravityType, xOffset, yOffset);
    }

    public static void show(final Context ctx, final View layout2, final int duration, final int gravityType, final int xOffset, final int yOffset) {
        try {
            ThreadManager.getInstance().runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Toast toast = new Toast(ctx);
                    toast.setDuration(duration);
                    toast.setView(layout2);
                    toast.setGravity(gravityType, xOffset, yOffset);
                    toast.show();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

