/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.timer;

import android.text.TextUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.timer.BaseTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TaskManager {
    private static final String LOG_TAG = "TaskManager";
    protected static final int PERIOD = 500;
    private boolean started = false;
    private ConcurrentHashMap<String, BaseTask> mTaskList = new ConcurrentHashMap();
    ScheduledExecutorService scheduledExecutorService = null;
    private static volatile TaskManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance() {
        if (instance != null) return instance;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (instance != null) return instance;
            instance = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TaskManager() {
    }

    private void startTimer() {
        this.stopTimer();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TaskManager.this.runAll();
                }
            }, 1L, 500L, TimeUnit.MILLISECONDS);
            this.started = true;
        }
    }

    private void stopTimer() {
        this.started = false;
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
    }

    private void runAll() {
        ThreadManager.getInstance().start(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TaskManager.this.mTaskList.isEmpty()) {
                        ZLog.d((String)TaskManager.LOG_TAG, (String)"TaskDispatcher stopTimer");
                        TaskManager.this.stopTimer();
                    } else {
                        ZLog.d((String)TaskManager.LOG_TAG, (String)("TaskDispatcher :" + TaskManager.this.mTaskList.size()));
                        for (Map.Entry entry : TaskManager.this.mTaskList.entrySet()) {
                            BaseTask task = (BaseTask)entry.getValue();
                            ZLog.d((String)TaskManager.LOG_TAG, (String)("TaskDispatcher :" + task));
                            if (task.isDeleted()) {
                                TaskManager.this.mTaskList.remove(task);
                                continue;
                            }
                            if (task.getNotifiedTimes() > task.getMyInterval() - 1) {
                                task.resetNotifiedTimes();
                                task.run();
                            }
                            task.increaseNotifiedTimes();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTask(BaseTask task) {
        ZLog.d((String)LOG_TAG, (String)("add task:" + task.getTaskName()));
        if (TextUtils.isEmpty((CharSequence)task.getTaskName())) {
            ZLog.e((String)LOG_TAG, (String)("add task: bad task name" + task.getTaskName()));
            return -3;
        }
        if (task.getMyInterval() < 1) {
            ZLog.e((String)LOG_TAG, (String)("add task: bad Interval" + task.getTaskName()));
            return -1;
        }
        int result = -1;
        if (this.mTaskList.containsKey(task.getTaskName())) {
            if (this.mTaskList.get(task.getTaskName()).isDeleted()) {
                this.mTaskList.get(task.getTaskName()).setDeleted(false);
                return 1;
            }
            return -2;
        }
        ConcurrentHashMap<String, BaseTask> concurrentHashMap = this.mTaskList;
        synchronized (concurrentHashMap) {
            this.mTaskList.put(task.getTaskName(), task);
        }
        result = 0;
        if (!this.started) {
            this.startTimer();
        }
        return result;
    }

    public BaseTask getTaskByName(String taskName) {
        return this.mTaskList.get(taskName);
    }

    public void removeTask(String taskName) {
        ZLog.d((String)LOG_TAG, (String)("remove task:" + taskName));
        if (!TextUtils.isEmpty((CharSequence)taskName) && this.mTaskList.containsKey(taskName)) {
            this.mTaskList.get(taskName).setDeleted(true);
            this.mTaskList.remove(taskName);
        }
    }

    public void letTaskRunEarly(String taskName) {
        ZLog.d((String)LOG_TAG, (String)("letTaskRunEarly task:" + taskName));
        BaseTask task = this.getTaskByName(taskName);
        if (null != task) {
            task.letTaskRunEarly();
        }
    }
}

