/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.textview.expandable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import com.bihe0832.android.lib.ui.textview.R;
import com.bihe0832.android.lib.utils.os.BuildUtils;

public abstract class ExpandableTextView
extends AppCompatTextView {
    public static final int STATUS_SHRINK = 0;
    public static final int STATUS_EXPAND = 1;
    protected static final int MAX_LINE_ON_STRIKE = 4;
    protected static final int TO_EXPAND_HINT_COLOR = -9599586;
    protected static final int TO_SHRINK_HINT_COLOR = -9599586;
    protected static final boolean TOGGLE_ENABLE = true;
    protected static final boolean TO_EXPAND_HINT_SHOW = true;
    protected static final boolean TO_SHRINK_HINT_SHOW = true;
    protected static final boolean ELLIPISIS_HINT_SHOW = true;
    protected int mMaxLineOnStrike;
    protected String mEllipsisHint;
    protected boolean mShowEllipsisHint;
    protected String mToExpandHint;
    protected int mToExpandHintColor;
    protected int mToExpandHintTypeface;
    protected boolean mShowToExpandHint;
    protected String mToShrinkHint;
    protected int mToShrinkHintColor;
    protected int mToShrinkHintTypeface;
    protected boolean mShowToShrinkHint;
    protected boolean mToggleEnable;
    protected int mCurrentStatus = 0;
    protected CharSequence mOriginText;
    protected TextView.BufferType mBufferType;
    protected int mWidth;
    protected OnExpandListener mOnExpandListener;
    protected OnExpandBtnClickListener mOnExpandBtnClickListener;
    protected TouchableSpan mTouchableSpan;
    protected TextPaint mPaint;
    protected boolean performClick = true;

    protected abstract CharSequence getTextByConfig();

    public ExpandableTextView(Context context) {
        super(context);
        this.init();
    }

    public ExpandableTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
        this.init();
    }

    public ExpandableTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
        this.init();
    }

    protected void init() {
        this.mTouchableSpan = new TouchableSpan();
        this.setMovementMethod((MovementMethod)new CustomMovementMethod());
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewTreeObserver obs = ExpandableTextView.this.getViewTreeObserver();
                if (BuildUtils.INSTANCE.getSDK_INT() >= 16) {
                    obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    obs.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                ExpandableTextView.this.setTextInternal(ExpandableTextView.this.getTextByConfig(), ExpandableTextView.this.mBufferType);
            }
        });
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ExpandableTextView.this.toggle();
            }
        });
    }

    protected void initAttrs(Context context, AttributeSet attrs) {
        this.mBufferType = TextView.BufferType.NORMAL;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ExpandableTextView);
        this.mMaxLineOnStrike = typedArray.getInteger(R.styleable.ExpandableTextView_etv_MaxLinesOnShrink, 4);
        this.mEllipsisHint = typedArray.getString(R.styleable.ExpandableTextView_etv_EllipsisHint);
        this.mShowEllipsisHint = typedArray.getBoolean(R.styleable.ExpandableTextView_etv_EllipsisHintShow, true);
        this.mToExpandHint = typedArray.getString(R.styleable.ExpandableTextView_etv_ToExpandHint);
        this.mToExpandHintColor = typedArray.getInteger(R.styleable.ExpandableTextView_etv_ToExpandHintColor, -9599586);
        this.mToExpandHintTypeface = typedArray.getInt(R.styleable.ExpandableTextView_etv_ToExpandTypeface, 0);
        this.mShowToExpandHint = typedArray.getBoolean(R.styleable.ExpandableTextView_etv_ToExpandHintShow, true);
        this.mToShrinkHint = typedArray.getString(R.styleable.ExpandableTextView_etv_ToShrinkHint);
        this.mToShrinkHintColor = typedArray.getInteger(R.styleable.ExpandableTextView_etv_ToShrinkHintColor, -9599586);
        this.mToShrinkHintTypeface = typedArray.getInt(R.styleable.ExpandableTextView_etv_ToShrinkTypeface, 0);
        this.mShowToShrinkHint = typedArray.getBoolean(R.styleable.ExpandableTextView_etv_ToShrinkHintShow, true);
        this.mToggleEnable = typedArray.getBoolean(R.styleable.ExpandableTextView_etv_EnableToggle, true);
        this.mCurrentStatus = typedArray.getInt(R.styleable.ExpandableTextView_etv_InitState, 0);
        if (this.mEllipsisHint == null) {
            this.mEllipsisHint = this.getContext().getResources().getString(R.string.to_ellipsis_hint);
        }
        if (this.mToExpandHint == null) {
            this.mToExpandHint = this.getContext().getResources().getString(R.string.to_expand_hint);
        }
        if (this.mToShrinkHint == null) {
            this.mToShrinkHint = this.getContext().getResources().getString(R.string.to_shrink_hint);
        }
        typedArray.recycle();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.mOriginText = text;
        this.mBufferType = type;
        this.setTextInternal(this.getTextByConfig(), type);
    }

    public void setShrinkText(String text) {
        this.mToShrinkHint = text;
        this.setTextInternal(this.getTextByConfig(), this.mBufferType);
    }

    public void setExpandText(String text) {
        this.mToExpandHint = text;
        this.setTextInternal(this.getTextByConfig(), this.mBufferType);
    }

    public void setCurrentStatus(int mCurrentStatus) {
        this.mCurrentStatus = mCurrentStatus;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
    }

    protected void setTextInternal(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
    }

    private boolean endOfStringIsWrap(String text) {
        return '\n' == text.charAt(text.length() - 1);
    }

    private String removeEndWrap(String text) {
        boolean removeOK = false;
        while (!removeOK) {
            if ('\n' == text.charAt(text.length() - 1)) {
                text = text.substring(0, text.length() - 2);
                continue;
            }
            removeOK = true;
        }
        return text;
    }

    public boolean performClick() {
        if (this.performClick) {
            return super.performClick();
        }
        return false;
    }

    protected int getLengthOfString(String string2) {
        if (string2 == null) {
            return 0;
        }
        return string2.length();
    }

    protected String getSpaceText(CharSequence preText, CharSequence addedText) {
        StringBuilder spaceText = new StringBuilder("");
        float width = this.mPaint.measureText(preText.toString() + spaceText + addedText) + 0.5f;
        while (width <= (float)this.mWidth - this.mPaint.measureText(" ")) {
            spaceText.append(" ");
            width = this.mPaint.measureText(preText.toString() + spaceText + addedText) + 0.5f;
        }
        return spaceText.toString();
    }

    public void setExpandStatus(int status) {
        this.mCurrentStatus = status == 1 ? 1 : 0;
        this.setTextInternal(this.getTextByConfig(), this.mBufferType);
    }

    private void toggle() {
        switch (this.mCurrentStatus) {
            case 1: {
                this.mCurrentStatus = 0;
                if (this.mOnExpandListener == null) break;
                this.mOnExpandListener.onShrink(this);
                break;
            }
            case 0: {
                this.mCurrentStatus = 1;
                if (this.mOnExpandListener == null) break;
                this.mOnExpandListener.onExpand(this);
            }
        }
        this.setTextInternal(this.getTextByConfig(), this.mBufferType);
    }

    public void setOnExpandListener(OnExpandListener onExpandListener) {
        this.mOnExpandListener = onExpandListener;
    }

    public void setOnExpandBtnClickListener(OnExpandBtnClickListener onExpandBtnClickListener) {
        this.setOnClickListener(null);
        this.mOnExpandBtnClickListener = onExpandBtnClickListener;
    }

    protected SpannableStringBuilder getNotFullContent(DynamicLayout mOriginLayout, CharSequence originText, DynamicLayout mFinalLayout, String mToExpandHint) {
        SpannableStringBuilder stringBuilder = new SpannableStringBuilder();
        stringBuilder.append((CharSequence)this.getOriginalTextFromStartToLine(mOriginLayout, originText, 0, mOriginLayout.getLineCount()));
        if (mOriginLayout.getLineCount() != mFinalLayout.getLineCount()) {
            String spaceText = this.getSpaceText(this.getOriginalTextByLine(mOriginLayout, originText, mOriginLayout.getLineCount()), "");
            stringBuilder.append((CharSequence)spaceText);
            stringBuilder.append((CharSequence)"\n");
            stringBuilder.append((CharSequence)this.getSpaceText("", mToExpandHint));
        } else {
            stringBuilder.append((CharSequence)this.getSpaceText(this.getOriginalTextByLine(mOriginLayout, originText, mOriginLayout.getLineCount()), mToExpandHint));
        }
        stringBuilder.append((CharSequence)mToExpandHint);
        stringBuilder.setSpan((Object)this.mTouchableSpan, stringBuilder.length() - this.getLengthOfString(mToExpandHint), stringBuilder.length(), 33);
        return stringBuilder;
    }

    protected SpannableStringBuilder getFullContent(DynamicLayout mOriginLayout, CharSequence originText) {
        int indexEnd;
        SpannableStringBuilder stringBuilder = new SpannableStringBuilder();
        int lineNo = this.mMaxLineOnStrike;
        lineNo = mOriginLayout.getLineCount() == this.mMaxLineOnStrike ? this.mMaxLineOnStrike - 1 : this.mMaxLineOnStrike;
        if (this.mMaxLineOnStrike > 1) {
            stringBuilder.append((CharSequence)this.getOriginalTextFromStartToLine(mOriginLayout, originText, 0, this.mMaxLineOnStrike - 1)).append((CharSequence)"\n");
        } else {
            lineNo = 0;
        }
        int indexStart = mOriginLayout.getLineStart(lineNo);
        int indexEndTrimmed = indexEnd = mOriginLayout.getLineEnd(lineNo);
        if (originText.charAt(indexEnd - 1) == '\n' && indexEndTrimmed > indexStart) {
            indexEndTrimmed = indexEnd - 1;
        }
        float trimmedWidth = this.mPaint.measureText(originText.subSequence(indexStart, indexEndTrimmed) + this.mEllipsisHint + this.mToExpandHint);
        while (trimmedWidth > (float)this.mWidth) {
            trimmedWidth = this.mPaint.measureText(originText.subSequence(indexStart, --indexEndTrimmed).toString() + this.mEllipsisHint + this.mToExpandHint);
        }
        String spaceText = this.getSpaceText(originText.subSequence(indexStart, indexEndTrimmed), this.mEllipsisHint + this.mToExpandHint);
        stringBuilder.append(originText.subSequence(indexStart, indexEndTrimmed)).append((CharSequence)spaceText).append((CharSequence)this.mEllipsisHint);
        stringBuilder.append((CharSequence)this.mToExpandHint);
        stringBuilder.setSpan((Object)this.mTouchableSpan, stringBuilder.length() - this.getLengthOfString(this.mToExpandHint), stringBuilder.length(), 33);
        return stringBuilder;
    }

    protected String getOriginalTextByLine(DynamicLayout mOriginLayout, CharSequence mOriginText, int lineNum) {
        return this.getOriginalTextFromLineToLine(mOriginLayout, mOriginText, lineNum, lineNum);
    }

    protected String getOriginalTextFromLineToLine(DynamicLayout mOriginLayout, CharSequence mOriginText, int startLineNum, int endLineNum) {
        int indexStart = mOriginLayout.getLineStart(startLineNum - 1);
        int indexEnd = mOriginLayout.getLineEnd(endLineNum - 1);
        return this.getOriginalTextFromStartToEnd(mOriginText, indexStart, indexEnd);
    }

    protected String getOriginalTextFromStartToLine(DynamicLayout mOriginLayout, CharSequence mOriginText, int start, int lineNum) {
        int indexEnd = mOriginLayout.getLineEnd(lineNum - 1);
        return this.getOriginalTextFromStartToEnd(mOriginText, start, indexEnd);
    }

    protected String getOriginalTextFromStartToEnd(CharSequence mOriginText, int start, int indexEnd) {
        int indexEndTrimmed = indexEnd;
        if (mOriginText.charAt(indexEnd - 1) == '\n' && indexEndTrimmed > start) {
            indexEndTrimmed = indexEnd - 1;
        }
        return mOriginText.subSequence(start, indexEndTrimmed).toString();
    }

    public class CustomMovementMethod
    extends LinkMovementMethod {
        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            int action = event.getAction();
            ExpandableTextView.this.performClick = true;
            if (action == 1) {
                int line;
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                Layout layout2 = widget.getLayout();
                int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
                TouchableSpan[] link = (TouchableSpan[])buffer.getSpans(off, off, TouchableSpan.class);
                if (link.length != 0) {
                    ExpandableTextView.this.performClick = false;
                    link[0].onClick((View)widget);
                    return true;
                }
            }
            return super.onTouchEvent(widget, buffer, event);
        }
    }

    private class TouchableSpan
    extends ClickableSpan {
        private TouchableSpan() {
        }

        public void onClick(View widget) {
            if (ExpandableTextView.this.mOnExpandBtnClickListener != null) {
                ExpandableTextView.this.mOnExpandBtnClickListener.onClick();
            } else {
                ExpandableTextView.this.toggle();
            }
        }

        public void updateDrawState(TextPaint ds) {
            super.updateDrawState(ds);
            switch (ExpandableTextView.this.mCurrentStatus) {
                case 1: {
                    ds.setColor(ExpandableTextView.this.mToShrinkHintColor);
                    ds.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)ExpandableTextView.this.mToShrinkHintTypeface));
                    break;
                }
                case 0: {
                    ds.setColor(ExpandableTextView.this.mToExpandHintColor);
                    ds.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)ExpandableTextView.this.mToExpandHintTypeface));
                }
            }
            ds.setUnderlineText(false);
        }
    }

    public static interface OnExpandBtnClickListener {
        public void onClick();
    }

    public static interface OnExpandListener {
        public void onExpand(ExpandableTextView var1);

        public void onShrink(ExpandableTextView var1);
    }
}

