/*
 * Decompiled with CFR 0.152.
 */
package com.ajguan.library.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.ajguan.library.IRefreshHeader;
import com.ajguan.library.State;
import com.bihe0832.android.lib.refresh.R;

public class SimpleRefreshHeaderView
extends FrameLayout
implements IRefreshHeader {
    private Animation rotate_up;
    private Animation rotate_down;
    private Animation rotate_infinite;
    private TextView textView;
    private View arrowIcon;
    private View successIcon;

    public SimpleRefreshHeaderView(Context context) {
        this(context, null);
    }

    public SimpleRefreshHeaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.rotate_up = AnimationUtils.loadAnimation((Context)context, (int)R.anim.rotate_up);
        this.rotate_down = AnimationUtils.loadAnimation((Context)context, (int)R.anim.rotate_down);
        this.rotate_infinite = AnimationUtils.loadAnimation((Context)context, (int)R.anim.rotate_infinite);
        SimpleRefreshHeaderView.inflate((Context)context, (int)R.layout.default_refresh_header, (ViewGroup)this);
        this.textView = (TextView)this.findViewById(R.id.text);
        this.arrowIcon = this.findViewById(R.id.arrowIcon);
        this.successIcon = this.findViewById(R.id.successIcon);
    }

    @Override
    public void reset() {
        this.textView.setText(this.getResources().getText(R.string.com_bihe0832_header_reset));
        this.successIcon.setVisibility(4);
        this.arrowIcon.setVisibility(0);
        this.arrowIcon.clearAnimation();
    }

    @Override
    public void pull() {
    }

    @Override
    public void refreshing() {
        this.arrowIcon.setVisibility(4);
        this.textView.setText(this.getResources().getText(R.string.com_bihe0832_header_refreshing));
        this.arrowIcon.clearAnimation();
    }

    @Override
    public void onPositionChange(float currentPos, float lastPos, float refreshPos, boolean isTouch, State state) {
        if (currentPos < refreshPos && lastPos >= refreshPos) {
            Log.i((String)"", (String)">>>>up");
            if (isTouch && state == State.PULL) {
                this.textView.setText(this.getResources().getText(R.string.com_bihe0832_header_pull));
                this.arrowIcon.clearAnimation();
                this.arrowIcon.startAnimation(this.rotate_down);
            }
        } else if (currentPos > refreshPos && lastPos <= refreshPos) {
            Log.i((String)"", (String)">>>>down");
            if (isTouch && state == State.PULL) {
                this.textView.setText(this.getResources().getText(R.string.com_bihe0832_header_pull_over));
                this.arrowIcon.clearAnimation();
                this.arrowIcon.startAnimation(this.rotate_up);
            }
        }
    }

    @Override
    public void complete() {
        this.successIcon.setVisibility(0);
        this.textView.setText(this.getResources().getText(R.string.com_bihe0832_header_completed));
    }
}

