/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.recycleview.ext;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;

public class GridDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private boolean mShowLastLine;
    private int mHorizonSpan;
    private int mVerticalSpan;

    private GridDividerItemDecoration(int horizonSpan, int verticalSpan, int color, boolean showLastLine) {
        this.mHorizonSpan = horizonSpan;
        this.mShowLastLine = showLastLine;
        this.mVerticalSpan = verticalSpan;
        this.mDivider = new ColorDrawable(color);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.drawHorizontal(c, parent);
        this.drawVertical(c, parent);
    }

    private void drawHorizontal(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (this.isLastRaw(parent, i, this.getSpanCount(parent), childCount) && !this.mShowLastLine) continue;
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - params.leftMargin;
            int right = child.getRight() + params.rightMargin;
            int top = child.getBottom() + params.bottomMargin;
            int bottom = top + this.mHorizonSpan;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    private void drawVertical(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if ((parent.getChildViewHolder(child).getAdapterPosition() + 1) % this.getSpanCount(parent) == 0) continue;
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getTop() - params.topMargin;
            int bottom = child.getBottom() + params.bottomMargin + this.mHorizonSpan;
            int left = child.getRight() + params.rightMargin;
            int right = left + this.mVerticalSpan;
            if (i == childCount - 1 && !this.mShowLastLine) {
                right -= this.mVerticalSpan;
            }
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int spanCount = this.getSpanCount(parent);
        int childCount = parent.getAdapter().getItemCount();
        int itemPosition = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        if (itemPosition < 0) {
            return;
        }
        int column = itemPosition % spanCount;
        int left = column * this.mVerticalSpan / spanCount;
        int right = this.mVerticalSpan - (column + 1) * this.mVerticalSpan / spanCount;
        int bottom = this.isLastRaw(parent, itemPosition, spanCount, childCount) ? (this.mShowLastLine ? this.mHorizonSpan : 0) : this.mHorizonSpan;
        outRect.set(left, 0, right, bottom);
    }

    private int getSpanCount(RecyclerView parent) {
        int mSpanCount = -1;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            mSpanCount = ((GridLayoutManager)layoutManager).getSpanCount();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            mSpanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return mSpanCount;
    }

    private boolean isLastRaw(RecyclerView parent, int pos, int spanCount, int childCount) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            return this.getResult(pos, spanCount, childCount);
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation();
            if (orientation == 1) {
                return this.getResult(pos, spanCount, childCount);
            }
            if ((pos + 1) % spanCount == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean getResult(int pos, int spanCount, int childCount) {
        int remainCount = childCount % spanCount;
        return remainCount == 0 ? pos >= childCount - spanCount : pos >= childCount - childCount % spanCount;
    }

    public static class Builder {
        private Context mContext;
        private Resources mResources;
        private boolean mShowLastLine;
        private int mHorizonSpan;
        private int mVerticalSpan;
        private int mColor;

        public Builder(Context context) {
            this.mContext = context;
            this.mResources = context.getResources();
            this.mShowLastLine = true;
            this.mHorizonSpan = 0;
            this.mVerticalSpan = 0;
            this.mColor = -1;
        }

        public Builder setColorResource(@ColorRes int resource) {
            this.setColor(ContextCompat.getColor((Context)this.mContext, (int)resource));
            return this;
        }

        public Builder setColor(int color) {
            this.mColor = color;
            return this;
        }

        public Builder setVerticalSpan(int vertical) {
            this.mVerticalSpan = this.mResources.getDimensionPixelSize(vertical);
            return this;
        }

        public Builder setVerticalSpan(float mVertical) {
            this.mVerticalSpan = (int)TypedValue.applyDimension((int)0, (float)mVertical, (DisplayMetrics)this.mResources.getDisplayMetrics());
            return this;
        }

        public Builder setHorizontalSpan(int horizontal) {
            this.mHorizonSpan = this.mResources.getDimensionPixelSize(horizontal);
            return this;
        }

        public Builder setHorizontalSpan(float horizontal) {
            this.mHorizonSpan = (int)TypedValue.applyDimension((int)0, (float)horizontal, (DisplayMetrics)this.mResources.getDisplayMetrics());
            return this;
        }

        public Builder setShowLastLine(boolean show) {
            this.mShowLastLine = show;
            return this;
        }

        public GridDividerItemDecoration build() {
            return new GridDividerItemDecoration(this.mHorizonSpan, this.mVerticalSpan, this.mColor, this.mShowLastLine);
        }
    }
}

