/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class BitmapUtil {
    public static Bitmap decodeUri(Context context, Uri uri, int maxWidth, int maxHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapUtil.readBitmapScale(context, uri, options);
        int scale = 1;
        for (int i = 0; i < Integer.MAX_VALUE && (options.outWidth / scale > maxWidth && (double)(options.outWidth / scale) > (double)maxWidth * 1.4 || options.outHeight / scale > maxHeight && (double)(options.outHeight / scale) > (double)maxHeight * 1.4); ++i) {
            ++scale;
        }
        options.inSampleSize = scale;
        options.inJustDecodeBounds = false;
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = null;
        try {
            bitmap = BitmapUtil.readBitmapData(context, uri, options);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readBitmapScale(Context context, Uri uri, BitmapFactory.Options options) {
        if (uri == null) {
            return;
        }
        String scheme = uri.getScheme();
        if ("content".equals(scheme) || "file".equals(scheme)) {
            InputStream stream = null;
            try {
                stream = context.getContentResolver().openInputStream(uri);
                BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            }
            catch (Exception e) {
                Log.w((String)"readBitmapScale", (String)("Unable to open content: " + uri), (Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"readBitmapScale", (String)("Unable to close content: " + uri), (Throwable)e);
                    }
                }
            }
        } else if ("android.resource".equals(scheme)) {
            Log.e((String)"readBitmapScale", (String)("Unable to close content: " + uri));
        } else {
            Log.e((String)"readBitmapScale", (String)("Unable to close content: " + uri));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap readBitmapData(Context context, Uri uri, BitmapFactory.Options options) {
        if (uri == null) {
            return null;
        }
        Bitmap bitmap = null;
        String scheme = uri.getScheme();
        if ("content".equals(scheme) || "file".equals(scheme)) {
            InputStream stream = null;
            try {
                stream = context.getContentResolver().openInputStream(uri);
                bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            }
            catch (Exception e) {
                Log.e((String)"readBitmapData", (String)("Unable to open content: " + uri), (Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"readBitmapData", (String)("Unable to close content: " + uri), (Throwable)e);
                    }
                }
            }
        } else if ("android.resource".equals(scheme)) {
            Log.e((String)"readBitmapData", (String)("Unable to close content: " + uri));
        } else {
            Log.e((String)"readBitmapData", (String)("Unable to close content: " + uri));
        }
        return bitmap;
    }
}

