/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.permission.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.bihe0832.android.lib.permission.PermissionManager;
import com.bihe0832.android.lib.permission.PermissionsChecker;
import com.bihe0832.android.lib.permission.R;
import com.bihe0832.android.lib.permission.ui.PermissionDialog;
import com.bihe0832.android.lib.ui.dialog.OnDialogListener;
import com.bihe0832.android.lib.utils.intent.IntentUtils;
import java.util.ArrayList;
import java.util.List;

public class PermissionsActivity
extends Activity {
    public static final String EXTRA_PERMISSIONS = "com.bihe0832.android.lib.permission.extra_permission";
    public static final String EXTRA_SOURCE = "com.bihe0832.android.lib.permission.extra_source";
    public static final String EXTRA_CAN_CANCEL = "com.bihe0832.android.lib.permission.can.cancel";
    private PermissionsChecker permissionsChecker;
    private boolean isRequireCheck;
    protected String[] needCheckPermissionGroup = null;
    protected boolean canCancle = false;
    protected String scene = "";
    private PermissionDialog dialog = null;
    private long lastCheckTime = 0L;
    protected boolean autoDeny = false;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null || !this.getIntent().hasExtra(EXTRA_PERMISSIONS)) {
            throw new RuntimeException("PermissionsActivity need check permission");
        }
        this.setContentView(R.layout.com_bihe0832_lib_permissions_activity);
        try {
            if (this.getIntent().hasExtra(EXTRA_PERMISSIONS)) {
                this.needCheckPermissionGroup = this.getIntent().getStringArrayExtra(EXTRA_PERMISSIONS);
            }
            if (this.getIntent().hasExtra(EXTRA_CAN_CANCEL)) {
                this.canCancle = this.getIntent().getBooleanExtra(EXTRA_CAN_CANCEL, false);
            }
            if (this.getIntent().hasExtra(EXTRA_SOURCE)) {
                this.scene = this.getIntent().getStringExtra(EXTRA_SOURCE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.needCheckPermissionGroup == null || this.needCheckPermissionGroup.length < 1) {
            PermissionManager.INSTANCE.getPermissionCheckResultListener().onFailed(this.scene, "permission error");
            this.finish();
        }
        this.permissionsChecker = new PermissionsChecker((Context)this);
        this.isRequireCheck = true;
    }

    protected PermissionDialog getDialog(List<String> tempPermissionList) {
        return new PermissionDialog((Context)this);
    }

    protected void onResume() {
        super.onResume();
        if (this.isRequireCheck) {
            ArrayList<String> needCheckList = new ArrayList<String>();
            for (String permissionGroupID : this.needCheckPermissionGroup) {
                List<String> permissions = PermissionManager.INSTANCE.getPermissionGroup(this.scene, permissionGroupID);
                for (String permission2 : permissions) {
                    if (!this.permissionsChecker.lacksPermission(permission2)) continue;
                    needCheckList.add(permission2);
                }
            }
            if (needCheckList.size() > 0) {
                this.requestPermissions(needCheckList.toArray(new String[needCheckList.size()]));
            } else {
                this.allPermissionsGranted();
            }
        } else {
            this.isRequireCheck = true;
        }
    }

    protected void requestPermissions(String ... permissions) {
        this.lastCheckTime = System.currentTimeMillis();
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)0);
    }

    protected void allPermissionsGranted() {
        PermissionManager.INSTANCE.getPermissionCheckResultListener().onSuccess(this.scene);
        this.finish();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        long time = System.currentTimeMillis() - this.lastCheckTime;
        if (time < 500L) {
            this.autoDeny = true;
        }
        ArrayList<String> tempPermissionList = new ArrayList<String>();
        for (String permission2 : this.needCheckPermissionGroup) {
            if (!this.permissionsChecker.lacksPermission(permission2)) continue;
            tempPermissionList.add(permission2);
            if (!this.checkAllPermissionsResult()) break;
        }
        if (tempPermissionList.size() > 0) {
            this.isRequireCheck = false;
            this.showMissingPermissionDialog(tempPermissionList);
        } else {
            this.isRequireCheck = true;
            this.allPermissionsGranted();
        }
    }

    protected boolean checkAllPermissionsResult() {
        return false;
    }

    protected void showMissingPermissionDialog(final List<String> tempPermissionList) {
        for (String permission2 : tempPermissionList) {
            PermissionManager.INSTANCE.setUserDenyTime(permission2);
        }
        final String firstPermission = tempPermissionList.get(0);
        String firstPermissionGroupID = "";
        for (String permissionGroupID : this.needCheckPermissionGroup) {
            List<String> permissions = PermissionManager.INSTANCE.getPermissionGroup(this.scene, permissionGroupID);
            if (!permissions.contains(firstPermission)) continue;
            firstPermissionGroupID = permissionGroupID;
            break;
        }
        if (TextUtils.isEmpty((CharSequence)firstPermissionGroupID)) {
            firstPermissionGroupID = firstPermission;
        }
        if (this.dialog == null) {
            this.dialog = this.getDialog(tempPermissionList);
        }
        if (null != this.dialog && !this.dialog.isShowing()) {
            final String finalFirstPermissionGroupID = firstPermissionGroupID;
            this.dialog.show(this.scene, tempPermissionList, this.canCancle, new OnDialogListener(){

                public void onPositiveClick() {
                    PermissionsActivity.this.onPermissionDialogPositiveClick(tempPermissionList);
                }

                public void onNegativeClick() {
                    PermissionsActivity.this.notifyUserCancle(finalFirstPermissionGroupID, firstPermission);
                    PermissionsActivity.this.dialog.dismiss();
                    PermissionsActivity.this.finish();
                }

                public void onCancel() {
                    PermissionsActivity.this.notifyUserCancle(finalFirstPermissionGroupID, firstPermission);
                    PermissionsActivity.this.dialog.dismiss();
                    PermissionsActivity.this.finish();
                }
            });
        } else {
            if (null != this.dialog) {
                this.dialog.dismiss();
            }
            this.notifyUserCancle(firstPermissionGroupID, firstPermission);
            this.finish();
        }
    }

    protected void notifyUserCancle(String firstPermissionGroupID, String firstPermission) {
        PermissionManager.INSTANCE.getPermissionCheckResultListener().onUserCancel(this.scene, firstPermissionGroupID, firstPermission);
    }

    protected void onPermissionDialogPositiveClick(List<String> tempPermissionList) {
        IntentUtils.startAppDetailSettings((Context)this);
    }

    protected void onPermissionDialogPositiveClick(String showPermission) {
        String permissionSettings = PermissionManager.INSTANCE.getPermissionSettings(showPermission);
        if (!IntentUtils.startAppSettings((Context)this, (String)permissionSettings, (boolean)false) && !IntentUtils.startSettings((Context)this, (String)permissionSettings)) {
            IntentUtils.startAppDetailSettings((Context)this);
        }
    }
}

