/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.permission;

import android.content.Context;
import android.support.v4.content.PermissionChecker;
import com.bihe0832.android.lib.permission.wrapper.FloatPermissionWrapperKt;
import java.util.List;

public class PermissionsChecker {
    private final Context mContext;

    public PermissionsChecker(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public boolean lacksPermissions(List<String> permissions) {
        if (permissions == null) {
            return false;
        }
        for (String permission2 : permissions) {
            if (!this.lacksPermission(permission2)) continue;
            return true;
        }
        return false;
    }

    public boolean lacksPermission(String permission2) {
        if (permission2.equalsIgnoreCase("android.permission.SYSTEM_ALERT_WINDOW")) {
            return !FloatPermissionWrapperKt.checkFloatPermission(this.mContext);
        }
        return PermissionChecker.checkSelfPermission((Context)this.mContext, (String)permission2) != 0;
    }
}

