/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.permission;

import android.content.Context;
import android.content.Intent;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.bihe0832.android.lib.config.Config;
import com.bihe0832.android.lib.permission.PermissionManager;
import com.bihe0832.android.lib.permission.PermissionsChecker;
import com.bihe0832.android.lib.permission.R;
import com.bihe0832.android.lib.permission.ui.PermissionsActivity;
import com.bihe0832.android.lib.permission.ui.PermissionsActivityV2;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000s\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000f*\u0001\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002WXB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H\u0002J$\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u001e\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006J*\u0010(\u001a\u00020$2\"\u0010)\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060*j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`+J\u001e\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006J*\u0010,\u001a\u00020$2\"\u0010)\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060*j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`+J\u001e\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0004J*\u0010-\u001a\u00020$2\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040*j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0004`+J\u001e\u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J*\u00100\u001a\u00020$2\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060*j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`+J*\u00102\u001a\u00020$2\"\u00103\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060*j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`+J&\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u0018\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u0006J8\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020\u00062\u0006\u00106\u001a\u0002072\b\u0010:\u001a\u0004\u0018\u00010\u00142\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJH\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020\u00062\u0006\u00106\u001a\u0002072\u000e\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020=0<2\b\u0010:\u001a\u0004\u0018\u00010\u00142\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ&\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020\u00062\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u001e\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u00010\t2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u001e\u0010>\u001a\u00020\u00062\u0006\u00105\u001a\u00020\t2\u0006\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u000207J\u001e\u0010>\u001a\u00020\u00062\u0006\u00105\u001a\u00020\t2\u0006\u0010A\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010B\u001a\u00020\u00062\u0006\u00105\u001a\u00020\tJ\u0012\u0010C\u001a\u0004\u0018\u00010\u00142\u0006\u00109\u001a\u00020\u0006H\u0002J\u0006\u0010D\u001a\u00020EJ\u001e\u0010F\u001a\u00020\u00062\u0006\u00105\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010@\u001a\u000207J&\u0010F\u001a\u00020\u00062\u0006\u00105\u001a\u00020\t2\u0006\u00109\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010@\u001a\u000207J,\u0010F\u001a\u00020\u00062\u0006\u00105\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00062\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010@\u001a\u000207J\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0006J\u0016\u0010L\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010@\u001a\u000207J\u001e\u0010L\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010@\u001a\u000207J$\u0010L\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u00062\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010@\u001a\u000207J\u001e\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010N\u001a\u000207H\u0002J\u001c\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u00109\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006J\u000e\u0010O\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0006J\u0016\u0010O\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006J\u0018\u0010P\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\u0006J\u0016\u0010Q\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010@\u001a\u000207J\u001e\u0010Q\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010@\u001a\u000207J$\u0010Q\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u00062\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010@\u001a\u000207J\u000e\u0010R\u001a\u00020\u00062\u0006\u0010K\u001a\u00020\u0006J\u000e\u0010S\u001a\u00020\u00062\u0006\u00105\u001a\u00020\tJ\u000e\u0010T\u001a\u00020\u00062\u0006\u00105\u001a\u00020\tJ\u001c\u0010U\u001a\u0002072\u0006\u00105\u001a\u00020\t2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u0018\u0010U\u001a\u0002072\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u0006J\u000e\u0010V\u001a\u00020$2\u0006\u0010K\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001d0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/bihe0832/android/lib/permission/PermissionManager;", "", "()V", "PERMISSION_REQUEST_CODE", "", "TAG", "", "USER_DENY_KEY", "mContext", "Landroid/content/Context;", "mDefaultDesc", "getMDefaultDesc", "()Ljava/lang/String;", "mDefaultDesc$delegate", "Lkotlin/Lazy;", "mDefaultScene", "getMDefaultScene", "mDefaultScene$delegate", "mOuterResultListenerList", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/bihe0832/android/lib/permission/PermissionManager$OnPermissionResult;", "mPermissionCheckResultListener", "com/bihe0832/android/lib/permission/PermissionManager$mPermissionCheckResultListener$2$1", "getMPermissionCheckResultListener", "()Lcom/bihe0832/android/lib/permission/PermissionManager$mPermissionCheckResultListener$2$1;", "mPermissionCheckResultListener$delegate", "mPermissionContent", "mPermissionDesc", "mPermissionGroup", "", "mPermissionIcon", "mPermissionScene", "mPermissionSettings", "addHtmlWrapper", "content", "addPermissionGroup", "", "sceneid", "permissionGroupID", "permissions", "addPermissionGroupContent", "permissionDesc", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "addPermissionGroupDesc", "addPermissionGroupIcon", "icon", "permissionScene", "addPermissionGroupScene", "sceneDesc", "addPermissionSettings", "permissionSettings", "checkPermission", "context", "canCancel", "", "permissionGroupIDList", "scene", "result", "permissionsActivityClass", "Ljava/lang/Class;", "Lcom/bihe0832/android/lib/permission/ui/PermissionsActivity;", "getDefaultPermissionContent", "showPermissionGroupID", "needSpecial", "sceneText", "getNegativeText", "getOuterPermissionResultListener", "getPermissionCheckResultListener", "Lcom/bihe0832/android/lib/permission/PermissionManager$InnerOnPermissionResult;", "getPermissionContent", "sceneID", "tempPermissionList", "getPermissionDenyTime", "", "permission", "getPermissionDesc", "getPermissionGroup", "isPermission", "getPermissionIcon", "getPermissionKey", "getPermissionScene", "getPermissionSettings", "getPositiveText", "getTitle", "hasPermissionGroup", "setUserDenyTime", "InnerOnPermissionResult", "OnPermissionResult", "LibPermission_release"})
public final class PermissionManager {
    private static final String TAG = "PermissionManager";
    public static final int PERMISSION_REQUEST_CODE = 0;
    private static Context mContext;
    private static final String USER_DENY_KEY = "UserPermissionDenyKey";
    private static final ConcurrentHashMap<String, List<String>> mPermissionGroup;
    private static final ConcurrentHashMap<String, Integer> mPermissionIcon;
    private static final ConcurrentHashMap<String, String> mPermissionScene;
    private static final ConcurrentHashMap<String, String> mPermissionDesc;
    private static final ConcurrentHashMap<String, String> mPermissionContent;
    private static final ConcurrentHashMap<String, String> mPermissionSettings;
    private static final ConcurrentHashMap<String, OnPermissionResult> mOuterResultListenerList;
    private static final Lazy mDefaultScene$delegate;
    private static final Lazy mDefaultDesc$delegate;
    private static final Lazy mPermissionCheckResultListener$delegate;
    public static final PermissionManager INSTANCE;

    private final String getMDefaultScene() {
        Lazy lazy = mDefaultScene$delegate;
        PermissionManager permissionManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final String getMDefaultDesc() {
        Lazy lazy = mDefaultDesc$delegate;
        PermissionManager permissionManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final OnPermissionResult getOuterPermissionResultListener(String scene) {
        return mOuterResultListenerList.get(scene);
    }

    @NotNull
    public final InnerOnPermissionResult getPermissionCheckResultListener() {
        return this.getMPermissionCheckResultListener();
    }

    private final mPermissionCheckResultListener.1 getMPermissionCheckResultListener() {
        Lazy lazy = mPermissionCheckResultListener$delegate;
        PermissionManager permissionManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return lazy.getValue();
    }

    @NotNull
    public final String getPermissionKey(@Nullable String sceneid, @NotNull String permissionGroupID) {
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        String string = sceneid;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return permissionGroupID + sceneid;
        }
        return permissionGroupID;
    }

    public final void addPermissionGroup(@NotNull String sceneid, @NotNull String permissionGroupID, @NotNull List<String> permissions) {
        Intrinsics.checkParameterIsNotNull((Object)sceneid, (String)"sceneid");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        Intrinsics.checkParameterIsNotNull(permissions, (String)"permissions");
        mPermissionGroup.put(this.getPermissionKey(sceneid, permissionGroupID), permissions);
    }

    public final void addPermissionGroupScene(@NotNull String sceneid, @NotNull String permissionGroupID, @NotNull String sceneDesc) {
        Intrinsics.checkParameterIsNotNull((Object)sceneid, (String)"sceneid");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        Intrinsics.checkParameterIsNotNull((Object)sceneDesc, (String)"sceneDesc");
        mPermissionScene.put(this.getPermissionKey(sceneid, permissionGroupID), sceneDesc);
    }

    public final void addPermissionGroupDesc(@NotNull String sceneid, @NotNull String permissionGroupID, @NotNull String permissionDesc) {
        Intrinsics.checkParameterIsNotNull((Object)sceneid, (String)"sceneid");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        Intrinsics.checkParameterIsNotNull((Object)permissionDesc, (String)"permissionDesc");
        mPermissionDesc.put(this.getPermissionKey(sceneid, permissionGroupID), permissionDesc);
    }

    public final void addPermissionGroupContent(@NotNull String sceneid, @NotNull String permissionGroupID, @NotNull String permissionDesc) {
        Intrinsics.checkParameterIsNotNull((Object)sceneid, (String)"sceneid");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        Intrinsics.checkParameterIsNotNull((Object)permissionDesc, (String)"permissionDesc");
        mPermissionContent.put(this.getPermissionKey(sceneid, permissionGroupID), permissionDesc);
    }

    public final void addPermissionGroupIcon(@NotNull String sceneid, @NotNull String permissionGroupID, int icon) {
        Intrinsics.checkParameterIsNotNull((Object)sceneid, (String)"sceneid");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        mPermissionIcon.put(this.getPermissionKey(sceneid, permissionGroupID), icon);
    }

    public final void addPermissionGroupScene(@NotNull HashMap<String, String> permissionScene) {
        Intrinsics.checkParameterIsNotNull(permissionScene, (String)"permissionScene");
        mPermissionScene.putAll((Map<String, String>)permissionScene);
    }

    public final void addPermissionGroupDesc(@NotNull HashMap<String, String> permissionDesc) {
        Intrinsics.checkParameterIsNotNull(permissionDesc, (String)"permissionDesc");
        mPermissionDesc.putAll((Map<String, String>)permissionDesc);
    }

    public final void addPermissionGroupContent(@NotNull HashMap<String, String> permissionDesc) {
        Intrinsics.checkParameterIsNotNull(permissionDesc, (String)"permissionDesc");
        mPermissionContent.putAll((Map<String, String>)permissionDesc);
    }

    public final void addPermissionGroupIcon(@NotNull HashMap<String, Integer> permissionScene) {
        Intrinsics.checkParameterIsNotNull(permissionScene, (String)"permissionScene");
        mPermissionIcon.putAll((Map<String, Integer>)permissionScene);
    }

    public final void addPermissionSettings(@NotNull HashMap<String, String> permissionSettings) {
        Intrinsics.checkParameterIsNotNull(permissionSettings, (String)"permissionSettings");
        mPermissionSettings.putAll((Map<String, String>)permissionSettings);
    }

    public final boolean hasPermissionGroup(@Nullable Context context, @NotNull String permissionGroupID) {
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        return mPermissionGroup.containsKey(permissionGroupID) ? !new PermissionsChecker(context).lacksPermissions(mPermissionGroup.get(permissionGroupID)) : !new PermissionsChecker(context).lacksPermission(permissionGroupID);
    }

    public final boolean hasPermissionGroup(@NotNull Context context, @NotNull List<String> permissionGroupIDList) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(permissionGroupIDList, (String)"permissionGroupIDList");
        for (String permissionGroupID : permissionGroupIDList) {
            if (this.hasPermissionGroup(context, permissionGroupID)) continue;
            return false;
        }
        return true;
    }

    public final void checkPermission(@Nullable Context context, @NotNull String permissionGroupID) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        boolean bl = false;
        Context context2 = context;
        PermissionManager permissionManager = this;
        boolean bl2 = false;
        List list2 = list = (List)new ArrayList();
        boolean bl3 = false;
        boolean bl4 = false;
        List $this$apply = list2;
        boolean bl5 = false;
        $this$apply.add(permissionGroupID);
        list = list2;
        permissionManager.checkPermission(context2, bl, (List<String>)list);
    }

    public final void checkPermission(@Nullable Context context, @NotNull List<String> permissionGroupIDList) {
        Intrinsics.checkParameterIsNotNull(permissionGroupIDList, (String)"permissionGroupIDList");
        this.checkPermission(context, false, permissionGroupIDList);
    }

    public final void checkPermission(@Nullable Context context, @NotNull String scene, @NotNull List<String> permissionGroupIDList) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull(permissionGroupIDList, (String)"permissionGroupIDList");
        this.checkPermission(context, scene, false, null, permissionGroupIDList);
    }

    public final void checkPermission(@Nullable Context context, boolean canCancel, @NotNull List<String> permissionGroupIDList) {
        Intrinsics.checkParameterIsNotNull(permissionGroupIDList, (String)"permissionGroupIDList");
        this.checkPermission(context, "", canCancel, null, permissionGroupIDList);
    }

    public final void checkPermission(@Nullable Context context, @NotNull String scene, boolean canCancel, @Nullable OnPermissionResult result, @NotNull List<String> permissionGroupIDList) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull(permissionGroupIDList, (String)"permissionGroupIDList");
        this.checkPermission(context, scene, canCancel, PermissionsActivityV2.class, result, permissionGroupIDList);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkPermission(@Nullable Context context, @NotNull String scene, boolean canCancel, @NotNull Class<? extends PermissionsActivity> permissionsActivityClass, @Nullable OnPermissionResult result, @NotNull List<String> permissionGroupIDList) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull(permissionsActivityClass, (String)"permissionsActivityClass");
        Intrinsics.checkParameterIsNotNull(permissionGroupIDList, (String)"permissionGroupIDList");
        OnPermissionResult onPermissionResult = result;
        if (onPermissionResult != null) {
            OnPermissionResult onPermissionResult2 = onPermissionResult;
            boolean bl = false;
            boolean bl2 = false;
            OnPermissionResult it = onPermissionResult2;
            boolean bl3 = false;
            mOuterResultListenerList.put(scene, it);
        }
        if (context == null) {
            this.getMPermissionCheckResultListener().onFailed(scene, "context is null");
        } else {
            mContext = context.getApplicationContext();
            if (this.hasPermissionGroup(context, permissionGroupIDList)) {
                this.getMPermissionCheckResultListener().onSuccess(scene);
            } else {
                try {
                    void $this$toTypedArray$iv;
                    Intent intent = new Intent(context, permissionsActivityClass);
                    Collection collection = permissionGroupIDList;
                    String string = "com.bihe0832.android.lib.permission.extra_permission";
                    Intent intent2 = intent;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] stringArray2 = stringArray;
                    intent2.putExtra(string, stringArray2);
                    intent.putExtra("com.bihe0832.android.lib.permission.can.cancel", canCancel);
                    intent.putExtra("com.bihe0832.android.lib.permission.extra_source", scene);
                    intent.addFlags(0x20000000);
                    ActivityCompat.startActivity((Context)context, (Intent)intent, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.getMPermissionCheckResultListener().onFailed(scene, "start permission activity failed");
                }
            }
        }
    }

    @NotNull
    public final List<String> getPermissionGroup(@NotNull String scene, @NotNull String permissionGroupID) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionGroup.containsKey(this.getPermissionKey(scene, permissionGroupID))) {
            return this.getPermissionGroup(this.getPermissionKey(scene, permissionGroupID), false);
        }
        return this.getPermissionGroup(permissionGroupID, true);
    }

    private final List<String> getPermissionGroup(String permissionGroupID, boolean isPermission) {
        List list;
        boolean bl = false;
        List permissionList = list = (List)new ArrayList();
        if (mPermissionGroup.containsKey(permissionGroupID)) {
            List<String> list2 = mPermissionGroup.get(permissionGroupID);
            if (list2 != null) {
                List<String> list3 = list2;
                boolean bl2 = false;
                boolean bl3 = false;
                List<String> it = list3;
                boolean bl4 = false;
                List<String> list4 = it;
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"it");
                permissionList.addAll((Collection)list4);
            }
        }
        if (permissionList.isEmpty() && isPermission) {
            permissionList.add(permissionGroupID);
        }
        return permissionList;
    }

    public final int getPermissionIcon(@NotNull String scene, @NotNull String permissionGroupID) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionIcon.containsKey(this.getPermissionKey(scene, permissionGroupID))) {
            return this.getPermissionIcon(this.getPermissionKey(scene, permissionGroupID));
        }
        return this.getPermissionIcon(permissionGroupID);
    }

    public final int getPermissionIcon(@NotNull String permissionGroupID) {
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionIcon.containsKey(permissionGroupID)) {
            Integer n = mPermissionIcon.get(permissionGroupID);
            return n != null ? n : R.mipmap.icon;
        }
        return R.mipmap.icon;
    }

    @NotNull
    public final String getPermissionScene(@NotNull String scene, @NotNull String permissionGroupID, boolean needSpecial) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionScene.containsKey(this.getPermissionKey(scene, permissionGroupID))) {
            return this.getPermissionScene(this.getPermissionKey(scene, permissionGroupID), needSpecial);
        }
        return this.getPermissionScene(permissionGroupID, needSpecial);
    }

    @NotNull
    public final String getPermissionScene(@NotNull String permissionGroupID, boolean needSpecial) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionScene.containsKey(permissionGroupID)) {
            if (mPermissionScene.get(permissionGroupID) != null) {
                String string2;
                if (needSpecial) {
                    String string3 = mPermissionScene.get(permissionGroupID);
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mPermissionScene.get(permissionGroupID)!!");
                    string2 = this.addHtmlWrapper(string3);
                } else {
                    String string4 = mPermissionScene.get(permissionGroupID);
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"mPermissionScene.get(permissionGroupID)!!");
                    string2 = string4;
                }
                return string2;
            }
            string = "";
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getPermissionDesc(@NotNull String scene, @NotNull String permissionGroupID, boolean needSpecial) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionDesc.containsKey(this.getPermissionKey(scene, permissionGroupID))) {
            return this.getPermissionDesc(this.getPermissionKey(scene, permissionGroupID), needSpecial);
        }
        return this.getPermissionDesc(permissionGroupID, needSpecial);
    }

    @NotNull
    public final String getPermissionDesc(@NotNull String permissionGroupID, boolean needSpecial) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionDesc.containsKey(permissionGroupID)) {
            if (mPermissionDesc.get(permissionGroupID) != null) {
                String string2;
                if (needSpecial) {
                    String string3 = mPermissionDesc.get(permissionGroupID);
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mPermissionDesc.get(permissionGroupID)!!");
                    string2 = this.addHtmlWrapper(string3);
                } else {
                    String string4 = mPermissionDesc.get(permissionGroupID);
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"mPermissionDesc.get(permissionGroupID)!!");
                    string2 = string4;
                }
                return string2;
            }
            string = "";
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getPermissionContent(@NotNull Context context, @NotNull String scene, @NotNull String permissionGroupID, boolean needSpecial) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionContent.containsKey(this.getPermissionKey(scene, permissionGroupID))) {
            return this.getPermissionContent(context, this.getPermissionKey(scene, permissionGroupID), needSpecial);
        }
        return this.getPermissionContent(context, permissionGroupID, needSpecial);
    }

    @NotNull
    public final String getPermissionContent(@NotNull Context context, @NotNull String permissionGroupID, boolean needSpecial) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permissionGroupID, (String)"permissionGroupID");
        if (mPermissionContent.containsKey(permissionGroupID)) {
            String string = mPermissionContent.get(permissionGroupID);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                String string3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                return string3;
            }
        }
        return this.getDefaultPermissionContent(context, permissionGroupID, needSpecial);
    }

    @NotNull
    public final String getPermissionScene(@NotNull String sceneID, @NotNull List<String> tempPermissionList, boolean needSpecial) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)sceneID, (String)"sceneID");
        Intrinsics.checkParameterIsNotNull(tempPermissionList, (String)"tempPermissionList");
        String scene = "";
        Iterable $this$forEach$iv = tempPermissionList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            scene = scene + INSTANCE.getPermissionScene(sceneID, it, needSpecial) + "\u3001";
        }
        String string2 = scene;
        int n = 0;
        int n2 = scene.length() - 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        scene = string = string4;
        return scene;
    }

    @NotNull
    public final String getPermissionDesc(@NotNull String sceneID, @NotNull List<String> tempPermissionList, boolean needSpecial) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)sceneID, (String)"sceneID");
        Intrinsics.checkParameterIsNotNull(tempPermissionList, (String)"tempPermissionList");
        String desc = "";
        Iterable $this$forEach$iv = tempPermissionList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            desc = desc + INSTANCE.getPermissionDesc(sceneID, it, needSpecial) + "\u3001";
        }
        String string2 = desc;
        int n = 0;
        int n2 = desc.length() - 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        desc = string = string4;
        return desc;
    }

    @NotNull
    public final String getPermissionContent(@NotNull Context context, @NotNull String sceneID, @NotNull List<String> tempPermissionList, boolean needSpecial) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sceneID, (String)"sceneID");
        Intrinsics.checkParameterIsNotNull(tempPermissionList, (String)"tempPermissionList");
        return tempPermissionList.size() > 1 ? this.getDefaultPermissionContent(context, this.getPermissionScene(sceneID, tempPermissionList, needSpecial), this.getPermissionDesc(sceneID, tempPermissionList, needSpecial)) : (tempPermissionList.size() > 0 ? this.getPermissionContent(context, sceneID, tempPermissionList.get(0), needSpecial) : "");
    }

    @NotNull
    public final String getDefaultPermissionContent(@NotNull Context context, @NotNull String showPermissionGroupID, boolean needSpecial) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)showPermissionGroupID, (String)"showPermissionGroupID");
        return this.getDefaultPermissionContent(context, this.getPermissionScene(showPermissionGroupID, needSpecial), this.getPermissionDesc(showPermissionGroupID, needSpecial));
    }

    @NotNull
    public final String getDefaultPermissionContent(@NotNull Context context, @NotNull String sceneText, @NotNull String permissionDesc) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sceneText, (String)"sceneText");
        Intrinsics.checkParameterIsNotNull((Object)permissionDesc, (String)"permissionDesc");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = context.getString(R.string.com_bihe0832_permission_default_content);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026rmission_default_content)");
        String string3 = string2;
        Object[] objectArray = new Object[]{APKUtils.getAppName((Context)context), TextUtils.isEmpty((CharSequence)sceneText) ? this.getMDefaultScene() : sceneText, TextUtils.isEmpty((CharSequence)permissionDesc) ? this.getMDefaultDesc() : permissionDesc};
        boolean bl = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    @NotNull
    public final String getTitle(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string2 = context.getResources().getString(R.string.com_bihe0832_permission_title);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u2026ihe0832_permission_title)");
        return string2;
    }

    @NotNull
    public final String getNegativeText(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string2 = context.getResources().getString(R.string.com_bihe0832_permission_negtive);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u2026e0832_permission_negtive)");
        return string2;
    }

    @NotNull
    public final String getPositiveText(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string2 = context.getResources().getString(R.string.com_bihe0832_permission_positive);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u20260832_permission_positive)");
        return string2;
    }

    public final long getPermissionDenyTime(@NotNull String permission2) {
        Intrinsics.checkParameterIsNotNull((Object)permission2, (String)"permission");
        return Config.readConfig((String)(USER_DENY_KEY + permission2), (long)0L);
    }

    public final void setUserDenyTime(@NotNull String permission2) {
        Intrinsics.checkParameterIsNotNull((Object)permission2, (String)"permission");
        Config.writeConfig((String)(USER_DENY_KEY + permission2), (long)System.currentTimeMillis());
    }

    @NotNull
    public final String getPermissionSettings(@NotNull String permission2) {
        Intrinsics.checkParameterIsNotNull((Object)permission2, (String)"permission");
        String string2 = mPermissionSettings.get(permission2);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            String string4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
            return string4;
        }
        return "";
    }

    private final String addHtmlWrapper(String content) {
        StringBuilder stringBuilder = new StringBuilder().append("<font color ='");
        Object object = mContext;
        if (object == null || (object = object.getResources()) == null || (object = object.getString(R.string.com_bihe0832_permission_color)) == null) {
            object = "#38ADFF";
        }
        return stringBuilder.append(object).append("'><b>").append(content).append("</b></font>").toString();
    }

    private PermissionManager() {
    }

    static {
        PermissionManager permissionManager;
        INSTANCE = permissionManager = new PermissionManager();
        USER_DENY_KEY = USER_DENY_KEY;
        mPermissionGroup = new ConcurrentHashMap();
        mPermissionIcon = new ConcurrentHashMap();
        mPermissionScene = new ConcurrentHashMap();
        mPermissionDesc = new ConcurrentHashMap();
        mPermissionContent = new ConcurrentHashMap();
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        boolean bl = false;
        boolean bl2 = false;
        ConcurrentHashMap<String, String> $this$apply = concurrentHashMap;
        boolean bl3 = false;
        $this$apply.put("android.permission.SYSTEM_ALERT_WINDOW", "android.settings.action.MANAGE_OVERLAY_PERMISSION");
        mPermissionSettings = concurrentHashMap;
        mOuterResultListenerList = new ConcurrentHashMap();
        mDefaultScene$delegate = LazyKt.lazy((Function0)mDefaultScene.2.INSTANCE);
        mDefaultDesc$delegate = LazyKt.lazy((Function0)mDefaultDesc.2.INSTANCE);
        mPermissionCheckResultListener$delegate = LazyKt.lazy((Function0)mPermissionCheckResultListener.2.INSTANCE);
    }

    public static final /* synthetic */ Context access$getMContext$p(PermissionManager $this) {
        PermissionManager permissionManager = $this;
        return mContext;
    }

    public static final /* synthetic */ void access$setMContext$p(PermissionManager $this, Context context) {
        PermissionManager permissionManager = $this;
        mContext = context;
    }

    public static final /* synthetic */ OnPermissionResult access$getOuterPermissionResultListener(PermissionManager $this, String scene) {
        return $this.getOuterPermissionResultListener(scene);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMOuterResultListenerList$p(PermissionManager $this) {
        PermissionManager permissionManager = $this;
        return mOuterResultListenerList;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J \u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&J \u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&\u00a8\u0006\f"}, d2={"Lcom/bihe0832/android/lib/permission/PermissionManager$OnPermissionResult;", "", "onFailed", "", "msg", "", "onSuccess", "onUserCancel", "scene", "permissionGroupID", "permission", "onUserDeny", "LibPermission_release"})
    public static interface OnPermissionResult {
        public void onSuccess();

        public void onUserCancel(@NotNull String var1, @NotNull String var2, @NotNull String var3);

        public void onUserDeny(@NotNull String var1, @NotNull String var2, @NotNull String var3);

        public void onFailed(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J \u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&J \u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&\u00a8\u0006\f"}, d2={"Lcom/bihe0832/android/lib/permission/PermissionManager$InnerOnPermissionResult;", "", "onFailed", "", "scene", "", "msg", "onSuccess", "onUserCancel", "permissionGroupID", "permission", "onUserDeny", "LibPermission_release"})
    public static interface InnerOnPermissionResult {
        public void onSuccess(@NotNull String var1);

        public void onUserCancel(@NotNull String var1, @NotNull String var2, @NotNull String var3);

        public void onUserDeny(@NotNull String var1, @NotNull String var2, @NotNull String var3);

        public void onFailed(@NotNull String var1, @NotNull String var2);
    }
}

