/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.permission.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.bihe0832.android.lib.permission.PermissionManager;
import com.bihe0832.android.lib.permission.PermissionsChecker;
import com.bihe0832.android.lib.permission.R;
import com.bihe0832.android.lib.permission.ui.PermissionDialog;
import com.bihe0832.android.lib.ui.dialog.OnDialogListener;
import com.bihe0832.android.lib.utils.intent.IntentUtils;
import java.util.ArrayList;
import java.util.List;

public class PermissionsActivity
extends Activity {
    public static final String EXTRA_PERMISSIONS = "com.bihe0832.android.lib.permission.extra_permission";
    public static final String EXTRA_SOURCE = "com.bihe0832.android.lib.permission.extra_source";
    public static final String EXTRA_CAN_CANCEL = "com.bihe0832.android.lib.permission.can.cancel";
    private PermissionsChecker permissionsChecker;
    private boolean isRequireCheck;
    private String[] needCheckPermission = null;
    private boolean canCancle = false;
    private String scene = "";
    private PermissionDialog dialog = null;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null || !this.getIntent().hasExtra(EXTRA_PERMISSIONS)) {
            throw new RuntimeException("PermissionsActivity need check permission");
        }
        this.setContentView(R.layout.com_bihe0832_lib_permissions_activity);
        try {
            if (this.getIntent().hasExtra(EXTRA_PERMISSIONS)) {
                this.needCheckPermission = this.getIntent().getStringArrayExtra(EXTRA_PERMISSIONS);
            }
            if (this.getIntent().hasExtra(EXTRA_CAN_CANCEL)) {
                this.canCancle = this.getIntent().getBooleanExtra(EXTRA_CAN_CANCEL, false);
            }
            if (this.getIntent().hasExtra(EXTRA_SOURCE)) {
                this.scene = this.getIntent().getStringExtra(EXTRA_SOURCE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.needCheckPermission == null || this.needCheckPermission.length < 1) {
            PermissionManager.INSTANCE.getPermissionCheckResultListener().onFailed(this.scene, "permission error");
            this.finish();
        }
        this.permissionsChecker = new PermissionsChecker((Context)this);
        this.isRequireCheck = true;
    }

    protected PermissionDialog getDialog(String permission2) {
        return new PermissionDialog((Context)this);
    }

    protected PermissionDialog getDialog(List<String> tempPermissionList) {
        return new PermissionDialog((Context)this);
    }

    protected void onResume() {
        super.onResume();
        if (this.isRequireCheck) {
            ArrayList<String> needCheckList = new ArrayList<String>();
            for (String permission2 : this.needCheckPermission) {
                if (!this.permissionsChecker.lacksPermission(permission2)) continue;
                needCheckList.add(permission2);
            }
            if (needCheckList.size() > 0) {
                this.requestPermissions(needCheckList.toArray(new String[needCheckList.size()]));
            } else {
                this.allPermissionsGranted();
            }
        } else {
            this.isRequireCheck = true;
        }
    }

    private void requestPermissions(String ... permissions) {
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)0);
    }

    private void allPermissionsGranted() {
        PermissionManager.INSTANCE.getPermissionCheckResultListener().onSuccess(this.scene);
        this.finish();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        String tempPermission = "";
        ArrayList<String> tempPermissionList = new ArrayList<String>();
        for (String permission2 : this.needCheckPermission) {
            if (!this.permissionsChecker.lacksPermission(permission2)) continue;
            tempPermissionList.add(permission2);
            if (this.checkAllPermissionsResult()) continue;
            tempPermission = permission2;
            break;
        }
        if (!TextUtils.isEmpty((CharSequence)tempPermission)) {
            this.isRequireCheck = false;
            this.showMissingPermissionDialog(tempPermission);
        } else if (tempPermissionList.size() > 0) {
            this.isRequireCheck = false;
            this.showMissingPermissionDialog(tempPermissionList);
        } else {
            this.isRequireCheck = true;
            this.allPermissionsGranted();
        }
    }

    protected boolean checkAllPermissionsResult() {
        return false;
    }

    private void showMissingPermissionDialog(final List<String> tempPermissionList) {
        if (this.dialog == null) {
            this.dialog = this.getDialog(tempPermissionList);
        }
        if (!this.dialog.isShowing()) {
            this.dialog.show(this.scene, tempPermissionList, this.canCancle, new OnDialogListener(){

                public void onPositiveClick() {
                    PermissionsActivity.this.onPermissionDialogPositiveClick(tempPermissionList);
                }

                public void onNegativeClick() {
                    for (String permission2 : tempPermissionList) {
                        PermissionManager.INSTANCE.setUserDenyTime(permission2);
                    }
                    PermissionManager.INSTANCE.getPermissionCheckResultListener().onUserCancel(PermissionsActivity.this.scene, (String)tempPermissionList.get(0));
                    PermissionsActivity.this.dialog.dismiss();
                    PermissionsActivity.this.finish();
                }

                public void onCancel() {
                    for (String permission2 : tempPermissionList) {
                        PermissionManager.INSTANCE.setUserDenyTime(permission2);
                    }
                    PermissionManager.INSTANCE.getPermissionCheckResultListener().onUserCancel(PermissionsActivity.this.scene, (String)tempPermissionList.get(0));
                    PermissionsActivity.this.dialog.dismiss();
                    PermissionsActivity.this.finish();
                }
            });
        }
    }

    private void showMissingPermissionDialog(final String showPermission) {
        this.getDialog(showPermission).show(this.scene, showPermission, this.canCancle, new OnDialogListener(){

            public void onPositiveClick() {
                PermissionsActivity.this.onPermissionDialogPositiveClick(showPermission);
            }

            public void onNegativeClick() {
                PermissionManager.INSTANCE.setUserDenyTime(showPermission);
                PermissionManager.INSTANCE.getPermissionCheckResultListener().onUserCancel(PermissionsActivity.this.scene, showPermission);
                PermissionsActivity.this.finish();
            }

            public void onCancel() {
                PermissionManager.INSTANCE.setUserDenyTime(showPermission);
                PermissionManager.INSTANCE.getPermissionCheckResultListener().onUserCancel(PermissionsActivity.this.scene, showPermission);
                PermissionsActivity.this.finish();
            }
        });
    }

    protected void onPermissionDialogPositiveClick(List<String> tempPermissionList) {
        IntentUtils.startAppDetailSettings((Context)this);
    }

    protected void onPermissionDialogPositiveClick(String showPermission) {
        String permissionSettings = PermissionManager.INSTANCE.getPermissionSettings(showPermission);
        if (!IntentUtils.startAppSettings((Context)this, (String)permissionSettings, (boolean)false) && !IntentUtils.startSettings((Context)this, (String)permissionSettings)) {
            IntentUtils.startAppDetailSettings((Context)this);
        }
    }
}

