/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.okhttp.wrapper.interceptor.data;

import android.os.SystemClock;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RequestTraceTimeRecord
implements Serializable {
    public static String EVENT_CALL_START = "callStart";
    public static String EVENT_CALL_END = "callEnd";
    public static String EVENT_DNS_START = "dnsStart";
    public static String EVENT_DNS_END = "dnsEnd";
    public static String EVENT_CONNECT_START = "connectStart";
    public static String EVENT_SECURE_CONNECT_START = "secureConnectStart";
    public static String EVENT_SECURE_CONNECT_END = "secureConnectEnd";
    public static String EVENT_CONNECT_END = "connectEnd";
    public static String EVENT_REQUEST_BODY_START = "requestBodyStart";
    public static String EVENT_REQUEST_BODY_END = "requestBodyEnd";
    public static String EVENT_REQUEST_HEADERS_START = "requestHeadersStart";
    public static String EVENT_REQUEST_HEADERS_END = "requestHeadersEnd";
    public static String EVENT_RESPONSE_HEADERS_START = "responseHeadersStart";
    public static String EVENT_RESPONSE_HEADERS_END = "responseHeadersEnd";
    public static String EVENT_RESPONSE_BODY_START = "responseBodyStart";
    public static String EVENT_RESPONSE_BODY_END = "responseBodyEnd";
    public static String TRACE_NAME_TOTAL = "Total Time";
    public static String TRACE_NAME_DNS = "DNS";
    public static String TRACE_NAME_SECURE_CONNECT = "Secure Connect";
    public static String TRACE_NAME_CONNECT = "Connect";
    public static String TRACE_NAME_REQUEST_HEADERS = "Request Headers";
    public static String TRACE_NAME_REQUEST_BODY = "Request Body";
    public static String TRACE_NAME_RESPONSE_HEADERS = "Response Headers";
    public static String TRACE_NAME_RESPONSE_BODY = "Response Body";
    private String mTraceRequestId;
    private String mContentRequestId;
    private String mUrl;
    private Map<String, Long> mNetworkEventTimeMap = new HashMap<String, Long>();
    private Map<String, Long> mTtraceDataItemList = new HashMap<String, Long>();

    public String getTraceRequestId() {
        return this.mTraceRequestId;
    }

    public String getContentRequestId() {
        return this.mContentRequestId;
    }

    public void setContentRequestId(String mContentRequestId) {
        this.mContentRequestId = mContentRequestId;
    }

    public void setTraceRequestId(String mRequestId) {
        this.mTraceRequestId = mRequestId;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public Map<String, Long> getNetworkEventTimeMap() {
        return this.mNetworkEventTimeMap;
    }

    public Map<String, Long> getTraceItemList() {
        return this.mTtraceDataItemList;
    }

    public void saveEvent(String eventName) {
        this.mNetworkEventTimeMap.put(eventName, SystemClock.elapsedRealtime());
    }

    public void generateTraceData() {
        this.mTtraceDataItemList.clear();
        this.mTtraceDataItemList.put(TRACE_NAME_TOTAL, this.getEventCostTime(EVENT_CALL_START, EVENT_CALL_END));
        this.mTtraceDataItemList.put(TRACE_NAME_DNS, this.getEventCostTime(EVENT_DNS_START, EVENT_DNS_END));
        this.mTtraceDataItemList.put(TRACE_NAME_SECURE_CONNECT, this.getEventCostTime(EVENT_SECURE_CONNECT_START, EVENT_SECURE_CONNECT_END));
        this.mTtraceDataItemList.put(TRACE_NAME_CONNECT, this.getEventCostTime(EVENT_CONNECT_START, EVENT_CONNECT_END));
        this.mTtraceDataItemList.put(TRACE_NAME_REQUEST_HEADERS, this.getEventCostTime(EVENT_REQUEST_HEADERS_START, EVENT_REQUEST_HEADERS_END));
        this.mTtraceDataItemList.put(TRACE_NAME_REQUEST_BODY, this.getEventCostTime(EVENT_REQUEST_BODY_START, EVENT_REQUEST_BODY_END));
        this.mTtraceDataItemList.put(TRACE_NAME_RESPONSE_HEADERS, this.getEventCostTime(EVENT_RESPONSE_HEADERS_START, EVENT_RESPONSE_HEADERS_END));
        this.mTtraceDataItemList.put(TRACE_NAME_RESPONSE_BODY, this.getEventCostTime(EVENT_RESPONSE_BODY_START, EVENT_RESPONSE_BODY_END));
    }

    public long getEventCostTime(String startName, String endName) {
        if (!this.mNetworkEventTimeMap.containsKey(startName) || !this.mNetworkEventTimeMap.containsKey(endName)) {
            return 0L;
        }
        Long endTime = this.mNetworkEventTimeMap.get(endName);
        Long start = this.mNetworkEventTimeMap.get(startName);
        long result = endTime - start;
        return result;
    }
}

