/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.bihe0832.android.lib.notification.NotifyManager;
import com.bihe0832.android.lib.notification.R;
import com.bihe0832.android.lib.utils.IdGenerator;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import com.bihe0832.android.lib.utils.intent.IntentUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0005J \u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0006J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\u0006J&\u0010\"\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0005J&\u0010\"\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\u0005J<\u0010\"\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00062\b\u0010*\u001a\u0004\u0018\u00010\u00062\b\u0010+\u001a\u0004\u0018\u00010\u00062\b\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u0006J\u000e\u0010,\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/bihe0832/android/lib/notification/NotifyManager;", "", "()V", "mListID", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getMListID", "()Ljava/util/concurrent/ConcurrentHashMap;", "mListID$delegate", "Lkotlin/Lazy;", "mNotificationChannel", "Ljava/util/HashMap;", "Landroid/app/NotificationChannel;", "Lkotlin/collections/HashMap;", "mNotifyIDGenerator", "Lcom/bihe0832/android/lib/utils/IdGenerator;", "areNotificationsEnabled", "", "context", "Landroid/content/Context;", "cancelNotify", "", "noticeID", "createNotificationChannel", "channelName", "", "channelId", "generatorNoticeID", "getNotifyIDByKey", "key", "getPendingIntent", "Landroid/app/PendingIntent;", "action", "sendNotifyNow", "remoteViews", "Landroid/widget/RemoteViews;", "channelID", "notifyID", "notification", "Landroid/app/Notification;", "title", "subTitle", "content", "showNotificationsSettings", "LibNotification_release"})
public final class NotifyManager {
    private static final HashMap<String, NotificationChannel> mNotificationChannel;
    private static final IdGenerator mNotifyIDGenerator;
    private static final Lazy mListID$delegate;
    public static final NotifyManager INSTANCE;

    private final ConcurrentHashMap<Integer, String> getMListID() {
        Lazy lazy = mListID$delegate;
        NotifyManager notifyManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConcurrentHashMap)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized int getNotifyIDByKey(@NotNull String key) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        try {
            int n2;
            if (TextUtils.isEmpty((CharSequence)key)) {
                n2 = this.generatorNoticeID();
            } else if (this.getMListID().containsValue(key)) {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv = this.getMListID();
                boolean $i$f$filter = false;
                Map map = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                void var8_9 = $this$filterTo$iv$iv;
                boolean bl = false;
                Iterator iterator = var8_9.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((String)it.getValue()), (Object)key)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                n2 = ((Number)CollectionsKt.first((Iterable)destination$iv$iv.keySet())).intValue();
            } else {
                n2 = this.generatorNoticeID();
            }
            n = n2;
        }
        catch (Exception e) {
            e.printStackTrace();
            n = this.generatorNoticeID();
        }
        int id2 = n;
        ((Map)this.getMListID()).put(id2, key);
        return id2;
    }

    public final int generatorNoticeID() {
        return mNotifyIDGenerator.generate();
    }

    @Nullable
    public final NotificationChannel createNotificationChannel(@NotNull Context context, @NotNull CharSequence channelName, @NotNull String channelId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)channelName, (String)"channelName");
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        if (BuildUtils.INSTANCE.getSDK_INT() >= 26) {
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(channelId, channelName, importance);
            channel.setSound(null, null);
            channel.enableLights(false);
            channel.enableVibration(false);
            Object object = context.getSystemService("notification");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            ((NotificationManager)object).createNotificationChannel(channel);
            return channel;
        }
        return null;
    }

    @Nullable
    public final PendingIntent getPendingIntent(@NotNull Context context, @Nullable String action) {
        Intent intent;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!TextUtils.isEmpty((CharSequence)action)) {
            Intent intent2;
            try {
                intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)action));
            }
            catch (Exception e) {
                e.printStackTrace();
                intent2 = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            }
            intent = intent2;
        } else {
            intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        }
        Intent intent3 = intent;
        try {
            return PendingIntent.getActivity((Context)context, (int)this.generatorNoticeID(), (Intent)intent3, (int)0x8000000);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final int sendNotifyNow(@NotNull Context context, @NotNull String title, @Nullable String subTitle, @Nullable String content, @Nullable String action, @NotNull String channelID) {
        boolean bl;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)channelID, (String)"channelID");
        int noticeID = this.generatorNoticeID();
        Context context2 = context.getApplicationContext();
        boolean bl2 = false;
        boolean bl3 = false;
        Context context3 = context2;
        boolean bl4 = false;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context3, channelID);
        boolean bl5 = false;
        boolean bl6 = false;
        NotificationCompat.Builder $this$apply = builder;
        boolean bl7 = false;
        $this$apply.setContentTitle((CharSequence)title);
        String string = content;
        if (string != null) {
            charSequence = string;
            bl = false;
            if (charSequence.length() > 0) {
                $this$apply.setContentText((CharSequence)content);
            }
        }
        String string2 = subTitle;
        if (string2 != null) {
            charSequence = string2;
            bl = false;
            if (charSequence.length() > 0) {
                $this$apply.setSubText((CharSequence)subTitle);
            }
        }
        $this$apply.setAutoCancel(true);
        $this$apply.setSmallIcon(R.mipmap.icon);
        $this$apply.setWhen(System.currentTimeMillis());
        $this$apply.setDefaults(1);
        Context context4 = context3;
        Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context");
        $this$apply.setContentIntent(INSTANCE.getPendingIntent(context4, action));
        builder = builder.build();
        bl5 = false;
        bl6 = false;
        NotificationCompat.Builder it = builder;
        boolean bl8 = false;
        NotificationCompat.Builder builder2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"it");
        INSTANCE.sendNotifyNow(context3, channelID, (Notification)builder2, noticeID);
        return noticeID;
    }

    public final void sendNotifyNow(@NotNull Context context, @NotNull RemoteViews remoteViews, @NotNull String channelID, int notifyID) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)remoteViews, (String)"remoteViews");
        Intrinsics.checkParameterIsNotNull((Object)channelID, (String)"channelID");
        Context context2 = context.getApplicationContext();
        boolean bl = false;
        boolean bl2 = false;
        Context context3 = context2;
        boolean bl3 = false;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context3, channelID);
        boolean bl4 = false;
        boolean bl5 = false;
        NotificationCompat.Builder $this$apply = builder;
        boolean bl6 = false;
        $this$apply.setOnlyAlertOnce(true);
        $this$apply.setContent(remoteViews);
        $this$apply.setSmallIcon(R.mipmap.icon);
        $this$apply.setAutoCancel(false);
        $this$apply.setOngoing(false);
        $this$apply.setWhen(System.currentTimeMillis());
        $this$apply.setDefaults(1);
        builder = builder.build();
        bl4 = false;
        bl5 = false;
        NotificationCompat.Builder it = builder;
        boolean bl7 = false;
        Context context4 = context3;
        Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context");
        NotificationCompat.Builder builder2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"it");
        INSTANCE.sendNotifyNow(context4, channelID, (Notification)builder2, notifyID);
    }

    public final void sendNotifyNow(@NotNull Context context, @NotNull String channelID, @NotNull Notification notification, int notifyID) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)channelID, (String)"channelID");
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        if (BuildUtils.INSTANCE.getSDK_INT() >= 26) {
            Map map = mNotificationChannel;
            boolean bl = false;
            Map map2 = map;
            boolean bl2 = false;
            if (!map2.containsKey(channelID)) {
                NotificationChannel notificationChannel = this.createNotificationChannel(context, APKUtils.getAppName((Context)context) + channelID, channelID);
                if (notificationChannel != null) {
                    map = notificationChannel;
                    bl = false;
                    boolean bl3 = false;
                    Map it = map;
                    boolean bl4 = false;
                    mNotificationChannel.put(channelID, (NotificationChannel)it);
                }
            }
        }
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        ((NotificationManager)object).notify(notifyID, notification);
    }

    public final void cancelNotify(@NotNull Context context, int noticeID) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        ((NotificationManager)object).cancel(noticeID);
    }

    public final boolean areNotificationsEnabled(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return BuildUtils.INSTANCE.getSDK_INT() >= 19 ? NotificationManagerCompat.from((Context)context).areNotificationsEnabled() : false;
    }

    public final boolean showNotificationsSettings(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!IntentUtils.startAppDetailSettings((Context)context)) {
            return IntentUtils.startSettings((Context)context, (String)"android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
        }
        return true;
    }

    private NotifyManager() {
    }

    static {
        NotifyManager notifyManager;
        INSTANCE = notifyManager = new NotifyManager();
        mNotificationChannel = new HashMap();
        mNotifyIDGenerator = new IdGenerator(1);
        mListID$delegate = LazyKt.lazy((Function0)mListID.2.INSTANCE);
    }
}

