/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.bihe0832.android.lib.lifecycle.AAFActivityLifecycleChangedListener;
import com.bihe0832.android.lib.lifecycle.ApplicationObserver;
import com.bihe0832.android.lib.log.ZLog;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/bihe0832/android/lib/lifecycle/ActivityObserver;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "TAG", "", "mAAFActivityLifecycleChangedListener", "Lcom/bihe0832/android/lib/lifecycle/AAFActivityLifecycleChangedListener;", "mActivityList", "", "Landroid/app/Activity;", "mSoftReferenceOfCurrentActivity", "Ljava/lang/ref/SoftReference;", "mSoftReferenceOfResumedActivity", "getActivityList", "", "getCurrentActivity", "getCurrentResumedActivity", "hasActivity", "", "cmpName", "onActivityCreated", "", "activity", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "setActivityLifecycleChangedListener", "changedListener", "LibLifecycle_release"})
public final class ActivityObserver
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    public static final String TAG = "ActivityObserver";
    private static final List<Activity> mActivityList;
    private static SoftReference<Activity> mSoftReferenceOfCurrentActivity;
    private static SoftReference<Activity> mSoftReferenceOfResumedActivity;
    private static AAFActivityLifecycleChangedListener mAAFActivityLifecycleChangedListener;
    public static final ActivityObserver INSTANCE;

    @Nullable
    public final Activity getCurrentActivity() {
        SoftReference<Activity> softReference = mSoftReferenceOfCurrentActivity;
        return softReference != null ? softReference.get() : null;
    }

    @Nullable
    public final Activity getCurrentResumedActivity() {
        SoftReference<Activity> softReference = mSoftReferenceOfResumedActivity;
        return softReference != null ? softReference.get() : null;
    }

    @NotNull
    public final List<Activity> getActivityList() {
        return mActivityList;
    }

    public final boolean hasActivity(@NotNull String cmpName) {
        Intrinsics.checkParameterIsNotNull((Object)cmpName, (String)"cmpName");
        Iterable $this$forEach$iv = mActivityList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Activity it = (Activity)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getClass().getName(), (Object)cmpName)) continue;
            return true;
        }
        return false;
    }

    public final void setActivityLifecycleChangedListener(@Nullable AAFActivityLifecycleChangedListener changedListener) {
        mAAFActivityLifecycleChangedListener = changedListener;
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            ZLog.d((String)TAG, (String)("onActivityCreated: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
            mActivityList.add(activity);
            mSoftReferenceOfCurrentActivity = new SoftReference<Activity>(activity);
            AAFActivityLifecycleChangedListener aAFActivityLifecycleChangedListener = mAAFActivityLifecycleChangedListener;
            if (aAFActivityLifecycleChangedListener == null) break block0;
            aAFActivityLifecycleChangedListener.onActivityCreated(activity, savedInstanceState);
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            ZLog.d((String)TAG, (String)("onActivityResumed: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
            mSoftReferenceOfCurrentActivity = new SoftReference<Activity>(activity);
            mSoftReferenceOfResumedActivity = new SoftReference<Activity>(activity);
            AAFActivityLifecycleChangedListener aAFActivityLifecycleChangedListener = mAAFActivityLifecycleChangedListener;
            if (aAFActivityLifecycleChangedListener == null) break block0;
            aAFActivityLifecycleChangedListener.onActivityResumed(activity);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            ZLog.d((String)TAG, (String)("onActivityPaused: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
            AAFActivityLifecycleChangedListener aAFActivityLifecycleChangedListener = mAAFActivityLifecycleChangedListener;
            if (aAFActivityLifecycleChangedListener == null) break block0;
            aAFActivityLifecycleChangedListener.onActivityPaused(activity);
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            ZLog.d((String)TAG, (String)("onActivityStarted: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
            AAFActivityLifecycleChangedListener aAFActivityLifecycleChangedListener = mAAFActivityLifecycleChangedListener;
            if (aAFActivityLifecycleChangedListener == null) break block0;
            aAFActivityLifecycleChangedListener.onActivityStarted(activity);
        }
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            ZLog.d((String)TAG, (String)("onActivityDestroyed: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
            try {
                mActivityList.remove(activity);
                if (mActivityList.size() == 0) {
                    ZLog.d((String)TAG, (String)("app has no activity after onActivityDestroyed: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
                    ApplicationObserver.INSTANCE.onAllActivityDestroyed();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            AAFActivityLifecycleChangedListener aAFActivityLifecycleChangedListener = mAAFActivityLifecycleChangedListener;
            if (aAFActivityLifecycleChangedListener == null) break block3;
            aAFActivityLifecycleChangedListener.onActivityDestroyed(activity);
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
            ZLog.d((String)TAG, (String)("onActivitySaveInstanceState: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
            AAFActivityLifecycleChangedListener aAFActivityLifecycleChangedListener = mAAFActivityLifecycleChangedListener;
            if (aAFActivityLifecycleChangedListener == null) break block0;
            aAFActivityLifecycleChangedListener.onActivitySaveInstanceState(activity, outState);
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            ZLog.d((String)TAG, (String)("onActivityStopped: " + activity.getClass().getSimpleName() + '(' + System.identityHashCode(activity) + ')'));
            AAFActivityLifecycleChangedListener aAFActivityLifecycleChangedListener = mAAFActivityLifecycleChangedListener;
            if (aAFActivityLifecycleChangedListener == null) break block0;
            aAFActivityLifecycleChangedListener.onActivityStopped(activity);
        }
    }

    private ActivityObserver() {
    }

    static {
        ActivityObserver activityObserver;
        INSTANCE = activityObserver = new ActivityObserver();
        boolean bl = false;
        mActivityList = new ArrayList();
    }
}

