/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.immersion;

import android.text.TextUtils;
import com.bihe0832.android.lib.utils.ConvertUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.utils.os.ManufacturerUtil;

class RomType {
    public static final int MIUI = 1;
    public static final int FLYME = 2;
    public static final int ANDROID_NATIVE = 3;
    public static final int NA = 4;
    private static Integer romType;

    RomType() {
    }

    public static int getRomType() {
        if (romType != null) {
            return romType;
        }
        if (RomType.isMIUIV6OrAbove()) {
            romType = 1;
            return romType;
        }
        if (RomType.isFlymeV4OrAbove()) {
            romType = 2;
            return romType;
        }
        if (RomType.isAndroid5OrAbove()) {
            romType = 3;
            return romType;
        }
        romType = 4;
        return romType;
    }

    private static boolean isFlymeV4OrAbove() {
        return RomType.getFlymeVersion() >= 4;
    }

    protected static int getFlymeVersion() {
        String displayId = ManufacturerUtil.INSTANCE.getDISPLAY();
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            displayId = displayId.replaceAll("Flyme", "");
            displayId = displayId.replaceAll("OS", "");
            String version = (displayId = displayId.replaceAll(" ", "")).substring(0, 1);
            if (version != null) {
                return ConvertUtils.parseInt((String)version);
            }
        }
        return -1;
    }

    private static boolean isMIUIV6OrAbove() {
        return ManufacturerUtil.INSTANCE.getMiuiVersionCode() >= 4L;
    }

    private static boolean isAndroid5OrAbove() {
        return BuildUtils.INSTANCE.getSDK_INT() >= 21;
    }
}

