/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.immersion;

import android.annotation.TargetApi;
import android.app.Activity;
import android.view.Window;
import android.view.WindowManager;
import com.bihe0832.android.lib.immersion.RomType;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.utils.os.ManufacturerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class LightStatusBarUtils {
    public static void setLightStatusBar(Activity activity, boolean dark) {
        switch (RomType.getRomType()) {
            case 1: {
                if (ManufacturerUtil.INSTANCE.getMiuiVersionCode() >= 7L) {
                    LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, dark);
                    break;
                }
                LightStatusBarUtils.setMIUILightStatusBar(activity, dark);
                break;
            }
            case 2: {
                LightStatusBarUtils.setFlymeLightStatusBar(activity, dark);
                break;
            }
            case 3: {
                LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, dark);
                break;
            }
        }
    }

    private static boolean setMIUILightStatusBar(Activity activity, boolean darkmode) {
        LightStatusBarUtils.initStatusBarStyle(activity);
        Class<?> clazz = activity.getWindow().getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), darkmode ? darkModeFlag : 0, darkModeFlag);
            return true;
        }
        catch (Exception e) {
            LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, darkmode);
            return false;
        }
    }

    private static boolean setFlymeLightStatusBar(Activity activity, boolean dark) {
        boolean result = false;
        if (activity != null) {
            LightStatusBarUtils.initStatusBarStyle(activity);
            try {
                WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                activity.getWindow().setAttributes(lp);
                result = true;
                if (RomType.getFlymeVersion() >= 7) {
                    LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, dark);
                }
            }
            catch (Exception e) {
                LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, dark);
            }
        }
        return result;
    }

    @TargetApi(value=11)
    private static void setAndroidNativeLightStatusBar(Activity activity, boolean isDarkStatusBarIcon) {
        try {
            Window window = activity.getWindow();
            if (BuildUtils.INSTANCE.getSDK_INT() >= 21) {
                if (isDarkStatusBarIcon) {
                    window.getDecorView().setSystemUiVisibility(9472);
                } else {
                    window.getDecorView().setSystemUiVisibility(1280);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initStatusBarStyle(Activity activity) {
        activity.getWindow().getDecorView().setSystemUiVisibility(1280);
    }
}

