/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.media;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.provider.ZixieFileProvider;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class Media {
    public static final String getZixiePhotosPath(@NotNull Context context) {
        String filePath = ZixieFileProvider.getZixieFilePath((Context)context) + File.separator + Environment.DIRECTORY_PICTURES;
        if (BuildUtils.INSTANCE.getSDK_INT() >= 30) {
            filePath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getPath();
        }
        return FileUtils.INSTANCE.getFolderPathWithSeparator(filePath);
    }

    public static void addPicToPhotos(Context context, String filePath) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        try {
            MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)filePath, (String)"", (String)"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Uri uri = Uri.parse((String)filePath);
        intent.setData(uri);
        context.sendBroadcast(intent);
    }

    public static boolean addVideoToPhotos(Context context, String filePath) {
        File file = new File(filePath);
        if (FileUtils.INSTANCE.checkFileExist(filePath)) {
            ContentValues values = new ContentValues();
            values.put("title", file.getName());
            values.put("_display_name", file.getName());
            values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
            values.put("date_modified", Long.valueOf(System.currentTimeMillis()));
            values.put("date_added", Long.valueOf(System.currentTimeMillis()));
            values.put("_data", file.getAbsolutePath());
            values.put("_size", Long.valueOf(file.length()));
            values.put("mime_type", "video/*");
            Uri uri = context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, values);
            MediaScannerConnection mMediaScanner = new MediaScannerConnection(context, null);
            mMediaScanner.connect();
            if (mMediaScanner != null && mMediaScanner.isConnected()) {
                mMediaScanner.scanFile(file.getAbsolutePath(), "video/*");
            }
            return uri != null;
        }
        return false;
    }

    public static Uri createImageUriAboveAndroidQ(Activity activity, String filePath, String name) {
        ContentValues contentValues = new ContentValues();
        ContentResolver resolver = activity.getContentResolver();
        contentValues.put("_display_name", name);
        contentValues.put("mime_type", "image/*");
        if (filePath != null && !filePath.equals("")) {
            contentValues.put("relative_path", Environment.DIRECTORY_PICTURES + "/" + filePath);
        } else {
            contentValues.put("relative_path", Environment.DIRECTORY_PICTURES);
        }
        return resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
    }

    public static Uri createImageUriForCameraBelowAndroidQ(Activity activity, String filePath, String name) {
        File picFolder = new File(Media.getZixiePhotosPath((Context)activity) + filePath);
        if (FileUtils.INSTANCE.checkAndCreateFolder(picFolder.getAbsolutePath())) {
            File picture = new File(picFolder, name);
            if (Build.VERSION.SDK_INT >= 24) {
                return ZixieFileProvider.getZixieFileProvider((Context)activity, (File)picture);
            }
            return Uri.fromFile((File)picture);
        }
        return null;
    }

    public static Uri createImageUriForCropBelowAndroidQ(Context context, String filePath, String name) {
        File childDir = new File(context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + File.separator + filePath);
        if (FileUtils.INSTANCE.checkAndCreateFolder(childDir.getAbsolutePath())) {
            File picture = new File(childDir, name);
            return Uri.fromFile((File)picture);
        }
        return null;
    }
}

