/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.image;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.image.BitmapUtil;
import com.bihe0832.android.lib.ui.image.R;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class HeadIconBuilder {
    private Context mContext;
    private List<Object> mImageUrls = new ArrayList<Object>();
    private int mDefaultImageResId = R.mipmap.default_head_icon;
    private Map<Integer, Bitmap> mBitmapMap = new HashMap<Integer, Bitmap>();
    private int mBGColor = 0;
    private int mMaxWidth;
    private boolean mNeedCenterCrop = true;
    private int mRowCount;
    private int mColumnCount;
    private int mGap = 6;

    public HeadIconBuilder(Context mContext) {
        this.mContext = mContext;
    }

    public void setImageUrls(List<Object> imageUrls) {
        this.mImageUrls = imageUrls;
    }

    public int getDefaultImage() {
        return this.mDefaultImageResId;
    }

    public void setDefaultImage(int defaultImageResId) {
        this.mDefaultImageResId = defaultImageResId;
    }

    public void setNeedCenterCrop(boolean needCenterCrop) {
        this.mNeedCenterCrop = needCenterCrop;
    }

    public void setBgColor(int bgColor) {
        this.mBGColor = bgColor;
    }

    public void setItemWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public void setGap(int mGap) {
        this.mGap = mGap;
    }

    private void calculateGridParam() {
        int imagesSize = this.getImageListSize();
        if (imagesSize < 3) {
            this.mRowCount = 1;
            this.mColumnCount = imagesSize;
        } else if (imagesSize <= 4) {
            this.mRowCount = 2;
            this.mColumnCount = 2;
        } else {
            this.mRowCount = imagesSize / 3 + (imagesSize % 3 == 0 ? 0 : 1);
            this.mColumnCount = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBitmap(Bitmap bitmap, int position) {
        if (null == this.mBitmapMap) {
            this.mBitmapMap = new HashMap<Integer, Bitmap>();
        }
        Map<Integer, Bitmap> map = this.mBitmapMap;
        synchronized (map) {
            this.mBitmapMap.put(position, bitmap);
        }
    }

    private int getImageListSize() {
        if (this.mImageUrls.size() > 9) {
            return 9;
        }
        return this.mImageUrls.size();
    }

    private Bitmap loadImageBitmap(Object imageUrl, int targetImageItemWidth) throws ExecutionException, InterruptedException {
        RequestOptions options = new RequestOptions().error(this.getDefaultImage());
        if (this.mNeedCenterCrop) {
            options.centerCrop();
        }
        return (Bitmap)Glide.with((Context)this.mContext).asBitmap().load(imageUrl).apply(options).submit(targetImageItemWidth, targetImageItemWidth).get();
    }

    private void loadImageListData(int targetImageItemWidth) {
        Bitmap defaultIcon = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.getDefaultImage());
        for (int i = 0; i < this.getImageListSize(); ++i) {
            try {
                Bitmap bitmap = this.loadImageBitmap(this.mImageUrls.get(i), targetImageItemWidth);
                this.putBitmap(bitmap, i);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.putBitmap(defaultIcon, i);
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                this.putBitmap(defaultIcon, i);
            }
        }
    }

    private void drawDrawable(Canvas canvas, int targetImageItemWidth) {
        canvas.drawColor(this.mBGColor);
        int size = this.getImageListSize();
        int t_center = (this.mMaxWidth + this.mGap) / 2;
        int b_center = (this.mMaxWidth - this.mGap) / 2;
        int l_center = (this.mMaxWidth + this.mGap) / 2;
        int r_center = (this.mMaxWidth - this.mGap) / 2;
        int center = (this.mMaxWidth - targetImageItemWidth) / 2;
        for (int i = 0; i < size; ++i) {
            int rowNum = i / this.mRowCount;
            int columnNum = i % this.mColumnCount;
            int left = (int)((double)targetImageItemWidth * (this.mColumnCount == 1 ? (double)columnNum + 0.5 : (double)columnNum) + (double)(this.mGap * (columnNum + 1)));
            int top = (int)((double)targetImageItemWidth * (this.mColumnCount == 1 ? (double)rowNum + 0.5 : (double)rowNum) + (double)(this.mGap * (rowNum + 1)));
            int right = left + targetImageItemWidth;
            int bottom = top + targetImageItemWidth;
            Bitmap bitmap = this.mBitmapMap.get(i);
            if (size == 1) {
                this.drawBitmapAtPosition(canvas, 0, 0, targetImageItemWidth, targetImageItemWidth, bitmap);
                continue;
            }
            if (size == 2) {
                this.drawBitmapAtPosition(canvas, left, center, right, center + targetImageItemWidth, bitmap);
                continue;
            }
            if (size == 3) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, center, top, center + targetImageItemWidth, bottom, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * i + targetImageItemWidth * (i - 1), t_center, this.mGap * i + targetImageItemWidth * i, t_center + targetImageItemWidth, bitmap);
                continue;
            }
            if (size == 4) {
                this.drawBitmapAtPosition(canvas, left, top, right, bottom, bitmap);
                continue;
            }
            if (size == 5) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, r_center - targetImageItemWidth, r_center - targetImageItemWidth, r_center, r_center, bitmap);
                    continue;
                }
                if (i == 1) {
                    this.drawBitmapAtPosition(canvas, l_center, r_center - targetImageItemWidth, l_center + targetImageItemWidth, r_center, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 1) + targetImageItemWidth * (i - 2), t_center, this.mGap * (i - 1) + targetImageItemWidth * (i - 1), t_center + targetImageItemWidth, bitmap);
                continue;
            }
            if (size == 6) {
                if (i < 3) {
                    this.drawBitmapAtPosition(canvas, this.mGap * (i + 1) + targetImageItemWidth * i, b_center - targetImageItemWidth, this.mGap * (i + 1) + targetImageItemWidth * (i + 1), b_center, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 2) + targetImageItemWidth * (i - 3), t_center, this.mGap * (i - 2) + targetImageItemWidth * (i - 2), t_center + targetImageItemWidth, bitmap);
                continue;
            }
            if (size == 7) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, center, this.mGap, center + targetImageItemWidth, this.mGap + targetImageItemWidth, bitmap);
                    continue;
                }
                if (i > 0 && i < 4) {
                    this.drawBitmapAtPosition(canvas, this.mGap * i + targetImageItemWidth * (i - 1), center, this.mGap * i + targetImageItemWidth * i, center + targetImageItemWidth, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 3) + targetImageItemWidth * (i - 4), t_center + targetImageItemWidth / 2, this.mGap * (i - 3) + targetImageItemWidth * (i - 3), t_center + targetImageItemWidth / 2 + targetImageItemWidth, bitmap);
                continue;
            }
            if (size == 8) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, r_center - targetImageItemWidth, this.mGap, r_center, this.mGap + targetImageItemWidth, bitmap);
                    continue;
                }
                if (i == 1) {
                    this.drawBitmapAtPosition(canvas, l_center, this.mGap, l_center + targetImageItemWidth, this.mGap + targetImageItemWidth, bitmap);
                    continue;
                }
                if (i > 1 && i < 5) {
                    this.drawBitmapAtPosition(canvas, this.mGap * (i - 1) + targetImageItemWidth * (i - 2), center, this.mGap * (i - 1) + targetImageItemWidth * (i - 1), center + targetImageItemWidth, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 4) + targetImageItemWidth * (i - 5), t_center + targetImageItemWidth / 2, this.mGap * (i - 4) + targetImageItemWidth * (i - 4), t_center + targetImageItemWidth / 2 + targetImageItemWidth, bitmap);
                continue;
            }
            if (size != 9) continue;
            this.drawBitmapAtPosition(canvas, left, top, right, bottom, bitmap);
        }
    }

    private void drawBitmapAtPosition(Canvas canvas, int left, int top, int right, int bottom, Bitmap bitmap) {
        if (null == bitmap) {
            bitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.getDefaultImage());
        }
        if (null != bitmap) {
            Rect rect = new Rect(left, top, right, bottom);
            canvas.drawBitmap(bitmap, null, rect, null);
        }
    }

    public Bitmap generateBitmap() {
        this.calculateGridParam();
        int targetImageItemWidth = this.mMaxWidth;
        if (this.getImageListSize() > 1) {
            targetImageItemWidth = (this.mMaxWidth - (this.mColumnCount + 1) * this.mGap) / (this.mColumnCount == 1 ? 2 : this.mColumnCount);
        }
        this.loadImageListData(targetImageItemWidth);
        Bitmap mergeBitmap = Bitmap.createBitmap((int)this.mMaxWidth, (int)this.mMaxWidth, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(mergeBitmap);
        this.drawDrawable(canvas, targetImageItemWidth);
        canvas.save();
        canvas.restore();
        return mergeBitmap;
    }

    public void generateBitmap(final GenerateBitmapCallback call) {
        ThreadManager.getInstance().start(new Runnable(){

            @Override
            public void run() {
                final Bitmap result = HeadIconBuilder.this.generateBitmap();
                final String filePath = BitmapUtil.saveBitmap(HeadIconBuilder.this.mContext, result);
                ThreadManager.getInstance().runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        call.onResult(result, filePath);
                    }
                });
            }
        });
    }

    public static interface GenerateBitmapCallback {
        public void onResult(Bitmap var1, String var2);
    }
}

