/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.image;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.provider.ZixieFileProvider;
import com.bihe0832.android.lib.log.ZLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class BitmapUtil {
    private static final String TAG = "BitmapUtil";

    public static byte[] bitmap2Bytes(Bitmap bm) {
        if (bm == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static synchronized Bitmap getLocalBitmap(Context context, int res, int scale) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = false;
            options.inSampleSize = scale;
            options.inPurgeable = true;
            options.inInputShareable = true;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)res, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BitmapFactory.Options getLocalBitmapOptions(String filePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        try {
            options.inJustDecodeBounds = true;
            options.inDither = true;
            options.inPurgeable = true;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    public static Bitmap getLocalBitmap(String localPath, int reqWidth, int reqHeight, boolean centerInside) {
        Bitmap bitmap = null;
        File file = new File(localPath);
        if (file.exists()) {
            try {
                BitmapFactory.Options options = BitmapUtil.getLocalBitmapOptions(localPath);
                BitmapUtil.calculateInSampleSize(reqWidth, reqHeight, options, centerInside);
                bitmap = BitmapFactory.decodeFile((String)localPath, (BitmapFactory.Options)options);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
        return bitmap;
    }

    public static Bitmap getLocalBitmap(String localPath) {
        Bitmap bitmap = null;
        File file = new File(localPath);
        if (file.exists()) {
            try {
                bitmap = BitmapFactory.decodeFile((String)localPath);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapFactory.Options getLocalBitmapOptions(ContentResolver context, Uri uri) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        InputStream input = null;
        try {
            options.inJustDecodeBounds = true;
            options.inDither = true;
            options.inPurgeable = true;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            input = context.openInputStream(uri);
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getLocalBitmap(ContentResolver context, Uri uri, int reqWidth, int reqHeight, boolean centerInside) {
        Bitmap bitmap = null;
        InputStream input = null;
        try {
            BitmapFactory.Options options = BitmapUtil.getLocalBitmapOptions(context, uri);
            BitmapUtil.calculateInSampleSize(reqWidth, reqHeight, options, centerInside);
            input = context.openInputStream(uri);
            bitmap = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getLocalBitmap(ContentResolver context, Uri uri) {
        Bitmap bitmap = null;
        InputStream input = null;
        try {
            input = context.openInputStream(uri);
            bitmap = BitmapFactory.decodeStream((InputStream)input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bitmap;
    }

    public static Bitmap getViewBitmapData(View view) {
        if (view.getMeasuredWidth() > 0 && view.getMeasuredHeight() > 0) {
            Bitmap mAccBitmap = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas chartCanvas = new Canvas(mAccBitmap);
            view.draw(chartCanvas);
            return mAccBitmap;
        }
        return null;
    }

    public static String getViewBitmap(View view) {
        String filePath = BitmapUtil.saveBitmap(view.getContext(), BitmapUtil.getViewBitmapData(view));
        return filePath;
    }

    public static Bitmap getImageBitmapWithCircleLayer(ImageView view, int color, float startAngle, float sweepAngle) {
        Bitmap originalBitmap = ((BitmapDrawable)view.getDrawable()).getBitmap();
        return BitmapUtil.getBitmapWithCircleLayer(originalBitmap, color, startAngle, sweepAngle);
    }

    public static Bitmap getBitmapWithCircleLayer(Bitmap originalBitmap, int color, float startAngle, float sweepAngle) {
        int width = originalBitmap.getWidth();
        int height = originalBitmap.getHeight();
        Bitmap updatedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(updatedBitmap);
        canvas.drawBitmap(originalBitmap, 0.0f, 0.0f, null);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(color);
        RectF oval2 = new RectF(0.0f, 0.0f, (float)width, (float)width);
        canvas.drawArc(oval2, startAngle, sweepAngle, true, paint);
        return updatedBitmap;
    }

    public static Bitmap getImageBitmapWithLayer(ImageView view, int color, boolean isBackground) {
        Bitmap originalBitmap = ((BitmapDrawable)view.getDrawable()).getBitmap();
        return BitmapUtil.getBitmapWithLayer(originalBitmap, color, isBackground);
    }

    public static Bitmap getBitmapWithLayer(Bitmap originalBitmap, int color, boolean isBackground) {
        int width = originalBitmap.getWidth();
        int height = originalBitmap.getHeight();
        Bitmap updatedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(updatedBitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(color);
        if (isBackground) {
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)width, paint);
        }
        canvas.drawBitmap(originalBitmap, 0.0f, 0.0f, null);
        if (!isBackground) {
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)width, paint);
        }
        return updatedBitmap;
    }

    public static Bitmap getRemoteBitmap(String imgUrl, int width, int height) {
        Bitmap bitmap = null;
        try {
            URL url = new URL(imgUrl);
            InputStream is = url.openStream();
            bitmap = BitmapUtil.getRemoteBitmap(is, width, height);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    private static Bitmap getRemoteBitmap(InputStream is, int width, int height) {
        BufferedInputStream stream = new BufferedInputStream(is);
        stream.mark(4096);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        BitmapUtil.calculateInSampleSize(width, height, options, true);
        try {
            stream.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
    }

    private static void calculateInSampleSize(int reqWidth, int reqHeight, BitmapFactory.Options options, boolean centerInside) {
        BitmapUtil.calculateInSampleSize(reqWidth, reqHeight, options.outWidth, options.outHeight, options, centerInside);
    }

    public static void calculateInSampleSize(int reqWidth, int reqHeight, int width, int height, BitmapFactory.Options options, boolean centerInside) {
        int sampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            if (reqHeight == 0) {
                sampleSize = (int)Math.floor((float)width / (float)reqWidth);
            } else if (reqWidth == 0) {
                sampleSize = (int)Math.floor((float)height / (float)reqHeight);
            } else {
                int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
                int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
                sampleSize = centerInside ? Math.max(heightRatio, widthRatio) : Math.min(heightRatio, widthRatio);
            }
        }
        options.inSampleSize = sampleSize;
        options.inJustDecodeBounds = false;
    }

    public static String saveBitmap(Context context, Bitmap bitmap) {
        String packageName = context.getPackageName();
        String filePath = packageName + "_pic_" + System.currentTimeMillis() + ".png";
        return BitmapUtil.saveBitmapWithName(context, bitmap, filePath);
    }

    public static String saveBitmapWithName(Context context, Bitmap bitmap, String fileName) {
        return BitmapUtil.saveBitmapWithName(context, bitmap, Bitmap.CompressFormat.PNG, fileName, true);
    }

    public static String saveBitmapWithName(Context context, Bitmap bitmap, Bitmap.CompressFormat format, String fileName, boolean forceNew) {
        if (null == context) {
            return "";
        }
        String filePath = ZixieFileProvider.getZixieFilePath((Context)context) + "temp" + File.separator + fileName;
        return BitmapUtil.saveBitmapWithPath(context, bitmap, format, filePath, forceNew);
    }

    public static String saveBitmapWithPath(Context context, Bitmap bitmap, String filePath) {
        return BitmapUtil.saveBitmapWithPath(context, bitmap, Bitmap.CompressFormat.PNG, filePath, true);
    }

    public static String saveBitmapWithPath(Context context, Bitmap bitmap, Bitmap.CompressFormat format, String filePath, boolean forceNew) {
        if (null == context) {
            return "";
        }
        if (null == bitmap) {
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            ZLog.e((String)TAG, (String)("filePath = " + filePath));
            try {
                File file = new File(filePath);
                if (file.exists()) {
                    if (forceNew) {
                        file.delete();
                        file.createNewFile();
                    }
                } else {
                    FileUtils.INSTANCE.checkAndCreateFolder(file.getParent());
                    file.createNewFile();
                }
                FileOutputStream outputStream = new FileOutputStream(file);
                bitmap.compress(format, 100, (OutputStream)outputStream);
                outputStream.flush();
                outputStream.close();
                return filePath;
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
                return "";
            }
        }
        return "";
    }

    public static Bitmap mergeBitmapLine(Bitmap topBitmap, Bitmap bottomBitmap, boolean isBaseMax) {
        if (topBitmap == null || topBitmap.isRecycled() || bottomBitmap == null || bottomBitmap.isRecycled()) {
            ZLog.d((String)TAG, (String)("topBitmap=" + topBitmap + ";bottomBitmap=" + bottomBitmap));
            return null;
        }
        int width = 0;
        width = isBaseMax ? (topBitmap.getWidth() > bottomBitmap.getWidth() ? topBitmap.getWidth() : bottomBitmap.getWidth()) : (topBitmap.getWidth() < bottomBitmap.getWidth() ? topBitmap.getWidth() : bottomBitmap.getWidth());
        Bitmap tempBitmapT = topBitmap;
        Bitmap tempBitmapB = bottomBitmap;
        if (topBitmap.getWidth() != width) {
            tempBitmapT = Bitmap.createScaledBitmap((Bitmap)topBitmap, (int)width, (int)((int)((float)topBitmap.getHeight() * 1.0f / (float)topBitmap.getWidth() * (float)width)), (boolean)false);
        } else if (bottomBitmap.getWidth() != width) {
            tempBitmapB = Bitmap.createScaledBitmap((Bitmap)bottomBitmap, (int)width, (int)((int)((float)bottomBitmap.getHeight() * 1.0f / (float)bottomBitmap.getWidth() * (float)width)), (boolean)false);
        }
        int height = tempBitmapT.getHeight() + tempBitmapB.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Rect topRect = new Rect(0, 0, tempBitmapT.getWidth(), tempBitmapT.getHeight());
        Rect bottomRect = new Rect(0, 0, tempBitmapB.getWidth(), tempBitmapB.getHeight());
        Rect bottomRectT = new Rect(0, tempBitmapT.getHeight(), width, height);
        canvas.drawBitmap(tempBitmapT, topRect, topRect, null);
        canvas.drawBitmap(tempBitmapB, bottomRect, bottomRectT, null);
        return bitmap;
    }

    public static Bitmap mergeBitmapTogether(Bitmap bottomBitmap, Bitmap iconBitmap, boolean isBaseBottom) {
        if (bottomBitmap == null || bottomBitmap.isRecycled() || iconBitmap == null || iconBitmap.isRecycled()) {
            ZLog.d((String)TAG, (String)("topBitmap=" + bottomBitmap + ";bottomBitmap=" + iconBitmap));
            return null;
        }
        int width = iconBitmap.getWidth();
        int height = iconBitmap.getHeight();
        if (isBaseBottom) {
            width = bottomBitmap.getWidth() > iconBitmap.getWidth() ? bottomBitmap.getWidth() : iconBitmap.getWidth();
            height = (int)((float)bottomBitmap.getHeight() * 1.0f / (float)bottomBitmap.getWidth() * (float)width);
        }
        Bitmap tempBitmapIcon = iconBitmap;
        if (iconBitmap.getWidth() != width) {
            tempBitmapIcon = Bitmap.createScaledBitmap((Bitmap)iconBitmap, (int)width, (int)height, (boolean)false);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)bottomBitmap.getWidth(), (int)bottomBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(bottomBitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(tempBitmapIcon, (float)((bottomBitmap.getWidth() - width) / 2), (float)((bottomBitmap.getHeight() - height) / 2), null);
        return bitmap;
    }

    public static Bitmap compress(Bitmap image, long targetSize) {
        int size_length = 10;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        if (10L * targetSize > (long)baos.toByteArray().length) {
            return image;
        }
        int options = 100;
        while (options > 1 && (long)baos.toByteArray().length > 10L * targetSize) {
            options = (int)((float)(10L * targetSize) * 100.0f / (float)baos.toByteArray().length);
            if (options < 0) {
                options = 0;
            }
            ZLog.d((String)TAG, (String)("compress start source length " + baos.toByteArray().length + "; target length:" + 10L * targetSize + "; options:" + options));
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
            ZLog.d((String)TAG, (String)("compress end source length " + baos.toByteArray().length + "; target length:" + 10L * targetSize + "; options:" + options));
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
        return bitmap;
    }

    public static Bitmap rotateBitmapByDegree(Bitmap bm, int degree) {
        Bitmap resultBitmap = null;
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        try {
            resultBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == resultBitmap) {
            resultBitmap = bm;
        }
        if (bm != resultBitmap) {
            bm.recycle();
        }
        return resultBitmap;
    }

    public static Bitmap getBitmapWithRound(Bitmap mBitmap, float roundIndex) {
        Bitmap bitmap = Bitmap.createBitmap((int)mBitmap.getWidth(), (int)mBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Rect rect = new Rect(0, 0, mBitmap.getWidth(), mBitmap.getHeight());
        RectF rectf = new RectF(rect);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(rectf, roundIndex, roundIndex, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(mBitmap, rect, rect, paint);
        return bitmap;
    }
}

