/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.http.common;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.bihe0832.android.lib.http.common.HttpResponseHandler;
import com.bihe0832.android.lib.http.common.core.BaseConnection;
import com.bihe0832.android.lib.http.common.core.FileInfo;
import com.bihe0832.android.lib.http.common.core.HTTPConnection;
import com.bihe0832.android.lib.http.common.core.HTTPSConnection;
import com.bihe0832.android.lib.http.common.core.HttpBasicRequest;
import com.bihe0832.android.lib.http.common.core.HttpFileUpload;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class HTTPServer {
    public static final String LOG_TAG = "bihe0832 REQUEST";
    public static final String BOUNDARY = UUID.randomUUID().toString();
    private static final boolean DEBUG = true;
    private Handler mCallHandler = new Handler(ThreadManager.getInstance().getLooper(2)){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (msg.obj != null && msg.obj instanceof HttpBasicRequest) {
                        HTTPServer.this.executeRequestInExecutor((HttpBasicRequest)msg.obj, false);
                        break;
                    }
                    ZLog.d((String)HTTPServer.LOG_TAG, (String)msg.toString());
                    break;
                }
                case 1: {
                    if (msg.obj != null && msg.obj instanceof HttpBasicRequest) {
                        HTTPServer.this.executeRequestInExecutor((HttpBasicRequest)msg.obj, true);
                        break;
                    }
                    ZLog.d((String)HTTPServer.LOG_TAG, (String)msg.toString());
                    break;
                }
            }
        }
    };
    private static final int MSG_REQUEST_ORIGIN = 0;
    private static final int MSG_REQUEST_CONVERT = 1;
    private static volatile HTTPServer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HTTPServer getInstance() {
        if (instance != null) return instance;
        Class<HTTPServer> clazz = HTTPServer.class;
        synchronized (HTTPServer.class) {
            if (instance != null) return instance;
            instance = new HTTPServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HTTPServer() {
    }

    public String doFileUpload(Context context, String requestUrl, Map<String, String> strParams, List<FileInfo> fileParams) {
        return new HttpFileUpload().postRequest(context, HTTPServer.getInstance().getConnection(requestUrl), strParams, fileParams);
    }

    public void doOriginRequestAsync(HttpBasicRequest request) {
        Message msg = this.mCallHandler.obtainMessage();
        msg.what = 0;
        msg.obj = request;
        this.mCallHandler.sendMessage(msg);
    }

    public void doRequestAsync(HttpBasicRequest request) {
        Message msg = this.mCallHandler.obtainMessage();
        msg.what = 1;
        msg.obj = request;
        this.mCallHandler.sendMessage(msg);
    }

    public String convertOriginToUTF8Data(String source) {
        return this.convertOriginData(source, "UTF-8");
    }

    public String convertOriginData(String source, String charsetName) {
        try {
            return new String(source.getBytes(Charset.forName("ISO-8859-1")), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            ZLog.e((String)LOG_TAG, (String)("convertData data error" + e.toString()));
            return "";
        }
    }

    public String doRequestSync(String url) {
        return this.convertOriginToUTF8Data(this.doOriginRequestSync(url));
    }

    public String doOriginRequestSync(String url) {
        return this.doOriginRequestSync(url, null, "application/x-www-form-urlencoded");
    }

    public String doRequestSync(String url, String params) {
        return this.convertOriginToUTF8Data(this.doOriginRequestSync(url, params));
    }

    public String doOriginRequestSync(String url, String params) {
        byte[] bytes = null;
        try {
            bytes = params.getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.doOriginRequestSync(url, bytes, "application/x-www-form-urlencoded");
    }

    public String doRequestSync(String url, byte[] bytes, String contentType) {
        return this.convertOriginToUTF8Data(this.doOriginRequestSync(url, bytes, contentType));
    }

    public String doOriginRequestSync(final String url, byte[] bytes, String contentType) {
        final String finalContentType = TextUtils.isEmpty((CharSequence)contentType) ? "application/x-www-form-urlencoded" : contentType;
        BaseConnection connection = this.getConnection(url);
        HttpBasicRequest basicRequest = new HttpBasicRequest(){

            @Override
            public String getUrl() {
                return url;
            }

            @Override
            public HttpResponseHandler getResponseHandler() {
                return null;
            }

            @Override
            public String getContentType() {
                return finalContentType;
            }
        };
        if (bytes != null) {
            basicRequest.data = bytes;
        }
        String result = this.executeOriginRequest(basicRequest, connection);
        if (connection.getResponseCode() == 200) {
            return result;
        }
        ZLog.e((String)LOG_TAG, (String)("Code:" + connection.getResponseCode() + ";Messag:" + connection.getResponseMessage()));
        ZLog.e((String)LOG_TAG, (String)"responseBody is null");
        return "";
    }

    private void executeRequestInExecutor(final HttpBasicRequest request, final boolean needConvert) {
        ThreadManager.getInstance().start(new Runnable(){

            @Override
            public void run() {
                HTTPServer.this.executeRequest(request, needConvert);
            }
        });
    }

    private void executeRequest(HttpBasicRequest request, boolean needConvert) {
        String url = request.getUrl();
        BaseConnection connection = this.getConnection(url);
        String result = needConvert ? this.convertOriginToUTF8Data(this.executeOriginRequest(request, connection)) : this.executeOriginRequest(request, connection);
        if (connection.getResponseCode() == 200) {
            request.getResponseHandler().onResponse(connection.getResponseCode(), result);
        } else if (TextUtils.isEmpty((CharSequence)result)) {
            ZLog.e((String)LOG_TAG, (String)request.getClass().getName());
            ZLog.e((String)LOG_TAG, (String)"responseBody is null");
            if (TextUtils.isEmpty((CharSequence)connection.getResponseMessage())) {
                request.getResponseHandler().onResponse(connection.getResponseCode(), "");
            } else {
                request.getResponseHandler().onResponse(connection.getResponseCode(), connection.getResponseMessage());
            }
        } else {
            request.getResponseHandler().onResponse(connection.getResponseCode(), result);
        }
    }

    public BaseConnection getConnection(String url) {
        BaseConnection connection = null;
        connection = url.startsWith("https:") ? new HTTPSConnection(url) : new HTTPConnection(url);
        return connection;
    }

    private String executeOriginRequest(HttpBasicRequest request, BaseConnection connection) {
        String url = request.getUrl();
        ZLog.w((String)LOG_TAG, (String)"=======================================");
        ZLog.w((String)LOG_TAG, (String)request.getClass().toString());
        ZLog.w((String)LOG_TAG, (String)url);
        if (request.data != null) {
            ZLog.w((String)LOG_TAG, (String)new String(request.data));
        }
        ZLog.w((String)LOG_TAG, (String)"=======================================");
        request.setRequestTime(System.currentTimeMillis() / 1000L);
        String result = connection.doRequest(request);
        ZLog.w((String)LOG_TAG, (String)"=======================================");
        ZLog.w((String)LOG_TAG, (String)request.getClass().toString());
        ZLog.w((String)LOG_TAG, (String)result);
        ZLog.w((String)LOG_TAG, (String)String.valueOf(connection.getResponseCode()));
        ZLog.w((String)LOG_TAG, (String)connection.getResponseMessage());
        ZLog.w((String)LOG_TAG, (String)"=======================================");
        return result;
    }
}

