/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.gson;

import android.util.Log;
import com.bihe0832.android.lib.gson.adapter.BooleanTypeAdapter;
import com.bihe0832.android.lib.gson.adapter.DoubleDefaultAdapter;
import com.bihe0832.android.lib.gson.adapter.FloatDefaultAdapter;
import com.bihe0832.android.lib.gson.adapter.IntegerDefaultAdapter;
import com.bihe0832.android.lib.gson.adapter.LongDefaultAdapter;
import com.bihe0832.android.lib.gson.adapter.StringNullAdapter;
import com.bihe0832.android.lib.gson.type.ParameterizedTypeImpl;
import com.bihe0832.android.lib.log.ZLog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n\u00a2\u0006\u0002\u0010\u000bJ)\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n\u00a2\u0006\u0002\u0010\fJ2\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u000e\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00040\nJ*\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u000e\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00040\nJ\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\b\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0014\u001a\u0002H\u0004\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0013\u001a\u0004\u0018\u00010\b\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u0002H\u0004\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/bihe0832/android/lib/gson/JsonHelper;", "", "()V", "fromJson", "T", "gson", "Lcom/google/gson/Gson;", "json", "", "beanClass", "Ljava/lang/Class;", "(Lcom/google/gson/Gson;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fromJsonList", "", "clazz", "getGson", "getGsonBuilder", "Lcom/google/gson/GsonBuilder;", "toJson", "beanObject", "(Ljava/lang/Object;)Ljava/lang/String;", "(Lcom/google/gson/Gson;Ljava/lang/Object;)Ljava/lang/String;", "LibGson_release"})
public final class JsonHelper {
    public static final JsonHelper INSTANCE;

    @NotNull
    public final Gson getGson() {
        Gson gson = this.getGsonBuilder().create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"getGsonBuilder().create()");
        return gson;
    }

    @NotNull
    public final GsonBuilder getGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter((Type)Double.TYPE, (Object)new DoubleDefaultAdapter()).registerTypeAdapter((Type)Double.TYPE, (Object)new DoubleDefaultAdapter()).registerTypeAdapter((Type)Boolean.TYPE, (Object)new BooleanTypeAdapter()).registerTypeAdapter((Type)Boolean.TYPE, (Object)new BooleanTypeAdapter()).registerTypeAdapter((Type)Float.TYPE, (Object)new FloatDefaultAdapter()).registerTypeAdapter((Type)Float.TYPE, (Object)new FloatDefaultAdapter()).registerTypeAdapter((Type)Integer.TYPE, (Object)new IntegerDefaultAdapter()).registerTypeAdapter((Type)Integer.TYPE, (Object)new IntegerDefaultAdapter()).registerTypeAdapter((Type)Long.TYPE, (Object)new LongDefaultAdapter()).registerTypeAdapter((Type)Long.TYPE, (Object)new LongDefaultAdapter()).registerTypeAdapter((Type)((Object)String.class), (Object)new StringNullAdapter());
        Intrinsics.checkExpressionValueIsNotNull((Object)gsonBuilder, (String)"GsonBuilder()\n          \u2026ava, StringNullAdapter())");
        return gsonBuilder;
    }

    @Nullable
    public final <T> String toJson(T beanObject) {
        return this.toJson(this.getGson(), beanObject);
    }

    @Nullable
    public final <T> String toJson(@NotNull Gson gson, T beanObject) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        try {
            return gson.toJson(beanObject);
        }
        catch (Exception e) {
            Log.e((String)"JsonHelper", (String)("JsonParserWrapper toJson error:" + e));
            return null;
        }
    }

    @Nullable
    public final <T> T fromJson(@NotNull String json, @NotNull Class<T> beanClass) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(beanClass, (String)"beanClass");
        return this.fromJson(this.getGson(), json, beanClass);
    }

    @Nullable
    public final <T> T fromJson(@NotNull Gson gson, @NotNull String json, @NotNull Class<T> beanClass) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(beanClass, (String)"beanClass");
        try {
            return (T)gson.fromJson(json, beanClass);
        }
        catch (Exception e) {
            ZLog.e((String)"JsonHelper", (String)"------------------------------------");
            ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper fromJson error:" + e));
            ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper json:" + json));
            ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper beanClass:" + beanClass));
            ZLog.e((String)"JsonHelper", (String)"------------------------------------");
            return null;
        }
    }

    @Nullable
    public final <T> List<T> fromJsonList(@NotNull String json, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.fromJsonList(this.getGson(), json, clazz);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T> List<T> fromJsonList(@NotNull Gson gson, @NotNull String json, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            Type type = new ParameterizedTypeImpl(clazz);
            return (List)gson.fromJson(json, type);
        }
        catch (Exception e) {
            ZLog.e((String)"JsonHelper", (String)"------------------------------------");
            ZLog.e((String)"JsonHelper", (String)"JsonParserWrapper list fromJson Exception:\n");
            ZLog.e((String)"JsonHelper", (String)("\t " + e + " \n"));
            ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper list json:" + json));
            ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper list beanClass:" + clazz));
            ZLog.e((String)"JsonHelper", (String)"------------------------------------");
            try {
                ZLog.e((String)"JsonHelper", (String)"------------------------------------");
                ZLog.e((String)"JsonHelper", (String)"JsonParserWrapper start parse list fromJsonArray");
                boolean bl = false;
                List result = new ArrayList();
                JSONArray jsonArray = new JSONArray(json);
                int n = 0;
                int n2 = jsonArray.length();
                while (n < n2) {
                    void i;
                    T t = this.fromJson(jsonArray.get((int)i).toString(), clazz);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    T it = t;
                    boolean bl4 = false;
                    if (it == null) {
                        ZLog.e((String)"JsonHelper", (String)"JsonParserWrapper parse list result is null");
                        ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper parse list result is null:" + jsonArray.get((int)i).toString()));
                        ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper parse list result is null:" + clazz));
                    } else {
                        result.add(it);
                    }
                    ++i;
                }
                ZLog.e((String)"JsonHelper", (String)"------------------------------------");
                if (result.size() != jsonArray.length()) {
                    ZLog.e((String)"JsonHelper", (String)("JsonParserWrapper parse list :result is " + result.size() + ", but jsonArray is " + jsonArray.length()));
                }
                return result;
            }
            catch (Exception e2) {
                ZLog.e((String)"JsonHelper", (String)"------------------------------------");
                ZLog.e((String)"JsonHelper", (String)"JsonParserWrapper start parse list fromJsonArray Exception:\n");
                ZLog.e((String)"JsonHelper", (String)("\t " + e2 + " \n"));
                ZLog.e((String)"JsonHelper", (String)"------------------------------------");
                boolean bl = false;
                return new ArrayList();
            }
        }
    }

    private JsonHelper() {
    }

    static {
        JsonHelper jsonHelper;
        INSTANCE = jsonHelper = new JsonHelper();
    }
}

