/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.gson.adapter;

import com.bihe0832.android.lib.utils.ConvertUtils;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class BooleanTypeAdapter
extends TypeAdapter<Boolean> {
    public void write(JsonWriter out, Boolean value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(value);
        }
    }

    public Boolean read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        switch (peek) {
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: {
                return in.nextInt() != 0;
            }
            case STRING: {
                return ConvertUtils.parseBoolean((String)in.nextString(), (boolean)false);
            }
        }
        throw new JsonParseException("Expected BOOLEAN or NUMBER but was " + peek);
    }
}

